/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.spi.ElementSource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class SourcesTest {
    @Test
    public void entirelyFilteredSourceShowsAsUnknown() {
        ElementSource source = (ElementSource)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).bind(String.class).toInstance((Object)"Foo");
            }
        }}).getBinding(String.class).getSource();
        Truth.assertThat((Object)source.getDeclaringSource()).isEqualTo((Object)"[unknown source]");
    }

    @Test
    public void unfilteredShowsCorrectly() {
        AbstractModule m = new AbstractModule(){

            protected void configure() {
                this.binder().bind(String.class).toInstance((Object)"Foo");
            }
        };
        ElementSource source = (ElementSource)Guice.createInjector((Module[])new Module[]{m}).getBinding(String.class).getSource();
        StackTraceElement ste = (StackTraceElement)source.getDeclaringSource();
        Truth.assertThat((String)ste.getClassName()).isEqualTo((Object)m.getClass().getName());
        Truth.assertThat((String)ste.getMethodName()).isEqualTo((Object)"configure");
    }
}

