/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.google.inject.spi.Toolable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class ToolStageInjectorTest
extends TestCase {
    protected void setUp() throws Exception {
        Foo.s = null;
        Foo.sm = null;
    }

    public void testToolStageInjectorRestrictions() {
        Injector injector = Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[0]);
        try {
            injector.injectMembers(new Object());
            ToolStageInjectorTest.fail((String)"Non-SPI Injector methods must throw an exception in the TOOL stage.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            injector.getInstance(Injector.class);
            ToolStageInjectorTest.fail((String)"Non-SPI Injector methods must throw an exception in the TOOL stage.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            injector.getInstance(Key.get(Injector.class));
            ToolStageInjectorTest.fail((String)"Non-SPI Injector methods must throw an exception in the TOOL stage.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            injector.getProvider(Injector.class);
            ToolStageInjectorTest.fail((String)"Non-SPI Injector methods must throw an exception in the TOOL stage.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            injector.getProvider(Key.get(Injector.class));
            ToolStageInjectorTest.fail((String)"Non-SPI Injector methods must throw an exception in the TOOL stage.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToolStageDoesntInjectInstances() {
        final Foo foo = new Foo();
        Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestStaticInjection(new Class[]{Foo.class});
                this.requestInjection(foo);
            }
        }});
        ToolStageInjectorTest.assertNull((Object)Foo.s);
        ToolStageInjectorTest.assertNull((Object)Foo.sm);
        ToolStageInjectorTest.assertNull((Object)foo.f);
        ToolStageInjectorTest.assertNull((Object)foo.m);
    }

    public void testToolStageDoesntInjectProviders() {
        final Foo foo = new Foo();
        Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestStaticInjection(new Class[]{Foo.class});
                this.bind(Object.class).toProvider((Provider)foo);
            }
        }});
        ToolStageInjectorTest.assertNull((Object)Foo.s);
        ToolStageInjectorTest.assertNull((Object)Foo.sm);
        ToolStageInjectorTest.assertNull((Object)foo.f);
        ToolStageInjectorTest.assertNull((Object)foo.m);
    }

    public void testToolStageWarnsOfMissingObjectGraph() {
        final Bar bar = new Bar();
        try {
            Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.requestStaticInjection(new Class[]{Bar.class});
                    this.requestInjection(bar);
                }
            }});
            ToolStageInjectorTest.fail((String)"expected exception");
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.toString(), "No implementation for Collection<String> was bound.", "No implementation for Map<String, String> was bound.", "No implementation for List<String> was bound.", "No implementation for Set<String> was bound.");
        }
    }

    public void testToolStageInjectsTooledMethods() {
        final Tooled tooled = new Tooled();
        Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestStaticInjection(new Class[]{Tooled.class});
                this.bind(Object.class).toProvider((Provider)tooled);
            }
        }});
        ToolStageInjectorTest.assertNull((Object)Tooled.s);
        ToolStageInjectorTest.assertNotNull((Object)Tooled.sm);
        ToolStageInjectorTest.assertNull((Object)tooled.f);
        ToolStageInjectorTest.assertNotNull((Object)tooled.m);
    }

    private static class SM {
        private SM() {
        }
    }

    private static class M {
        private M() {
        }
    }

    private static class F {
        private F() {
        }
    }

    private static class S {
        private S() {
        }
    }

    private static class Tooled
    implements Provider<Object> {
        @Inject
        private static S s;
        @Inject
        private F f;
        private M m;
        private static SM sm;

        private Tooled() {
        }

        @Toolable
        @Inject
        void method(M m) {
            this.m = m;
        }

        @Toolable
        @Inject
        static void staticMethod(SM sm) {
            Tooled.sm = sm;
        }

        public Object get() {
            return null;
        }
    }

    private static class Foo
    implements Provider<Object> {
        @Inject
        private static S s;
        @Inject
        private F f;
        private M m;
        private static SM sm;

        private Foo() {
        }

        @Inject
        void method(M m) {
            this.m = m;
        }

        @Inject
        static void staticMethod(SM sm) {
            Tooled.sm = sm;
        }

        public Object get() {
            return null;
        }
    }

    private static class Bar {
        @Inject
        private static List<String> list;
        @Inject
        private Set<String> set;

        private Bar() {
        }

        @Inject
        void method(Collection<String> c) {
        }

        @Inject
        static void staticMethod(Map<String, String> map) {
        }
    }
}

