/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice.bundle;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Random;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class OSGiTestActivator
implements BundleActivator {
    static final Class<?>[] TEST_CLAZZES = new Class[]{A.class, B.class, C.class, D.class};

    public void start(BundleContext context) throws BundleException {
        Bundle bundle = context.getBundle();
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(bundle)});
        Injector aopInjector = Guice.createInjector((Module[])new Module[]{new TestModule(bundle), new InterceptorModule()});
        for (Class<?> api : TEST_CLAZZES) {
            for (Visibility vis : Visibility.values()) {
                injector.getInstance(Key.get(api, (Annotation)Names.named((String)vis.name())));
                aopInjector.getInstance(Key.get(api, (Annotation)Names.named((String)vis.name())));
            }
        }
        injector.getInstance(Random.class);
        aopInjector.getInstance(Random.class);
    }

    public void stop(BundleContext context) {
    }

    static class InterceptorModule
    extends AbstractModule {
        InterceptorModule() {
        }

        protected void configure() {
            this.bindInterceptor((Matcher)new AbstractMatcher<Class<?>>(){

                public boolean matches(Class<?> clazz) {
                    try {
                        int clazzModifiers = clazz.getModifiers();
                        int ctorModifiers = clazz.getConstructor(new Class[0]).getModifiers();
                        return (clazzModifiers & 5) != 0 && (ctorModifiers & 5) != 0;
                    }
                    catch (NoSuchMethodException e) {
                        return false;
                    }
                }
            }, (Matcher)new AbstractMatcher<Method>(){

                public boolean matches(Method method) {
                    int methodModifiers = method.getModifiers();
                    return (methodModifiers & 5) != 0;
                }
            }, new MethodInterceptor[]{new MethodInterceptor(){

                public Object invoke(MethodInvocation mi) throws Throwable {
                    return mi.proceed();
                }
            }});
        }
    }

    static class TestModule
    extends AbstractModule {
        final Bundle bundle;

        TestModule(Bundle bundle) {
            this.bundle = bundle;
        }

        protected void configure() {
            for (Class<?> api : TEST_CLAZZES) {
                for (Visibility visibility : Visibility.values()) {
                    try {
                        String suffix = TEST_CLAZZES[visibility.ordinal()].getSimpleName();
                        Class imp = this.bundle.loadClass(api.getName() + suffix);
                        this.bind(api).annotatedWith((Annotation)Names.named((String)visibility.name())).to(imp);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Unable to load test class", e);
                    }
                }
            }
        }
    }

    static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE_PRIVATE,
        PRIVATE;

    }

    private static class DD
    implements D {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        private DD() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    static class DC
    implements D {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        private DC() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    protected static class DB
    implements D {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        private DB() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    public static class DA
    implements D {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        private DA() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    private static class CD
    implements C {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        CD() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    static class CC
    implements C {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        CC() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    protected static class CB
    implements C {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        CB() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    public static class CA
    implements C {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        CA() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    private static class BD
    implements B {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        protected BD() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    static class BC
    implements B {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        protected BC() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    protected static class BB
    implements B {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        protected BB() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    public static class BA
    implements B {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        protected BA() {
        }

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    private static class AD
    implements A {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    static class AC
    implements A {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    protected static class AB
    implements A {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    public static class AA
    implements A {
        @Inject
        public Undefined a;
        @Inject
        protected Undefined b;
        @Inject
        Undefined c;
        @Inject
        private Undefined d;

        @Inject
        public void setA(Undefined undefined) {
        }

        @Inject
        protected void setB(Undefined undefined) {
        }

        @Inject
        void setC(Undefined undefined) {
        }

        @Inject
        private void setD(Undefined undefined) {
        }
    }

    private static interface D {
    }

    static interface C {
    }

    protected static interface B {
    }

    public static interface A {
    }

    public static class Undefined {
    }
}

