/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.intercept.MethodInterceptor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultMethodInterceptionTest {
    private static final AtomicInteger callCount = new AtomicInteger(0);
    private static final AtomicInteger interceptedCallCount = new AtomicInteger(0);
    private final MethodInterceptor interceptor = invocation -> {
        interceptedCallCount.incrementAndGet();
        return invocation.proceed();
    };

    @Before
    public void checkBytecodeGenIsEnabled() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
    }

    @Before
    public void setUp() throws Exception {
        callCount.set(0);
        interceptedCallCount.set(0);
    }

    @Test
    public void testInterceptedDefaultMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(InterceptMe.class), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
                this.bind(Foo.class).to(NonOverridingFoo.class);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Assert.assertEquals((Object)"Foo", (Object)foo.defaultMethod());
        Assert.assertEquals((long)1L, (long)callCount.get());
        Assert.assertEquals((long)1L, (long)interceptedCallCount.get());
    }

    @Test
    public void testInterceptedDefaultMethod_calledByAnotherMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(InterceptMe.class), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
            }
        }});
        NonOverridingFoo foo = (NonOverridingFoo)injector.getInstance(NonOverridingFoo.class);
        Assert.assertEquals((Object)"NonOverriding-Foo", (Object)foo.methodCallingDefault());
        Assert.assertEquals((long)1L, (long)callCount.get());
        Assert.assertEquals((long)1L, (long)interceptedCallCount.get());
    }

    @Test
    public void testInterceptedDefaultMethod_whenParentClassDefinesNonInterceptedMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(InterceptMe.class), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
                this.bind(Foo.class).to(InheritingFoo.class);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Assert.assertEquals((Object)"BaseClass", (Object)foo.defaultMethod());
        Assert.assertEquals((long)1L, (long)callCount.get());
        Assert.assertEquals((long)0L, (long)interceptedCallCount.get());
    }

    @Test
    public void testInterceptedDefaultMethod_whenParentClassDefinesInterceptedMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(InterceptMe.class), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
                this.bind(Foo.class).to(InheritingFoo2.class);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Assert.assertEquals((Object)"BaseClass2", (Object)foo.defaultMethod());
        Assert.assertEquals((long)1L, (long)callCount.get());
        Assert.assertEquals((long)1L, (long)interceptedCallCount.get());
    }

    @Test
    public void testInterception_ofAllMethodsOnType() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.subclassesOf(Baz.class), Matchers.any(), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
                this.bind(Baz.class).to(BazImpl.class);
            }
        }});
        Baz baz = (Baz)injector.getInstance(Baz.class);
        Assert.assertEquals((Object)"Baz", (Object)baz.doSomething());
        Assert.assertEquals((Object)"BazImpl", (Object)baz.doSomethingElse());
        Assert.assertEquals((long)2L, (long)interceptedCallCount.get());
    }

    @Test
    public void testInterception_ofAllMethodsOnType_interceptsInheritedDefaultMethod() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.subclassesOf(BazImpl.class), Matchers.any(), new MethodInterceptor[]{DefaultMethodInterceptionTest.this.interceptor});
                this.bind(Baz.class).to(BazImpl.class);
            }
        }});
        Baz baz = (Baz)injector.getInstance(Baz.class);
        Assert.assertEquals((Object)"Baz", (Object)baz.doSomething());
        Assert.assertEquals((Object)"BazImpl", (Object)baz.doSomethingElse());
        Assert.assertEquals((long)2L, (long)interceptedCallCount.get());
    }

    public static class BazImpl
    implements Baz {
        @Override
        public String doSomethingElse() {
            return "BazImpl";
        }
    }

    public static interface Baz {
        default public String doSomething() {
            return "Baz";
        }

        public String doSomethingElse();
    }

    public static class InheritingFoo2
    extends BaseClass2
    implements Foo {
    }

    public static class BaseClass2 {
        @InterceptMe
        public String defaultMethod() {
            callCount.incrementAndGet();
            return "BaseClass2";
        }
    }

    public static class InheritingFoo
    extends BaseClass
    implements Foo {
    }

    public static class BaseClass {
        public String defaultMethod() {
            callCount.incrementAndGet();
            return "BaseClass";
        }
    }

    public static class NonOverridingFoo
    implements Foo {
        public String methodCallingDefault() {
            return "NonOverriding-" + this.defaultMethod();
        }
    }

    public static interface Foo {
        @InterceptMe
        default public String defaultMethod() {
            callCount.incrementAndGet();
            return "Foo";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface InterceptMe {
    }
}

