/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class GenericInjectionTest
extends TestCase {
    public void testGenericInjection() throws CreationException {
        final List<String> names = Arrays.asList("foo", "bar", "bob");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<List<String>>(this){}).toInstance((Object)names);
            }
        }});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        GenericInjectionTest.assertEquals(names, foo.names);
    }

    public void testImplicitBindingOfGenericType() {
        Parameterized parameterized = (Parameterized)Guice.createInjector((Module[])new Module[0]).getInstance(Key.get((TypeLiteral)new TypeLiteral<Parameterized<String>>(this){}));
        GenericInjectionTest.assertNotNull((Object)parameterized);
    }

    public void testExplicitBindingOfGenericType() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Key.get((TypeLiteral)new TypeLiteral<Parameterized<String>>(this){})).to(Parameterized.class);
            }
        }});
        Parameterized parameterized = (Parameterized)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Parameterized<String>>(this){}));
        GenericInjectionTest.assertNotNull((Object)parameterized);
    }

    public void testInjectingParameterizedDependenciesForImplicitBinding() {
        this.assertParameterizedDepsInjected(new Key<ParameterizedDeps<String, Integer>>(this){}, Modules.EMPTY_MODULE);
    }

    public void testInjectingParameterizedDependenciesForBindingTarget() {
        TypeLiteral<ParameterizedDeps<String, Integer>> type = new TypeLiteral<ParameterizedDeps<String, Integer>>(this){};
        this.assertParameterizedDepsInjected(Key.get(Object.class), (Module)new AbstractModule(this, (TypeLiteral)type){
            final /* synthetic */ TypeLiteral val$type;
            {
                this.val$type = typeLiteral;
            }

            protected void configure() {
                this.bind(Object.class).to(this.val$type);
            }
        });
    }

    public void testInjectingParameterizedDependenciesForBindingSource() {
        TypeLiteral<ParameterizedDeps<String, Integer>> type = new TypeLiteral<ParameterizedDeps<String, Integer>>(this){};
        this.assertParameterizedDepsInjected(Key.get((TypeLiteral)type), (Module)new AbstractModule(this, (TypeLiteral)type){
            final /* synthetic */ TypeLiteral val$type;
            {
                this.val$type = typeLiteral;
            }

            protected void configure() {
                this.bind(this.val$type);
            }
        });
    }

    public void testBindingToSubtype() {
        TypeLiteral<ParameterizedDeps<String, Integer>> type = new TypeLiteral<ParameterizedDeps<String, Integer>>(this){};
        this.assertParameterizedDepsInjected(Key.get((TypeLiteral)type), (Module)new AbstractModule(this, (TypeLiteral)type){
            final /* synthetic */ TypeLiteral val$type;
            {
                this.val$type = typeLiteral;
            }

            protected void configure() {
                this.bind(this.val$type).to((TypeLiteral)new TypeLiteral<SubParameterizedDeps<String, Long, Integer>>(this){});
            }
        });
    }

    public void testBindingSubtype() {
        TypeLiteral<SubParameterizedDeps<String, Long, Integer>> type = new TypeLiteral<SubParameterizedDeps<String, Long, Integer>>(this){};
        this.assertParameterizedDepsInjected(Key.get((TypeLiteral)type), (Module)new AbstractModule(this, (TypeLiteral)type){
            final /* synthetic */ TypeLiteral val$type;
            {
                this.val$type = typeLiteral;
            }

            protected void configure() {
                this.bind(this.val$type);
            }
        });
    }

    public void assertParameterizedDepsInjected(Key<?> key, Module bindingModule) {
        AbstractModule bindDataModule = new AbstractModule(this){

            @Provides
            Map<String, Integer> provideMap() {
                return ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2);
            }

            @Provides
            Set<String> provideSet(Map<String, Integer> map) {
                return map.keySet();
            }

            @Provides
            Collection<Integer> provideCollection(Map<String, Integer> map) {
                return map.values();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{bindDataModule, bindingModule});
        ParameterizedDeps parameterizedDeps = (ParameterizedDeps)injector.getInstance(key);
        GenericInjectionTest.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)2), (Object)parameterizedDeps.map);
        GenericInjectionTest.assertEquals((Object)ImmutableSet.of((Object)"one", (Object)"two"), (Object)parameterizedDeps.keys);
        GenericInjectionTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2), (Object)ImmutableSet.copyOf((Collection)parameterizedDeps.values));
    }

    public void testImmediateTypeVariablesAreInjected() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"tee");
            }
        }});
        InjectsT injectsT = (InjectsT)injector.getInstance((Key)new Key<InjectsT<String>>(this){});
        GenericInjectionTest.assertEquals((String)"tee", (String)((String)injectsT.t));
    }

    static class InjectsT<T> {
        @Inject
        T t;

        InjectsT() {
        }
    }

    static class ParameterizedDeps<K, V> {
        @Inject
        private Map<K, V> map;
        private Set<K> keys;
        private Collection<V> values;

        @Inject
        ParameterizedDeps(Set<K> keys) {
            this.keys = keys;
        }

        @Inject
        void method(Collection<V> values) {
            this.values = values;
        }
    }

    static class SubParameterizedDeps<A, B, C>
    extends ParameterizedDeps<A, C> {
        @Inject
        SubParameterizedDeps(Set<A> keys) {
            super(keys);
        }
    }

    static class Parameterized<T> {
        @Inject
        Parameterized() {
        }
    }

    static class Foo {
        @Inject
        List<String> names;

        Foo() {
        }
    }
}

