/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IntegrationTest {
    @Test
    public void testIntegration() throws CreationException {
        final CountingInterceptor counter = new CountingInterceptor();
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                this.bind(Foo.class);
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{counter});
            }
        };
        if (InternalFlags.isBytecodeGenEnabled()) {
            Injector injector = Guice.createInjector((Module[])new Module[]{module});
            Foo foo = (Foo)injector.getInstance(Key.get(Foo.class));
            foo.foo();
            Assert.assertTrue((boolean)foo.invoked);
            Assert.assertEquals((long)1L, (long)counter.count);
            foo = (Foo)injector.getInstance(Foo.class);
            foo.foo();
            Assert.assertTrue((boolean)foo.invoked);
            Assert.assertEquals((long)2L, (long)counter.count);
        } else {
            CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> IntegrationTest.lambda$testIntegration$0((Module)module));
            Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Binding interceptor is not supported when bytecode generation is disabled.");
        }
    }

    private static /* synthetic */ void lambda$testIntegration$0(Module module) throws Throwable {
        Guice.createInjector((Module[])new Module[]{module});
    }

    static class CountingInterceptor
    implements MethodInterceptor {
        int count;

        CountingInterceptor() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            ++this.count;
            return methodInvocation.proceed();
        }
    }

    public static class Foo {
        boolean invoked;

        public void foo() {
            this.invoked = true;
        }
    }
}

