/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.ElementSource;
import com.google.inject.util.Modules;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class ModulesTest
extends TestCase {
    public void testCombineVarargs() {
        Module combined = Modules.combine((Module[])new Module[]{this.newModule(1), this.newModule(2L), this.newModule((short)3)});
        Injector injector = Guice.createInjector((Module[])new Module[]{combined});
        ModulesTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Integer.class)));
        ModulesTest.assertEquals((long)2L, (long)((Long)injector.getInstance(Long.class)));
        ModulesTest.assertEquals((int)3, (int)((Short)injector.getInstance(Short.class)).shortValue());
    }

    public void testCombineIterable() {
        List<Module> modules = Arrays.asList(this.newModule(1), this.newModule(2L), this.newModule((short)3));
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.combine(modules)});
        ModulesTest.assertEquals((int)1, (int)((Integer)injector.getInstance(Integer.class)));
        ModulesTest.assertEquals((long)2L, (long)((Long)injector.getInstance(Long.class)));
        ModulesTest.assertEquals((int)3, (int)((Short)injector.getInstance(Short.class)).shortValue());
    }

    public void testCombineSources() {
        Module m1 = this.newModule(1);
        Module m2 = this.newModule(2L);
        final Module combined1 = Modules.combine((Module[])new Module[]{m1, m2});
        AbstractModule skipSourcesModule = new AbstractModule(this){

            protected void configure() {
                this.install(combined1);
            }
        };
        Module combined2 = Modules.combine((Module)skipSourcesModule);
        Injector injector = Guice.createInjector((Module[])new Module[]{combined2});
        ElementSource source = (ElementSource)injector.getBinding(Integer.class).getSource();
        ModulesTest.assertEquals((int)3, (int)source.getModuleClassNames().size());
        ModulesTest.assertEquals((Object)ImmutableList.of((Object)m1.getClass().getName(), (Object)combined1.getClass().getName(), (Object)skipSourcesModule.getClass().getName()), (Object)source.getModuleClassNames());
        StackTraceElement stackTraceElement = (StackTraceElement)source.getDeclaringSource();
        ModulesTest.assertEquals((String)skipSourcesModule.getClass().getName(), (String)stackTraceElement.getClassName());
    }

    private <T> Module newModule(final T toBind) {
        return new AbstractModule(this){

            protected void configure() {
                Class<?> tClass = toBind.getClass();
                this.binder().skipSources(new Class[]{((Object)((Object)this)).getClass()}).bind(tClass).toInstance(toBind);
            }
        };
    }
}

