/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import junit.framework.TestCase;

public class OptionalBindingTest
extends TestCase {
    private static final A injectA = new A(){};
    private static final B injectB = new B(){};
    private static final C injectC = new C(){};
    private static final D injectD = new D(){};
    private static final E injectE = new E(){};
    private static final F injectF = new F(){};
    private static final G injectG = new G(){};
    private Module everythingModule = new AbstractModule(this){

        protected void configure() {
            this.bind(A.class).toInstance((Object)injectA);
            this.bind(B.class).toInstance((Object)injectB);
            this.bind(C.class).toInstance((Object)injectC);
            this.bind(D.class).toInstance((Object)injectD);
            this.bind(E.class).annotatedWith((Annotation)Names.named((String)"e")).toInstance((Object)injectE);
            this.bind(F.class).toInstance((Object)injectF);
            this.bind(G.class).toInstance((Object)injectG);
        }
    };
    private Module partialModule = new AbstractModule(this){

        protected void configure() {
            this.bind(C.class).toInstance((Object)new C(this){});
        }
    };
    private Module toInstanceModule = new AbstractModule(this){

        protected void configure() {
            this.bind(HasOptionalInjections.class).toInstance((Object)new HasOptionalInjections());
        }
    };
    private Module toProviderInstanceModule = new AbstractModule(this){

        protected void configure() {
            this.bind(HasOptionalInjections.class).toProvider((Provider)new HasOptionalInjectionsProvider());
        }
    };
    private Module toProviderModule = new AbstractModule(this){

        protected void configure() {
            this.bind(HasOptionalInjections.class).toProvider(HasOptionalInjectionsProvider.class);
        }
    };
    @Inject(optional=true)
    static A staticInjectA;

    public void testEverythingInjectorGetInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.everythingModule}).getInstance(HasOptionalInjections.class)).assertEverythingInjected();
    }

    public void testPartialInjectorGetInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.partialModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testNothingInjectorGetInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[0]).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testEverythingInjectorInjectMembers() {
        HasOptionalInjections instance = new HasOptionalInjections();
        Guice.createInjector((Module[])new Module[]{this.everythingModule}).injectMembers((Object)instance);
        instance.assertEverythingInjected();
    }

    public void testPartialInjectorInjectMembers() {
        HasOptionalInjections instance = new HasOptionalInjections();
        Guice.createInjector((Module[])new Module[]{this.partialModule}).injectMembers((Object)instance);
        instance.assertNothingInjected();
    }

    public void testNothingInjectorInjectMembers() {
        HasOptionalInjections instance = new HasOptionalInjections();
        Guice.createInjector((Module[])new Module[0]).injectMembers((Object)instance);
        instance.assertNothingInjected();
    }

    public void testEverythingInjectorToInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.everythingModule, this.toInstanceModule}).getInstance(HasOptionalInjections.class)).assertEverythingInjected();
    }

    public void testPartialInjectorToInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.partialModule, this.toInstanceModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testNothingInjectorToInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.toInstanceModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testEverythingInjectorToProviderInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.everythingModule, this.toProviderInstanceModule}).getInstance(HasOptionalInjections.class)).assertEverythingInjected();
    }

    public void testPartialInjectorToProviderInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.partialModule, this.toProviderInstanceModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testNothingInjectorToProviderInstance() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.toProviderInstanceModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testEverythingInjectorToProvider() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.everythingModule, this.toProviderModule}).getInstance(HasOptionalInjections.class)).assertEverythingInjected();
    }

    public void testPartialInjectorToProvider() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.partialModule, this.toProviderModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testNothingInjectorToProvider() {
        ((HasOptionalInjections)Guice.createInjector((Module[])new Module[]{this.toProviderModule}).getInstance(HasOptionalInjections.class)).assertNothingInjected();
    }

    public void testOptionalConstructorBlowsUp() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(HasOptionalConstructor.class);
            OptionalBindingTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "OptionalBindingTest$HasOptionalConstructor.<init>() is annotated @Inject(optional=true), but constructors cannot be optional.");
        }
    }

    public void testStaticInjection() {
        staticInjectA = injectA;
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.requestStaticInjection(new Class[]{OptionalBindingTest.class});
            }
        }});
        OptionalBindingTest.assertSame((Object)staticInjectA, (Object)injectA);
    }

    public void testIndirectOptionalInjection() {
        Indirect indirect = (Indirect)Guice.createInjector((Module[])new Module[0]).getInstance(Indirect.class);
        OptionalBindingTest.assertNotNull((Object)indirect.hasOptionalInjections);
        indirect.hasOptionalInjections.assertNothingInjected();
    }

    static interface G {
    }

    static interface F {
    }

    static interface E {
    }

    static interface D {
    }

    static interface C {
    }

    static interface B {
    }

    static interface A {
    }

    static class Indirect {
        @Inject
        HasOptionalInjections hasOptionalInjections;

        Indirect() {
        }
    }

    static class HasOptionalConstructor {
        @Inject(optional=true)
        HasOptionalConstructor() {
        }
    }

    static class HasOptionalInjectionsProvider
    extends HasOptionalInjections
    implements Provider<HasOptionalInjections> {
        HasOptionalInjectionsProvider() {
        }

        public HasOptionalInjections get() {
            return this;
        }
    }

    static class HasOptionalInjections {
        A originalA;
        @Inject(optional=true)
        A a;
        B b;
        C c;
        D d;
        E e;
        @Inject(optional=true)
        Provider<F> fProvider;
        Provider<G> gProvider;
        boolean invoked0;
        boolean invoked1;
        boolean invoked2;
        boolean invokedAnnotated;
        boolean invokeProvider;

        HasOptionalInjections() {
            this.a = this.originalA = new A(this){};
        }

        @Inject(optional=true)
        void methodInjectZeroArguments() {
            this.invoked0 = true;
        }

        @Inject(optional=true)
        void methodInjectOneArgument(B b) {
            this.b = b;
            this.invoked1 = true;
        }

        @Inject(optional=true)
        void methodInjectTwoArguments(C c, D d) {
            this.c = c;
            this.d = d;
            this.invoked2 = true;
        }

        @Inject(optional=true)
        void methodInjectAnnotated(@Named(value="e") E e) {
            this.e = e;
            this.invokedAnnotated = true;
        }

        @Inject(optional=true)
        void methodInjectProvider(Provider<G> gProvider) {
            this.gProvider = gProvider;
            this.invokeProvider = true;
        }

        void assertNothingInjected() {
            TestCase.assertSame((Object)this.originalA, (Object)this.a);
            TestCase.assertNull((Object)this.b);
            TestCase.assertNull((Object)this.c);
            TestCase.assertNull((Object)this.d);
            TestCase.assertNull((Object)this.e);
            TestCase.assertNull(this.fProvider);
            TestCase.assertNull(this.gProvider);
            TestCase.assertTrue((boolean)this.invoked0);
            TestCase.assertFalse((boolean)this.invoked1);
            TestCase.assertFalse((boolean)this.invoked2);
            TestCase.assertFalse((boolean)this.invokedAnnotated);
        }

        public void assertEverythingInjected() {
            TestCase.assertNotSame((Object)injectA, (Object)this.originalA);
            TestCase.assertSame((Object)injectA, (Object)this.a);
            TestCase.assertSame((Object)injectB, (Object)this.b);
            TestCase.assertSame((Object)injectC, (Object)this.c);
            TestCase.assertSame((Object)injectD, (Object)this.d);
            TestCase.assertSame((Object)injectE, (Object)this.e);
            TestCase.assertSame((Object)injectF, (Object)this.fProvider.get());
            TestCase.assertSame((Object)injectG, (Object)this.gProvider.get());
            TestCase.assertTrue((boolean)this.invoked0);
            TestCase.assertTrue((boolean)this.invoked1);
            TestCase.assertTrue((boolean)this.invoked2);
            TestCase.assertTrue((boolean)this.invokedAnnotated);
        }
    }
}

