/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.internal.Messages;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import junit.framework.TestCase;

public class ProvisionExceptionsTest
extends TestCase {
    public void testConstructorRuntimeException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"runtime")).to(true);
                this.bind(Exploder.class).to(Explosion.class);
                this.bind(Tracer.class).to(TracerImpl.class);
            }
        }});
        try {
            injector.getInstance(Tracer.class);
            ProvisionExceptionsTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInjectingConstructor]: IllegalStateException: boom!");
            ProvisionExceptionsTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, pe.getCause().getClass());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, Messages.getOnlyCause((Collection)pe.getErrorMessages()).getClass());
        }
    }

    public void testConstructorCheckedException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"runtime")).to(false);
                this.bind(Exploder.class).to(Explosion.class);
                this.bind(Tracer.class).to(TracerImpl.class);
            }
        }});
        try {
            injector.getInstance(Tracer.class);
            ProvisionExceptionsTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "[Guice/ErrorInjectingConstructor]: IOException: boom!");
            ProvisionExceptionsTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            ProvisionExceptionsTest.assertEquals(IOException.class, pe.getCause().getClass());
            ProvisionExceptionsTest.assertEquals(IOException.class, Messages.getOnlyCause((Collection)pe.getErrorMessages()).getClass());
        }
    }

    public void testCustomProvidersRuntimeException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Exploder.class).toProvider((Provider)new Provider<Exploder>(this){

                    public Exploder get() {
                        return Explosion.createRuntime();
                    }
                });
                this.bind(Tracer.class).to(TracerImpl.class);
            }
        }});
        try {
            injector.getInstance(Tracer.class);
            ProvisionExceptionsTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInCustomProvider]: IllegalStateException: boom!");
            ProvisionExceptionsTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, pe.getCause().getClass());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, Messages.getOnlyCause((Collection)pe.getErrorMessages()).getClass());
        }
    }

    public void testProviderMethodRuntimeException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Tracer.class).to(TracerImpl.class);
            }

            @Provides
            Exploder exploder() {
                return Explosion.createRuntime();
            }
        }});
        try {
            injector.getInstance(Tracer.class);
            ProvisionExceptionsTest.fail();
        }
        catch (ProvisionException pe) {
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInCustomProvider]: IllegalStateException: boom!");
            ProvisionExceptionsTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, pe.getCause().getClass());
            ProvisionExceptionsTest.assertEquals(IllegalStateException.class, Messages.getOnlyCause((Collection)pe.getErrorMessages()).getClass());
        }
    }

    public void testProviderMethodCheckedException() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Tracer.class).to(TracerImpl.class);
            }

            @Provides
            Exploder exploder() throws IOException {
                return Explosion.createChecked();
            }
        }});
        try {
            injector.getInstance(Tracer.class);
            ProvisionExceptionsTest.fail();
        }
        catch (ProvisionException pe) {
            pe.printStackTrace();
            Asserts.assertContains(pe.getMessage(), "1) [Guice/ErrorInCustomProvider]: IOException: boom!");
            ProvisionExceptionsTest.assertEquals((int)1, (int)pe.getErrorMessages().size());
            ProvisionExceptionsTest.assertEquals(IOException.class, pe.getCause().getClass());
            ProvisionExceptionsTest.assertEquals(IOException.class, Messages.getOnlyCause((Collection)pe.getErrorMessages()).getClass());
        }
    }

    private static class TracerImpl
    implements Tracer {
        @Inject
        TracerImpl(Exploder explosion) {
        }
    }

    private static interface Tracer {
    }

    public static class Explosion
    implements Exploder {
        @Inject
        public Explosion(@Named(value="runtime") boolean runtime) throws IOException {
            if (runtime) {
                throw new IllegalStateException("boom!");
            }
            throw new IOException("boom!");
        }

        public static Explosion createRuntime() {
            try {
                return new Explosion(true);
            }
            catch (IOException iox) {
                throw new RuntimeException();
            }
        }

        public static Explosion createChecked() throws IOException {
            return new Explosion(false);
        }
    }

    private static interface Exploder {
    }
}

