/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.RestrictedBindingSource;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.util.Modules;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RestrictedBindingSourceTest {
    private static final String BINDING_PERMISSION_ERROR = "Unable to bind key";
    private static final String USE_NETWORK_MODULE = "Please install NetworkModule.";
    private static final String USE_ROUTING_MODULE = "Please install RoutingModule.";
    private static final String NETWORK_ANNOTATION_IS_RESTRICTED = "The @Network annotation can only be used to annotate Network library Keys.";
    private static final String USE_DNS_MODULE = "Use the official DNS module";

    @Test
    public void networkLibraryCanProvideItsBindings() {
        Guice.createInjector((Module[])new Module[]{new NetworkModule()});
    }

    @Test
    public void networkBindingCantBeProvidedByOtherModules() {
        AbstractModule rogueModule = new AbstractModule(this){

            @Provides
            @GatewayIpAdress
            int provideGatewayIp() {
                return 42;
            }

            protected void configure() {
                this.install((Module)new RoutingModule());
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void missingImplementationErrorForRestrictedBindingIncludesExplanation() {
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{new RoutingModule()});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"Hint: This key is restricted and cannot be bound directly. Restriction explanation: Please install NetworkModule.");
    }

    @Test
    public void canBindRestrictedTypeWithUnrestrictedQualifierAnnotation() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            @Named(value="custom")
            RoutingTable provideRoutingTable() {
                return ip -> ip;
            }
        }});
    }

    @Test
    public void twoRogueNetworkBindingsYieldTwoErrorMessages() {
        AbstractModule rogueModule = new AbstractModule(this){

            @Provides
            @GatewayIpAdress
            int provideGatewayIp() {
                return 42;
            }

            @Provides
            RoutingTable provideRoutingTable() {
                return destinationIp -> 0;
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_ROUTING_MODULE);
    }

    @Test
    public void bindingWithTwoPermitsAllowedIfOnePresent() {
        Guice.createInjector((Module[])new Module[]{new TestMacAddressModule()});
    }

    @Test
    public void untargettedBindingAllowedWithPermit() {
        @NetworkLibrary
        class PermittedNetworkModule
        extends AbstractModule {
            PermittedNetworkModule(RestrictedBindingSourceTest this$0) {
            }

            protected void configure() {
                this.bind(RoutingTable.class);
            }
        }
        Guice.createInjector((Module[])new Module[]{new PermittedNetworkModule(this)});
    }

    @Test
    public void untargettedBindingDisallowedWithoutPermit() {
        AbstractModule rogueModule = new AbstractModule(this){

            protected void configure() {
                this.bind(RoutingTable.class);
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_ROUTING_MODULE);
    }

    @Test
    public void permitOnAnonymousClassWorks() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            @Foo
            String provideFooString() {
                return "foo";
            }
        }});
    }

    @Test
    public void rogueBindingWithWarningRestrictionLevel() {
        Logger logger = Logger.getLogger(RestrictedBindingSource.class.getName());
        TestLogHandler testLogHandler = new TestLogHandler();
        logger.addHandler((Handler)testLogHandler);
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            @Provides
            @HostIp
            int provideRogueHostIp() {
                return 4;
            }
        }});
        List logs = testLogHandler.getStoredLogRecords();
        Truth.assertThat((Iterable)logs).hasSize(1);
        Truth.assertThat((Object)((LogRecord)logs.get(0)).getLevel()).isEqualTo((Object)Level.WARNING);
        Truth.assertThat((String)((LogRecord)logs.get(0)).getMessage()).contains((CharSequence)USE_NETWORK_MODULE);
        Truth.assertThat((String)((LogRecord)logs.get(0)).getMessage()).contains((CharSequence)"provideRogueHostIp");
        logger.removeHandler((Handler)testLogHandler);
    }

    @Test
    public void exemptModulesCanCreateRestrictedBinding() {
        Guice.createInjector((Module[])new Module[]{new FooRogueDnsModule()});
        Guice.createInjector((Module[])new Module[]{new BarRogueDnsModule()});
    }

    @Test
    public void nonExemptModuleCantCreateRestrictedBinding() {
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{new BazRogueDnsModule()});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_DNS_MODULE);
    }

    @Test
    public void parentModuleExeptionAppliesToChildPrivateModule() {
        Guice.createInjector((Module[])new Module[]{new TopLevelModulePrivatelyBindingDnsAddress()});
    }

    @Test
    public void exemptModuleCanBeOverridenIfRestrictedBindingIsNotOverriden() {
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.install((Module)new BarRogueDnsModule());
            }

            @Provides
            String random() {
                return "foo";
            }
        }}).with(new Module[]{new AbstractModule(this){

            @Provides
            String random() {
                return "bar";
            }
        }})});
    }

    @Test
    public void permittedModuleCanWithSourceAnUnpermittedModuleMethod() {
        Guice.createInjector((Module[])new Module[]{new PermittedModule()});
    }

    @Test
    public void unpermittedModuleCantWithSourceAPermittedModule() {
        AbstractModule rogueModule = new AbstractModule(this){

            protected void configure() {
                this.binder().withSource(PermittedModule.class).bindConstant().annotatedWith(GatewayIpAdress.class).to(0);
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void getElements_getModule_works() {
        Guice.createInjector((Module[])new Module[]{Elements.getModule((Iterable)Elements.getElements((Module[])new Module[]{new NetworkModule()}))});
    }

    @Test
    public void rogueBindingByMethodScannerDenied() {
        AbstractModule rogueModule = new AbstractModule(this){

            @NetworkProvides
            String provideNetworkString() {
                return "lorem ipsum";
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule, RestrictedBindingSourceTest.scannerModule(new NetworkProvidesScanner())});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)NETWORK_ANNOTATION_IS_RESTRICTED);
    }

    @Test
    public void bindingsAddedByMethodScannerAllowedByNetworkLib() {
        @NetworkLibrary
        class NetworkModuleWithCustomProvides
        extends AbstractModule {
            NetworkModuleWithCustomProvides(RestrictedBindingSourceTest this$0) {
            }

            @NetworkProvides
            String provideNetworkString() {
                return "the real network string";
            }
        }
        Guice.createInjector((Module[])new Module[]{new NetworkModuleWithCustomProvides(this), RestrictedBindingSourceTest.scannerModule(new NetworkProvidesScanner())});
    }

    @Test
    public void scannerWithPermitCanCreateRestrictedBinding() {
        AbstractModule moduleWithNetworkProvidesMethod = new AbstractModule(this){

            @NetworkProvides
            String provideNetworkString() {
                return "lorem ipsum";
            }
        };
        @NetworkLibrary
        class NetworkProvidesScannerWithPermit
        extends NetworkProvidesScanner {
            NetworkProvidesScannerWithPermit(RestrictedBindingSourceTest this$0) {
            }
        }
        Guice.createInjector((Module[])new Module[]{moduleWithNetworkProvidesMethod, RestrictedBindingSourceTest.scannerModule(new NetworkProvidesScannerWithPermit(this))});
    }

    @Test
    public void scannerWithPermitCanCreateRestrictedBindings() {
        AbstractModule moduleWithNetworkProvidesMethod = new AbstractModule(this){

            @NetworkProvides
            String provideNetworkString() {
                return "lorem ipsum";
            }
        };
        @NetworkLibrary
        class NetworkProvidesScannerWithPermit
        extends NetworkProvidesScanner {
            NetworkProvidesScannerWithPermit(RestrictedBindingSourceTest this$0) {
            }

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new AbstractModule(this){

                    @Provides
                    @GatewayIpAdress
                    int provideGatewayIp() {
                        return 42;
                    }
                });
                return Key.get((TypeLiteral)key.getTypeLiteral(), Network.class);
            }
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{moduleWithNetworkProvidesMethod, RestrictedBindingSourceTest.scannerModule(new NetworkProvidesScannerWithPermit(this))});
        Truth.assertThat((Integer)((Integer)injector.getInstance(Key.get(Integer.class, GatewayIpAdress.class)))).isEqualTo((Object)42);
    }

    @Test
    public void moduleInstalledByScannerInheritsMethodModulePermit() {
        @NetworkLibrary
        class ScannedModuleWithPermit
        extends AbstractModule {
            ScannedModuleWithPermit(RestrictedBindingSourceTest this$0) {
            }

            @NetworkProvides
            String provideNetworkString() {
                return "lorem ipsum";
            }
        }
        class NetworkProvidesScannerWithoutPermit
        extends NetworkProvidesScanner {
            NetworkProvidesScannerWithoutPermit(RestrictedBindingSourceTest this$0) {
            }

            @Override
            public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
                binder.install((Module)new AbstractModule(this){

                    @Provides
                    @GatewayIpAdress
                    int provideGatewayIp() {
                        return 42;
                    }
                });
                return key.withAnnotation(Network.class);
            }
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new ScannedModuleWithPermit(this), RestrictedBindingSourceTest.scannerModule(new NetworkProvidesScannerWithoutPermit(this))});
        Truth.assertThat((Integer)((Integer)injector.getInstance(Key.get(Integer.class, GatewayIpAdress.class)))).isEqualTo((Object)42);
    }

    private static Module scannerModule(final ModuleAnnotatedMethodScanner scanner) {
        return new AbstractModule(){

            protected void configure() {
                this.binder().scanModulesForAnnotatedMethods(scanner);
            }
        };
    }

    @Test
    public void modulesOverrideCantOverrideRestrictedBinding() {
        Module rogueModule = Modules.override((Module[])new Module[]{new NetworkModule()}).with(new Module[]{new AbstractModule(this){

            @Provides
            @GatewayIpAdress
            int provideRogueGatewayIp() {
                return 12345;
            }
        }});
        CreationException expected = this.assertThatInjectorCreationFails(rogueModule);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void modulesOverrideRestrictedBindingAllowedIfParentHasPermit() {
        @NetworkLibrary
        class NetworkModuleVersion2
        extends AbstractModule {
            NetworkModuleVersion2(RestrictedBindingSourceTest this$0) {
            }

            protected void configure() {
                this.install(Modules.override((Module[])new Module[]{new NetworkModule()}).with(new Module[]{new AbstractModule(this){

                    @Provides
                    @GatewayIpAdress
                    int provideGatewayIpV2() {
                        return 2;
                    }
                }}));
            }
        }
        Truth.assertThat((Integer)((Integer)Guice.createInjector((Module[])new Module[]{new NetworkModuleVersion2(this)}).getInstance(Key.get(Integer.class, GatewayIpAdress.class)))).isEqualTo((Object)2);
    }

    @Test
    public void modulesOverrideCanOverrideUnrestrictedBinding() {
        Module overrideModule = Modules.override((Module[])new Module[]{new NetworkModule(), new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith(UnrestrictedQualifier.class).to("foo");
            }
        }}).with(new Module[]{new AbstractModule(this){

            @Provides
            @UnrestrictedQualifier
            String provideRogueGatewayIp() {
                return "bar";
            }
        }});
        Truth.assertThat((String)((String)Guice.createInjector((Module[])new Module[]{overrideModule}).getInstance(Key.get(String.class, UnrestrictedQualifier.class)))).isEqualTo((Object)"bar");
    }

    @Test
    public void nestedModulesOverrideCanOverrideUnrestrictedBindings() {
        Module overrideModule = Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{new NetworkModule(), new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith(UnrestrictedQualifier.class).to("foo");
                this.bindConstant().annotatedWith(UnrestrictedQualifier.class).to(42);
            }
        }}).with(new Module[]{new AbstractModule(this){

            @Provides
            @UnrestrictedQualifier
            String overrideString() {
                return "bar";
            }
        }})}).with(new Module[]{new AbstractModule(this){

            @Provides
            @UnrestrictedQualifier
            int overrideLong() {
                return 45;
            }
        }});
        Injector injector = Guice.createInjector((Module[])new Module[]{overrideModule});
        Truth.assertThat((String)((String)injector.getInstance(Key.get(String.class, UnrestrictedQualifier.class)))).isEqualTo((Object)"bar");
        Truth.assertThat((Integer)((Integer)injector.getInstance(Key.get(Integer.class, UnrestrictedQualifier.class)))).isEqualTo((Object)45);
    }

    @Test
    public void modulesOverridePrivateModule() {
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new PrivateModule(this){

            protected void configure() {
                this.install((Module)new NetworkModule());
                this.expose(Key.get(String.class, Hostname.class));
            }

            @Provides
            @Exposed
            @Named(value="custom-gateway")
            int customGateway(@GatewayIpAdress int gateway) {
                return gateway + 4;
            }
        }}).with(new Module[]{new AbstractModule(this){

            @Provides
            @Named(value="custom-gateway")
            int provideCustomGatewayOverride() {
                return 12345;
            }
        }})});
    }

    @Test
    public void originalElementSourceNotTrustedIfSetExternally() {
        final ElementSource networkElementSource = (ElementSource)((Element)Elements.getElements((Module[])new Module[]{new NetworkModule()}).get(0)).getSource();
        AbstractModule rogueModule = new AbstractModule(this){

            protected void configure() {
                this.binder().withSource((Object)networkElementSource).bindConstant().annotatedWith(GatewayIpAdress.class).to(12);
            }
        };
        Binding rogueGatewayBinding = (Binding)Elements.getElements((Module[])new Module[]{rogueModule}).get(0);
        Truth.assertThat((Object)((ElementSource)rogueGatewayBinding.getSource()).getOriginalElementSource()).isEqualTo((Object)networkElementSource);
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void parentHasPermit_childPrivateModuleCanBind() {
        Guice.createInjector((Module[])new Module[]{new NetworkModuleThatInstalls((Module)new PrivateModuleCreatesUnexposedNetworkBinding())});
    }

    @Test
    public void noPermitOnStack_privateModuleCantBind() {
        AbstractModule rogueModule = new AbstractModule(this){

            protected void configure() {
                this.install((Module)new PrivateModuleCreatesUnexposedNetworkBinding());
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void parentHasPermit_childPrivateModuleCanExposeBinding() {
        Guice.createInjector((Module[])new Module[]{new NetworkModuleThatInstalls((Module)new PrivateModuleExposesNetworkBinding())});
    }

    @Test
    public void noPermitOnStack_childPrivateModuleCantExposeBinding() {
        AbstractModule rogueModule = new AbstractModule(this){

            protected void configure() {
                this.install((Module)new PrivateModuleExposesNetworkBinding());
            }
        };
        CreationException expected = this.assertThatInjectorCreationFails(new Module[]{rogueModule});
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_NETWORK_MODULE);
    }

    @Test
    public void childInjectorCantBindRestrictedBindingWithoutPermit() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new NetworkModule()});
        AbstractModule rogueModule = new AbstractModule(this){

            @Provides
            RoutingTable provideRoutingTable() {
                return destinationIp -> 0;
            }
        };
        CreationException expected = (CreationException)Assert.assertThrows(CreationException.class, () -> parent.createChildInjector(new Module[]{rogueModule}));
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)BINDING_PERMISSION_ERROR);
        Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)USE_ROUTING_MODULE);
    }

    @Test
    public void childInjectorCanBindRestrictedBindingWithPermit() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new NetworkModule()});
        parent.createChildInjector(new Module[]{new RoutingModule()});
    }

    CreationException assertThatInjectorCreationFails(Module ... modules) {
        return (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])modules));
    }

    private static class PrivateModuleExposesNetworkBinding
    extends PrivateModule {
        private PrivateModuleExposesNetworkBinding() {
        }

        protected void configure() {
            this.install((Module)new AbstractModule(this){

                protected void configure() {
                    this.bindConstant().annotatedWith(GatewayIpAdress.class).to(0);
                }
            });
            this.expose(Key.get(Integer.class, GatewayIpAdress.class));
        }
    }

    private static class PrivateModuleCreatesUnexposedNetworkBinding
    extends PrivateModule {
        private PrivateModuleCreatesUnexposedNetworkBinding() {
        }

        protected void configure() {
            this.bindConstant().annotatedWith(GatewayIpAdress.class).to(0);
        }
    }

    @NetworkLibrary
    private static class NetworkModuleThatInstalls
    extends AbstractModule {
        final Module module;

        NetworkModuleThatInstalls(Module module) {
            this.module = module;
        }

        protected void configure() {
            this.install(this.module);
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface UnrestrictedQualifier {
    }

    private static class NetworkProvidesScanner
    extends ModuleAnnotatedMethodScanner {
        private NetworkProvidesScanner() {
        }

        public String toString() {
            return "NetworkProvidesScanner";
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(NetworkProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key.withAnnotation(Network.class);
        }
    }

    @Qualifier
    @RestrictedBindingSource(explanation="The @Network annotation can only be used to annotate Network library Keys.", permits={NetworkLibrary.class})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Network {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface NetworkProvides {
    }

    private static class UnpermittedModule
    extends AbstractModule {
        private UnpermittedModule() {
        }

        public String foo() {
            return "bar";
        }
    }

    @NetworkLibrary
    private static class PermittedModule
    extends AbstractModule {
        private PermittedModule() {
        }

        protected void configure() {
            Method userUnpermittedModuleMethod;
            try {
                userUnpermittedModuleMethod = UnpermittedModule.class.getMethod("foo", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.binder().withSource((Object)userUnpermittedModuleMethod).bind(String.class).annotatedWith(Hostname.class).toInstance((Object)"google.com");
        }
    }

    static class TopLevelModulePrivatelyBindingDnsAddress
    extends AbstractModule {
        TopLevelModulePrivatelyBindingDnsAddress() {
        }

        protected void configure() {
            this.install((Module)new PrivateModule(this){

                protected void configure() {
                    this.install((Module)new BazRogueDnsModule());
                }
            });
        }
    }

    static class BazRogueDnsModule
    extends AbstractModule {
        BazRogueDnsModule() {
        }

        @Provides
        @DnsAddress
        int rogueDns() {
            return 5;
        }
    }

    static class BarRogueDnsModule
    extends AbstractModule {
        BarRogueDnsModule() {
        }

        @Provides
        @DnsAddress
        int rogueDns() {
            return 5;
        }
    }

    static class FooRogueDnsModule
    extends AbstractModule {
        FooRogueDnsModule() {
        }

        @Provides
        @DnsAddress
        int rogueDns() {
            return 4;
        }
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Use the official DNS module", permits={NetworkLibrary.class}, exemptModules="com.google.inject.RestrictedBindingSourceTest\\$FooRogueDnsModule|com.google.inject.RestrictedBindingSourceTest\\$BarRogueDnsModule|com.google.inject.RestrictedBindingSourceTest\\$TopLevelModulePrivatelyBindingDnsAddress")
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface DnsAddress {
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Please install NetworkModule.", permits={NetworkLibrary.class}, restrictionLevel=RestrictedBindingSource.RestrictionLevel.WARNING)
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface HostIp {
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Only modules with FooPermit can bind @Foo bindings.", permits={FooPermit.class})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Foo {
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE_USE})
    static @interface FooPermit {
    }

    private static class RoutingTableImpl
    implements RoutingTable {
        @Inject
        RoutingTableImpl() {
        }

        @Override
        public int getNextHopIpAddress(int destinationIpAddress) {
            return destinationIpAddress + 2;
        }
    }

    @NetworkTestLibrary
    private static class TestMacAddressModule
    extends AbstractModule {
        private TestMacAddressModule() {
        }

        @Provides
        @MacAddress
        String provideMacAddress() {
            return "deadbeef";
        }
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Please install NetworkModule.", permits={NetworkLibrary.class, NetworkTestLibrary.class})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface MacAddress {
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NetworkTestLibrary {
    }

    @NetworkLibrary
    private static class RoutingModule
    extends AbstractModule {
        private RoutingModule() {
        }

        @Provides
        RoutingTable provideRoutingTable(@GatewayIpAdress int gateway) {
            return destinationIp -> gateway;
        }
    }

    @RestrictedBindingSource(explanation="Please install RoutingModule.", permits={NetworkLibrary.class})
    @ImplementedBy(value=RoutingTableImpl.class)
    static interface RoutingTable {
        public int getNextHopIpAddress(int var1);
    }

    @NetworkLibrary
    private static class NetworkModule
    extends AbstractModule {
        private NetworkModule() {
        }

        @Provides
        @GatewayIpAdress
        int provideIpAddress() {
            return 21321566;
        }

        protected void configure() {
            this.bind(String.class).annotatedWith(Hostname.class).toInstance((Object)"google.com");
        }
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Please install NetworkModule.", permits={NetworkLibrary.class})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Hostname {
    }

    @Qualifier
    @RestrictedBindingSource(explanation="Please install NetworkModule.", permits={NetworkLibrary.class})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface GatewayIpAdress {
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NetworkLibrary {
    }
}

