/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeListenerTest {
    private final Matcher<Object> onlyAbcd = Matchers.only((Object)new TypeLiteral<A>(this){}).or(Matchers.only((Object)new TypeLiteral<B>(this){})).or(Matchers.only((Object)new TypeLiteral<C>(this){})).or(Matchers.only((Object)new TypeLiteral<D>(this){}));
    final TypeListener failingTypeListener = new TypeListener(this){
        int failures = 0;

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "clumsy";
        }
    };
    final InjectionListener<Object> failingInjectionListener = new InjectionListener<Object>(this){
        int failures = 0;

        public void afterInjection(Object injectee) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "goofy";
        }
    };
    final MembersInjector<Object> failingMembersInjector = new MembersInjector<Object>(this){
        int failures = 0;

        public void injectMembers(Object instance) {
            throw new ClassCastException("whoops, failure #" + ++this.failures);
        }

        public String toString() {
            return "awkward";
        }
    };

    @Test
    public void testTypeListenersAreFired() {
        final AtomicInteger firedCount = new AtomicInteger();
        final TypeListener typeListener = new TypeListener(this){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                Assert.assertEquals((Object)new TypeLiteral<A>(this){}, type);
                firedCount.incrementAndGet();
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, typeListener);
                this.bind(A.class);
            }
        }});
        Assert.assertEquals((long)1L, (long)firedCount.get());
    }

    @Test
    public void testInstallingInjectionListener() {
        final ArrayList injectees = Lists.newArrayList();
        InjectionListener<Object> injectionListener = new InjectionListener<Object>(this){

            public void afterInjection(Object injectee) {
                injectees.add(injectee);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((InjectionListener)injectionListener){
            final /* synthetic */ InjectionListener val$injectionListener;
            {
                this.val$injectionListener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(val$injectionListener);
                    }
                });
                this.bind(A.class);
            }
        }});
        Assert.assertEquals((Object)ImmutableList.of(), (Object)injectees);
        Object a1 = injector.getInstance(A.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)a1), (Object)injectees);
        Object a2 = injector.getInstance(A.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2), (Object)injectees);
        Object b1 = injector.getInstance(B.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1), (Object)injectees);
        Provider aProvider = injector.getProvider(A.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1), (Object)injectees);
        A a3 = (A)aProvider.get();
        A a4 = (A)aProvider.get();
        Assert.assertEquals((Object)ImmutableList.of((Object)a1, (Object)a2, (Object)b1, (Object)a3, (Object)a4), (Object)injectees);
    }

    private static MethodInterceptor prefixInterceptor(final String prefix) {
        return new MethodInterceptor(){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                return prefix + methodInvocation.proceed();
            }
        };
    }

    @Test
    public void testAddingInterceptors() throws NoSuchMethodException {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        final Matcher buzz = Matchers.only((Object)C.class.getMethod("buzz", new Class[0]));
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), buzz, new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("ka")});
                this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("fe")});
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.bindInterceptor(Matchers.any(), new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("li")});
                        encounter.bindInterceptor(buzz, new MethodInterceptor[]{TypeListenerTest.prefixInterceptor("no")});
                    }
                });
            }
        }});
        C c = (C)injector.getInstance(C.class);
        Assert.assertEquals((Object)"kafelinobuzz", (Object)c.buzz());
        Assert.assertEquals((Object)"felibeep", (Object)c.beep());
    }

    @Test
    public void testTypeListenerThrows() {
        try {
            Guice.createInjector((Module[])new Module[]{new OuterThrowsModule()});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error notifying TypeListener clumsy", "bound at TypeListenerTest$InnerThrowsModule.configure", "of TypeListenerTest$B", "Reason: ClassCastException: whoops, failure #1", "Error notifying TypeListener clumsy", "bound at TypeListenerTest$InnerThrowsModule.configure", "TypeListenerTest$OuterThrowsModule -> TypeListenerTest$InnerThrowsModule", "of TypeListenerTest$C", "Reason: ClassCastException: whoops, failure #2");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
            }
        }});
        try {
            injector.getProvider(B.class);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error notifying TypeListener clumsy", "of TypeListenerTest$B", "Reason: ClassCastException: whoops, failure #3");
        }
        try {
            injector.getInstance(B.class);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error notifying TypeListener clumsy", "of TypeListenerTest$B", "Reason: ClassCastException: whoops, failure #3");
        }
        Assert.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    @Test
    public void testInjectionListenerThrows() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(TypeListenerTest.this.failingInjectionListener);
                    }
                });
                this.bind(B.class);
            }
        }});
        try {
            injector.getInstance(A.class);
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error notifying InjectionListener goofy of TypeListenerTest$A.", " Reason: ClassCastException: whoops, failure #1");
        }
        try {
            injector.getInstance(A.class);
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error notifying InjectionListener goofy of ", " Reason: ClassCastException: whoops, failure #2");
        }
        Provider bProvider = injector.getProvider(B.class);
        try {
            bProvider.get();
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error notifying InjectionListener goofy of TypeListenerTest$B.", " Reason: ClassCastException: whoops, failure #3");
        }
        Assert.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    @Test
    public void testInjectMembersTypeListenerFails() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.getMembersInjector(A.class);
                    this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Error notifying TypeListener clumsy (bound at TypeListenerTest$16.configure", "of TypeListenerTest$A", " Reason: ClassCastException: whoops, failure #1");
        }
    }

    @Test
    public void testConstructedTypeListenerIsTheSameAsMembersInjectorListener() {
        final AtomicInteger typeEncounters = new AtomicInteger();
        final AtomicInteger injections = new AtomicInteger();
        InjectionListener<A> listener = new InjectionListener<A>(this){

            public void afterInjection(A injectee) {
                injections.incrementAndGet();
                Assert.assertNotNull((Object)injectee.injector);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((InjectionListener)listener){
            final /* synthetic */ InjectionListener val$listener;
            {
                this.val$listener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        typeEncounters.incrementAndGet();
                        encounter.register(val$listener);
                    }
                });
                this.bind(A.class);
                this.getMembersInjector(A.class);
            }
        }});
        Assert.assertEquals((long)0L, (long)injections.getAndSet(0));
        injector.getInstance(A.class);
        Assert.assertEquals((long)1L, (long)injections.getAndSet(0));
        injector.injectMembers((Object)new A());
        Assert.assertEquals((long)1L, (long)injections.getAndSet(0));
        Provider aProvider = injector.getProvider(A.class);
        MembersInjector aMembersInjector = injector.getMembersInjector(A.class);
        Assert.assertEquals((long)0L, (long)injections.getAndSet(0));
        aProvider.get();
        aProvider.get();
        Assert.assertEquals((long)2L, (long)injections.getAndSet(0));
        aMembersInjector.injectMembers((Object)new A());
        aMembersInjector.injectMembers((Object)new A());
        Assert.assertEquals((long)2L, (long)injections.getAndSet(0));
        Assert.assertEquals((long)1L, (long)typeEncounters.getAndSet(0));
    }

    @Test
    public void testLookupsAtInjectorCreateTime() {
        final AtomicReference bProviderReference = new AtomicReference();
        final AtomicReference aMembersInjectorReference = new AtomicReference();
        InjectionListener<Object> lookupsTester = new InjectionListener<Object>(this){

            public void afterInjection(Object injectee) {
                Assert.assertNotNull((Object)((Provider)bProviderReference.get()).get());
                A a = new A();
                ((MembersInjector)aMembersInjectorReference.get()).injectMembers((Object)a);
                Assert.assertNotNull((Object)a.injector);
            }
        };
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (InjectionListener)lookupsTester){
            final /* synthetic */ InjectionListener val$lookupsTester;
            {
                this.val$lookupsTester = injectionListener;
            }

            protected void configure() {
                this.bindListener(Matchers.only((Object)TypeLiteral.get(C.class)), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        Provider bProvider = encounter.getProvider(B.class);
                        try {
                            bProvider.get();
                            Assert.fail();
                        }
                        catch (IllegalStateException expected) {
                            Assert.assertEquals((Object)"This Provider cannot be used until the Injector has been created.", (Object)expected.getMessage());
                        }
                        bProviderReference.set(bProvider);
                        MembersInjector aMembersInjector = encounter.getMembersInjector(A.class);
                        try {
                            aMembersInjector.injectMembers((Object)new A());
                            Assert.fail();
                        }
                        catch (IllegalStateException expected) {
                            Assert.assertEquals((Object)"This MembersInjector cannot be used until the Injector has been created.", (Object)expected.getMessage());
                        }
                        aMembersInjectorReference.set(aMembersInjector);
                        encounter.register(val$lookupsTester);
                    }
                });
                this.bind(C.class).asEagerSingleton();
            }
        }});
        lookupsTester.afterInjection(null);
    }

    @Test
    public void testLookupsPostCreate() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.only((Object)TypeLiteral.get(C.class)), new TypeListener(this){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        Assert.assertNotNull((Object)encounter.getProvider(B.class).get());
                        A a = new A();
                        encounter.getMembersInjector(A.class).injectMembers((Object)a);
                        Assert.assertNotNull((Object)a.injector);
                    }
                });
            }
        }});
        injector.getInstance(C.class);
    }

    @Test
    public void testMembersInjector() {
        MembersInjector<D> membersInjector = new MembersInjector<D>(this){

            public void injectMembers(D instance) {
                ++instance.userInjected;
                Assert.assertEquals((long)instance.guiceInjected, (long)instance.userInjected);
            }
        };
        InjectionListener<D> injectionListener = new InjectionListener<D>(this){

            public void afterInjection(D injectee) {
                Assert.assertTrue((injectee.userInjected > 0 ? 1 : 0) != 0);
                ++injectee.listenersNotified;
                Assert.assertEquals((long)injectee.guiceInjected, (long)injectee.listenersNotified);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule((MembersInjector)membersInjector, (InjectionListener)injectionListener){
            final /* synthetic */ MembersInjector val$membersInjector;
            final /* synthetic */ InjectionListener val$injectionListener;
            {
                this.val$membersInjector = membersInjector;
                this.val$injectionListener = injectionListener;
            }

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(val$membersInjector);
                        encounter.register(val$injectionListener);
                    }
                });
                D boundThreeTimes = new D();
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"i")).toInstance((Object)boundThreeTimes);
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"ii")).toInstance((Object)boundThreeTimes);
                this.bind(D.class).annotatedWith((Annotation)Names.named((String)"iii")).toInstance((Object)boundThreeTimes);
            }
        }});
        D boundThreeTimes = (D)injector.getInstance(Key.get(D.class, (Annotation)Names.named((String)"iii")));
        boundThreeTimes.assertAllCounts(1);
        D getInstance = (D)injector.getInstance(D.class);
        getInstance.assertAllCounts(1);
        D memberInjection = new D();
        injector.injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(1);
        injector.injectMembers((Object)memberInjection);
        injector.injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(3);
        injector.getMembersInjector(D.class).injectMembers((Object)memberInjection);
        memberInjection.assertAllCounts(4);
    }

    @Test
    public void testMembersInjectorThrows() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(TypeListenerTest.this.failingMembersInjector);
                    }
                });
                this.bind(B.class);
            }
        }});
        try {
            injector.getInstance(A.class);
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error injecting TypeListenerTest$A using awkward", "Reason: ClassCastException: whoops, failure #1");
        }
        try {
            injector.getInstance(A.class);
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error injecting TypeListenerTest$A using awkward", "Reason: ClassCastException: whoops, failure #2");
        }
        Provider bProvider = injector.getProvider(B.class);
        try {
            bProvider.get();
            Assert.fail();
        }
        catch (ProvisionException e) {
            Asserts.assertContains(e.getMessage(), "Error injecting TypeListenerTest$B using awkward", "Reason: ClassCastException: whoops, failure #3");
        }
        Assert.assertSame((Object)Stage.DEVELOPMENT, (Object)injector.getInstance(Stage.class));
    }

    @Test
    public void testTypesWithNoInjectableMembersAreNotified() {
        final AtomicInteger notificationCount = new AtomicInteger();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindListener(TypeListenerTest.this.onlyAbcd, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        notificationCount.incrementAndGet();
                    }
                });
                this.bind(C.class).toInstance((Object)new C());
            }
        }});
        Assert.assertEquals((long)1L, (long)notificationCount.get());
    }

    @Test
    public void testEncounterCannotBeUsedAfterHearReturns() {
        final AtomicReference encounterReference = new AtomicReference();
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounterReference.set(encounter);
                    }
                });
                this.bind(C.class);
            }
        }});
        TypeEncounter encounter = (TypeEncounter)encounterReference.get();
        try {
            encounter.register((InjectionListener)new InjectionListener<Object>(this){

                public void afterInjection(Object injectee) {
                }
            });
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.bindInterceptor(Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                    return methodInvocation.proceed();
                }
            }});
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.addError((Throwable)new Exception());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.getMembersInjector(A.class);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            encounter.getProvider(B.class);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAddErrors() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.requestInjection(new Object());
                    this.bindListener(Matchers.any(), new TypeListener(this){

                        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                            encounter.addError("There was an error on %s", new Object[]{type});
                            encounter.addError((Throwable)new IllegalArgumentException("whoops!"));
                            encounter.addError(new Message("And another problem"));
                            encounter.addError((Throwable)new IllegalStateException());
                        }
                    });
                }
            }});
            Assert.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "1) There was an error on Object", "2) [Guice/ErrorInUserCode]: An exception was caught and reported. Message: whoops!", "3) And another problem", "4) [Guice/ErrorInUserCode]: An exception was caught and reported. Message: null", "4 errors");
        }
    }

    @Test
    public void testDeDuplicateTypeListeners() {
        final DuplicatingTypeListener typeListener = new DuplicatingTypeListener();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bindListener(Matchers.any(), typeListener);
                this.bindListener(Matchers.only((Object)new TypeLiteral<D>(this){}), typeListener);
            }
        }});
        D d = (D)injector.getInstance(D.class);
        d.assertAllCounts(1);
        Assert.assertEquals((long)1L, (long)typeListener.count);
    }

    static class D {
        int guiceInjected = 0;
        int userInjected = 0;
        int listenersNotified = 0;

        D() {
        }

        @Inject
        void guiceInjected() {
            ++this.guiceInjected;
        }

        void assertAllCounts(int expected) {
            Assert.assertEquals((long)expected, (long)this.guiceInjected);
            Assert.assertEquals((long)expected, (long)this.userInjected);
            Assert.assertEquals((long)expected, (long)this.listenersNotified);
        }
    }

    public static class C {
        public String buzz() {
            return "buzz";
        }

        public String beep() {
            return "beep";
        }
    }

    static class B {
        B() {
        }
    }

    static class A {
        @Inject
        Injector injector;
        @Inject
        Stage stage;

        A() {
        }
    }

    private static class DuplicatingTypeListener
    implements TypeListener {
        int count = 0;

        private DuplicatingTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            ++this.count;
            CountingMembersInjector membersInjector = new CountingMembersInjector();
            encounter.register((MembersInjector)membersInjector);
            encounter.register((MembersInjector)membersInjector);
            CountingInjectionListener injectionListener = new CountingInjectionListener();
            encounter.register((InjectionListener)injectionListener);
            encounter.register((InjectionListener)injectionListener);
        }
    }

    private static class CountingInjectionListener
    implements InjectionListener<D> {
        private CountingInjectionListener() {
        }

        public void afterInjection(D injectee) {
            ++injectee.listenersNotified;
        }
    }

    private static class CountingMembersInjector
    implements MembersInjector<D> {
        private CountingMembersInjector() {
        }

        public void injectMembers(D instance) {
            ++instance.userInjected;
        }
    }

    class InnerThrowsModule
    extends AbstractModule {
        InnerThrowsModule() {
        }

        protected void configure() {
            this.bindListener(TypeListenerTest.this.onlyAbcd, TypeListenerTest.this.failingTypeListener);
            this.bind(B.class);
            this.bind(C.class);
        }
    }

    class OuterThrowsModule
    extends AbstractModule {
        OuterThrowsModule() {
        }

        protected void configure() {
            this.install((Module)new InnerThrowsModule());
        }
    }
}

