/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ChildBindingAlreadySetErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void childBindingAlreadySetError() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ChildModule()});
        ConfigurationException exception = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> injector.getInstance(Foo.class));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "child_binding_already_set_error.txt");
    }

    @Test
    public void childBindingAlreadySetMultipleTimesError() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ChildModule(), new ChildModule2()});
        ConfigurationException exception = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> injector.getInstance(DependsOnFoo.class));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "child_binding_already_set_multiple_times_error.txt");
    }

    @Test
    public void multipleChildBindingAlreadySetErrors() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new ChildModule(), new ChildModule2(), new BarModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "multiple_child_binding_already_set_errors.txt");
    }

    @Test
    public void childBindingAlreadySetByJustInTimeBinding() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ChildModule3(), new ChildModule4()});
        ConfigurationException exception = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> injector.getInstance(DependsOnFoo.class));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "child_binding_already_set_by_just_in_time_binding.txt");
    }

    static class ChildModule4
    extends PrivateModule {
        ChildModule4() {
        }

        protected void configure() {
            this.bind(DependsOnFoo.class).toInstance((Object)new DependsOnFoo(new Foo()));
        }

        @Provides
        @Named(value="Child4Module")
        @Exposed
        String provideExposed() {
            return "a";
        }
    }

    static class ChildModule3
    extends PrivateModule {
        ChildModule3() {
        }

        protected void configure() {
            this.bind(Foo.class).to(SubFoo.class);
            this.getProvider(DependsOnFoo.class);
        }

        @Provides
        @Named(value="Child3Module")
        @Exposed
        String provideExposed() {
            return "a";
        }
    }

    static class BarModule
    extends AbstractModule {
        BarModule() {
        }

        protected void configure() {
            this.bind(Bar.class);
        }
    }

    static class Bar {
        @Inject
        Bar(Foo foo, DependsOnFoo dependsOnFoo) {
        }
    }

    static class DependsOnFoo {
        @Inject
        DependsOnFoo(Foo foo) {
        }
    }

    static class ChildModule2
    extends PrivateModule {
        ChildModule2() {
        }

        protected void configure() {
        }

        @Provides
        Foo provideFoo() {
            return new Foo();
        }

        @Provides
        @Named(value="Child2Module")
        @Exposed
        String provideExposed() {
            return "a";
        }
    }

    static class ChildModule
    extends PrivateModule {
        ChildModule() {
        }

        protected void configure() {
            this.bind(Foo.class).to(SubFoo.class);
        }

        @Provides
        @Named(value="ChildModule")
        @Exposed
        String provideExposed() {
            return "a";
        }
    }

    static class SubFoo
    extends Foo {
        @Inject
        SubFoo() {
        }
    }

    static class Foo {
        @Inject
        Foo() {
        }
    }
}

