/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import com.google.inject.multibindings.ClassMapKey;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.ProvidesIntoMap;
import com.google.inject.multibindings.StringMapKey;
import jakarta.inject.Qualifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class DuplicateMapKeyErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void duplicateMapKeyError() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MapModule(), new ContributorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "duplicate_map_key_error.txt");
    }

    @Test
    public void multipleDuplicateMapKeysError() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MapModule(), new ContributorModule(), new SecondContributorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "multiple_duplicate_map_keys_error.txt");
    }

    @Test
    public void duplicateMapKeysError_classKeyIsNotCompressed() {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new ClassKeyMapBinderModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "duplicate_map_keys_error_class_key_is_not_compressed.txt");
    }

    static class ClassKeyMapBinderModule
    extends AbstractModule {
        ClassKeyMapBinderModule() {
        }

        protected void configure() {
            MapBinder.newMapBinder((Binder)this.binder(), Class.class, String.class);
        }

        @ProvidesIntoMap
        @ClassMapKey(value=Foo.class)
        String provideFoo() {
            return "foo";
        }

        @ProvidesIntoMap
        @ClassMapKey(value=Foo.class)
        String provideFoo2() {
            return "foo2";
        }
    }

    static class Foo {
        Foo() {
        }
    }

    static class SecondContributorModule
    extends AbstractModule {
        SecondContributorModule() {
        }

        protected void configure() {
            MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
        }

        @ProvidesIntoMap
        @StringMapKey(value="second")
        String provideSecondIntoMap() {
            return "e";
        }
    }

    static class ContributorModule
    extends AbstractModule {
        ContributorModule() {
        }

        @ProvidesIntoMap
        @StringMapKey(value="first")
        String provideFirstIntoMap() {
            return "c";
        }

        @ProvidesIntoMap
        @StringMapKey(value="second")
        String provideSecondIntoMap() {
            return "d";
        }
    }

    static class MapModule
    extends AbstractModule {
        MapModule() {
        }

        protected void configure() {
            MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
            mapBinder.addBinding((Object)"first").toInstance((Object)"a");
            mapBinder.addBinding((Object)"first").to(Key.get(String.class, First.class));
        }

        @Provides
        @First
        String provideFirstString() {
            return "b";
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface First {
    }
}

