/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import jakarta.inject.Qualifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ErrorMessagesTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void classNamesAreCompressedInErrorMessage() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MissingBindingsModule()}));
        boolean nestedAnnotUsesDots = MissingBindingsModule.class.getDeclaredMethod("provideFoo", String.class).getParameters()[0].getAnnotation(UserId.class).toString().equals("@" + ErrorMessagesTest.class.getName() + ".UserId()");
        String golden = nestedAnnotUsesDots ? "class_names_are_compressed_in_error_message_with_dot_annots.txt" : "class_names_are_compressed_in_error_message.txt";
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), golden);
    }

    static class MissingBindingsModule
    extends AbstractModule {
        MissingBindingsModule() {
        }

        @Provides
        static Foo provideFoo(@UserId String unused) {
            return new Foo();
        }

        @Provides
        static OuterClass.Foo providerAnotherFoo(@OuterClass.UserId Long unused) {
            return null;
        }
    }

    static class Foo {
        Foo() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface UserId {
    }

    static class OuterClass {
        private OuterClass() {
        }

        static interface Foo {
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        static @interface UserId {
        }
    }
}

