/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import jakarta.inject.Inject;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class MissingConstructorErrorTest {
    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void missingConstructorErrors() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MissingConstructorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_constructor_errors.txt");
    }

    @Test
    public void missingConstructorErrors_atInjectRequired() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MissingConstructorAtInjectRequiredModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_constructor_errors_at_inject_required.txt");
    }

    @Test
    public void missingConstructorErrors_merged() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new MissingConstructorModule(), new DependsOnMissingNoArgConstructorModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_constructor_errors_merged.txt");
    }

    static class DependsOnMissingNoArgConstructorModule
    extends AbstractModule {
        DependsOnMissingNoArgConstructorModule() {
        }

        protected void configure() {
            this.bind(DependsOnMissingNoArgConstructor.class);
        }

        @Provides
        String provideString(PrivateConstructor privateConstructor) {
            return privateConstructor.toString();
        }
    }

    static class DependsOnMissingNoArgConstructor {
        @Inject
        DependsOnMissingNoArgConstructor(MissingNoArgConstructor noArgConstructor) {
        }
    }

    static class MissingConstructorAtInjectRequiredModule
    extends AbstractModule {
        MissingConstructorAtInjectRequiredModule() {
        }

        protected void configure() {
            this.binder().requireAtInjectOnConstructors();
        }

        @Provides
        static Object provideObject(NoArgConstructorWithAtInject noArgConstructorWithAtInject, NoArgConstructorWithoutAtInject noArgConstructorWithoutAtInject, PrivateConstructor privateConstructor) {
            return null;
        }
    }

    static class MissingConstructorModule
    extends AbstractModule {
        MissingConstructorModule() {
        }

        @Provides
        static Object provideObject(NoArgConstructorWithAtInject noArgConstructorWithAtInject, NoArgConstructorWithoutAtInject noArgConstructorWithoutAtInject, MissingNoArgConstructor missingNoArgConstructor, PrivateConstructor privateConstructor, PrivateClassWithPrivateConstructor privateClassWithPrivateConstructor) {
            return null;
        }
    }

    private static class PrivateClassWithPrivateConstructor {
        private PrivateClassWithPrivateConstructor() {
        }
    }

    static class PrivateConstructor {
        private PrivateConstructor() {
        }
    }

    static class MissingAtInjectConstructor {
        MissingAtInjectConstructor() {
        }
    }

    static class MissingNoArgConstructor {
        MissingNoArgConstructor(int param) {
        }
    }

    static class NoArgConstructorWithoutAtInject {
        NoArgConstructorWithoutAtInject() {
        }
    }

    static class NoArgConstructorWithAtInject {
        @Inject
        NoArgConstructorWithAtInject() {
        }
    }
}

