/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.errors;

import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.errors.ErrorMessageTestUtils;
import com.google.inject.internal.InternalFlags;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class MissingImplementationErrorTest {
    private static final String GOLDEN_SUFFIX;

    @Before
    public void checkStackTraceIsIncluded() {
        Assume.assumeTrue((InternalFlags.getIncludeStackTraceOption() != InternalFlags.IncludeStackTraceOption.OFF ? 1 : 0) != 0);
    }

    @Test
    public void missingImplementationErrors() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new TestModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_implementation_errors" + GOLDEN_SUFFIX);
    }

    @Test
    public void missingImplementationWithModuleStack() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new TestModule2()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_implementation_with_module_stack.txt");
    }

    @Test
    public void missingImplementationWithHints() throws Exception {
        CreationException exception = (CreationException)Assert.assertThrows(CreationException.class, () -> Guice.createInjector((Module[])new Module[]{new HintsModule()}));
        ErrorMessageTestUtils.assertGuiceErrorEqualsIgnoreLineNumber(exception.getMessage(), "missing_implementation_with_hints" + GOLDEN_SUFFIX);
    }

    @Test
    public void missingImplementationWithHints_memoizesSuggestion() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ConfigurationException ex = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> injector.getInstance(CustomType.class));
        Truth.assertThat((Throwable)ex).hasMessageThat().doesNotContain((CharSequence)"Did you mean?");
        injector.getInstance(CustomType.InnerType.class);
        Truth.assertThat((Throwable)ex).hasMessageThat().doesNotContain((CharSequence)"Did you mean?");
    }

    @Test
    public void missingImplementationWithHints_lazyInjectorUsage() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ConfigurationException ex = (ConfigurationException)Assert.assertThrows(ConfigurationException.class, () -> injector.getInstance(CustomType.class));
        injector.getInstance(CustomType.InnerType.class);
        Truth.assertThat((Throwable)ex).hasMessageThat().containsMatch("Did you mean?");
        Truth.assertThat((Throwable)ex).hasMessageThat().containsMatch("InnerType");
    }

    static {
        boolean nestedAnnotUsesDots;
        try {
            nestedAnnotUsesDots = RequiresFooUsingMethod.class.getDeclaredMethod("setMyString", String.class).getParameters()[0].getAnnotation(Foo.class).toString().equals("@" + MissingImplementationErrorTest.class.getName() + ".Foo()");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        GOLDEN_SUFFIX = nestedAnnotUsesDots ? "_with_dot_annots.txt" : ".txt";
    }

    private static interface CustomType {

        public static class InnerType {
        }
    }

    static class HintsModule
    extends AbstractModule {
        HintsModule() {
        }

        @Provides
        @A
        Klass provideKlass() {
            return new Klass();
        }

        @Provides
        String provideString(@B Klass missing) {
            return "string";
        }

        @Provides
        @A
        String provideAString(@A Klass2 klass2) {
            return "string a";
        }
    }

    static class Klass2 {
        Klass2(int i) {
        }
    }

    static class Klass {
        Klass() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface B {
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface A {
    }

    static class TestModule2
    extends AbstractModule {
        TestModule2() {
        }

        protected void configure() {
            this.install((Module)new TestModule1());
        }
    }

    static class TestModule1
    extends AbstractModule {
        TestModule1() {
        }

        protected void configure() {
            this.bind(Server.class);
        }
    }

    static class TestModule
    extends AbstractModule {
        TestModule() {
        }

        protected void configure() {
            this.bind(DependsOnMissingBindings.class);
        }
    }

    static class DependsOnMissingBindings {
        @Inject
        DependsOnMissingBindings(RequiresFooUsingConstructor ctorInjection, RequiresFooUsingField fieldInjection, RequiresFooUsingMethod methodInjection, Server server) {
        }
    }

    static class Server {
        @Inject
        Server(Provider<RequestHandler> handler) {
        }
    }

    static class RequestHandler {
        @Inject
        RequestHandler(Dao dao) {
        }
    }

    static interface Dao {
    }

    static class RequiresFooUsingMethod {
        RequiresFooUsingMethod() {
        }

        @Inject
        public void setMyString(@Foo String myString) {
        }
    }

    static class RequiresFooUsingField {
        @Inject
        @Foo
        private String unused;

        RequiresFooUsingField() {
        }
    }

    static class RequiresFooUsingConstructor {
        @Inject
        RequiresFooUsingConstructor(@Foo String ctorParam) {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Foo {
    }
}

