/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.truth.Truth;
import com.google.inject.internal.CycleDetectingLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;

public class CycleDetectingLockTest
extends TestCase {
    static final long DEADLOCK_TIMEOUT_SECONDS = 1L;

    public void testSingletonThreadsRuntimeCircularDependency() throws Exception {
        CyclicBarrier signal1 = new CyclicBarrier(2);
        final CyclicBarrier signal2 = new CyclicBarrier(2);
        final CyclicBarrier signal3 = new CyclicBarrier(2);
        CycleDetectingLock.CycleDetectingLockFactory lockFactory = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock lockA = new CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock(lockFactory, (Object)"A", (Lock)new ReentrantLock(this){

            @Override
            public void lock() {
                if (Thread.currentThread().getName().equals("T2")) {
                    try {
                        signal3.await(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    TestCase.assertEquals((String)"T1", (String)Thread.currentThread().getName());
                }
                super.lock();
            }
        });
        CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock lockB = new CycleDetectingLock.CycleDetectingLockFactory.ReentrantCycleDetectingLock(lockFactory, (Object)"B", (Lock)new ReentrantLock(this){

            @Override
            public void lock() {
                if (Thread.currentThread().getName().equals("T1")) {
                    try {
                        signal2.await(1L, TimeUnit.SECONDS);
                        signal3.await(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    TestCase.assertEquals((String)"T2", (String)Thread.currentThread().getName());
                }
                super.lock();
            }
        });
        Future<Void> firstThreadResult = Executors.newSingleThreadExecutor().submit(() -> CycleDetectingLockTest.lambda$testSingletonThreadsRuntimeCircularDependency$0(signal1, (CycleDetectingLock)lockA, (CycleDetectingLock)lockB));
        Future<Void> secondThreadResult = Executors.newSingleThreadExecutor().submit(() -> CycleDetectingLockTest.lambda$testSingletonThreadsRuntimeCircularDependency$1((CycleDetectingLock)lockB, signal1, signal2, (CycleDetectingLock)lockA));
        firstThreadResult.get(3L, TimeUnit.SECONDS);
        secondThreadResult.get(3L, TimeUnit.SECONDS);
    }

    public void testCycleDetectingLockFactoriesDoNotDeadlock() throws Exception {
        CycleDetectingLock.CycleDetectingLockFactory factoryA = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock lockA = factoryA.create((Object)"A");
        CycleDetectingLock.CycleDetectingLockFactory factoryB = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock lockB = factoryB.create((Object)"B");
        CyclicBarrier eachThreadAcquiredFirstLock = new CyclicBarrier(2);
        Future<Boolean> threadA = Executors.newSingleThreadExecutor().submit(() -> {
            Thread.currentThread().setName("A");
            CycleDetectingLockTest.assertTrue((boolean)lockA.lockOrDetectPotentialLocksCycle().isEmpty());
            eachThreadAcquiredFirstLock.await(1L, TimeUnit.SECONDS);
            boolean isEmpty = lockB.lockOrDetectPotentialLocksCycle().isEmpty();
            if (isEmpty) {
                lockB.unlock();
            }
            lockA.unlock();
            return isEmpty;
        });
        Future<Boolean> threadB = Executors.newSingleThreadExecutor().submit(() -> {
            Thread.currentThread().setName("B");
            CycleDetectingLockTest.assertTrue((boolean)lockB.lockOrDetectPotentialLocksCycle().isEmpty());
            eachThreadAcquiredFirstLock.await(1L, TimeUnit.SECONDS);
            boolean isEmpty = lockA.lockOrDetectPotentialLocksCycle().isEmpty();
            if (isEmpty) {
                lockA.unlock();
            }
            lockB.unlock();
            return isEmpty;
        });
        boolean deadlockADetected = threadA.get(2L, TimeUnit.SECONDS);
        boolean deadlockBDetected = threadB.get(2L, TimeUnit.SECONDS);
        CycleDetectingLockTest.assertTrue((String)"Deadlock should get detected", (deadlockADetected || deadlockBDetected ? 1 : 0) != 0);
        CycleDetectingLockTest.assertTrue((String)"One deadlock should get detected", (deadlockADetected != deadlockBDetected ? 1 : 0) != 0);
    }

    public void testCycleReporting() throws Exception {
        CycleDetectingLock.CycleDetectingLockFactory factory = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock lockA = factory.create((Object)"a");
        CycleDetectingLock lockB = factory.create((Object)"b");
        CycleDetectingLock lockC = factory.create((Object)"c");
        CyclicBarrier barrier = new CyclicBarrier(3);
        ImmutableList futures = ImmutableList.of(CycleDetectingLockTest.grabLocksInThread(lockA, lockB, barrier), CycleDetectingLockTest.grabLocksInThread(lockB, lockC, barrier), CycleDetectingLockTest.grabLocksInThread(lockC, lockA, barrier));
        ListMultimap cycle = null;
        for (Future future : futures) {
            ListMultimap value = (ListMultimap)future.get(3L, TimeUnit.SECONDS);
            if (value.isEmpty()) continue;
            cycle = value;
            break;
        }
        CycleDetectingLockTest.assertEquals((int)6, (int)cycle.size());
        Collection edges = Multimaps.asMap(cycle).values();
        CycleDetectingLockTest.assertTrue((boolean)edges.contains(ImmutableList.of((Object)"a", (Object)"b")));
        CycleDetectingLockTest.assertTrue((boolean)edges.contains(ImmutableList.of((Object)"b", (Object)"c")));
        CycleDetectingLockTest.assertTrue((boolean)edges.contains(ImmutableList.of((Object)"c", (Object)"a")));
    }

    private static <T> Future<ListMultimap<Thread, T>> grabLocksInThread(CycleDetectingLock<T> lock1, CycleDetectingLock<T> lock2, CyclicBarrier barrier) {
        FutureTask<ListMultimap<Thread, T>> future = new FutureTask<ListMultimap<Thread, T>>(() -> {
            CycleDetectingLockTest.assertTrue((boolean)lock1.lockOrDetectPotentialLocksCycle().isEmpty());
            barrier.await();
            ListMultimap cycle = lock2.lockOrDetectPotentialLocksCycle();
            if (cycle == null) {
                lock2.unlock();
            }
            lock1.unlock();
            return cycle;
        });
        Thread thread = new Thread(future);
        thread.start();
        return future;
    }

    public void testConcurrentReentrance() throws Exception {
        int numConcurrentLockers = 8;
        ExecutorService service = Executors.newFixedThreadPool(numConcurrentLockers);
        ArrayList results = new ArrayList();
        CycleDetectingLock.CycleDetectingLockFactory factory = new CycleDetectingLock.CycleDetectingLockFactory();
        CycleDetectingLock lock = factory.create((Object)"circles");
        Phaser phaser = new Phaser(1);
        for (int i = 0; i < numConcurrentLockers; ++i) {
            phaser.register();
            results.add(service.submit(() -> {
                phaser.arriveAndAwaitAdvance();
                Truth.assertThat((Multimap)lock.lockOrDetectPotentialLocksCycle()).isEmpty();
                Truth.assertThat((Multimap)lock.lockOrDetectPotentialLocksCycle()).isEmpty();
                lock.unlock();
                lock.unlock();
            }));
        }
        phaser.arriveAndDeregister();
        for (Future future : results) {
            future.get();
        }
        service.shutdown();
    }

    private static /* synthetic */ Void lambda$testSingletonThreadsRuntimeCircularDependency$1(CycleDetectingLock lockB, CyclicBarrier signal1, CyclicBarrier signal2, CycleDetectingLock lockA) throws Exception {
        Thread.currentThread().setName("T2");
        CycleDetectingLockTest.assertTrue((boolean)lockB.lockOrDetectPotentialLocksCycle().isEmpty());
        signal1.await(1L, TimeUnit.SECONDS);
        signal2.await(1L, TimeUnit.SECONDS);
        lockB.unlock();
        CycleDetectingLockTest.assertTrue((boolean)lockA.lockOrDetectPotentialLocksCycle().isEmpty());
        lockA.unlock();
        return null;
    }

    private static /* synthetic */ Void lambda$testSingletonThreadsRuntimeCircularDependency$0(CyclicBarrier signal1, CycleDetectingLock lockA, CycleDetectingLock lockB) throws Exception {
        Thread.currentThread().setName("T1");
        signal1.await(1L, TimeUnit.SECONDS);
        CycleDetectingLockTest.assertTrue((boolean)lockA.lockOrDetectPotentialLocksCycle().isEmpty());
        CycleDetectingLockTest.assertTrue((boolean)lockB.lockOrDetectPotentialLocksCycle().isEmpty());
        lockB.unlock();
        lockA.unlock();
        return null;
    }
}

