/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Collector;
import com.google.inject.internal.Element;
import com.google.inject.internal.RealMapBinder;
import com.google.inject.internal.SpiUtils;
import com.google.inject.internal.WeakKeySetUtils;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.util.Modules;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class MapBinderTest
extends TestCase {
    private static final ImmutableSet<Key<?>> FRAMEWORK_KEYS = ImmutableSet.of((Object)Key.get(Logger.class), (Object)Key.get(Stage.class), (Object)Key.get(Injector.class));
    final TypeLiteral<Map<String, jakarta.inject.Provider<String>>> mapOfStringJakartaProvider = new TypeLiteral<Map<String, jakarta.inject.Provider<String>>>(this){};
    final TypeLiteral<Map<String, Provider<String>>> mapOfStringProvider = new TypeLiteral<Map<String, Provider<String>>>(this){};
    final TypeLiteral<Map<String, String>> mapOfString = new TypeLiteral<Map<String, String>>(this){};
    final TypeLiteral<Map<Integer, String>> mapOfIntString = new TypeLiteral<Map<Integer, String>>(this){};
    final TypeLiteral<Map<String, Integer>> mapOfInteger = new TypeLiteral<Map<String, Integer>>(this){};
    final TypeLiteral<Map<String, Set<String>>> mapOfSetOfString = new TypeLiteral<Map<String, Set<String>>>(this){};
    private final TypeLiteral<String> stringType = TypeLiteral.get(String.class);
    private final TypeLiteral<Integer> intType = TypeLiteral.get(Integer.class);

    private Type mapEntryOf(Type keyType, Type valueType) {
        return Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{keyType, valueType});
    }

    private Type collectionOf(Type type) {
        return Types.newParameterizedType(Collection.class, (Type[])new Type[]{type});
    }

    public void testAllBindings() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).permitDuplicates();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Map bindings = injector.getBindings();
        ImmutableSet expectedBindings = ImmutableSet.builder().add((Object[])new Key[]{Key.get((Type)Types.mapOf(String.class, String.class)), Key.get((Type)Types.mapOf(String.class, (Type)Types.subtypeOf(String.class))), Key.get((Type)Types.mapOf(String.class, (Type)Types.providerOf(String.class))), Key.get((Type)Types.mapOf(String.class, (Type)Types.setOf(String.class))), Key.get((Type)Types.mapOf(String.class, (Type)Types.setOf((Type)Types.providerOf(String.class)))), Key.get((Type)Types.mapOf(String.class, (Type)Types.collectionOf((Type)Types.providerOf(String.class)))), Key.get((Type)Types.setOf((Type)this.mapEntryOf((Type)((Object)String.class), Types.providerOf(String.class)))), Key.get((Type)this.collectionOf(Types.providerOf((Type)this.mapEntryOf((Type)((Object)String.class), Types.providerOf(String.class))))), Key.get((Type)Types.setOf((Type)Types.subtypeOf((Type)this.mapEntryOf((Type)((Object)String.class), Types.providerOf(String.class))))), Key.get(Boolean.class, (Annotation)Names.named((String)"Multibinder<java.util.Map$Entry<java.lang.String, com.google.inject.Provider<java.lang.String>>> permits duplicates")), Key.get((Type)Types.mapOf(String.class, (Type)Types.jakartaProviderOf(String.class))), Key.get((Type)Types.mapOf(String.class, (Type)Types.setOf((Type)Types.jakartaProviderOf(String.class)))), Key.get((Type)Types.mapOf(String.class, (Type)Types.collectionOf((Type)Types.jakartaProviderOf(String.class)))), Key.get((Type)Types.setOf((Type)this.mapEntryOf((Type)((Object)String.class), Types.jakartaProviderOf(String.class)))), Key.get((Type)this.collectionOf(Types.jakartaProviderOf((Type)this.mapEntryOf((Type)((Object)String.class), Types.providerOf(String.class)))))}).addAll(FRAMEWORK_KEYS).build();
        Sets.SetView missingBindings = Sets.difference((Set)expectedBindings, bindings.keySet());
        Sets.SetView extraBindings = Sets.difference(bindings.keySet(), (Set)expectedBindings);
        MapBinderTest.assertTrue((String)("There should be no missing bindings. Missing: " + missingBindings), (boolean)missingBindings.isEmpty());
        MapBinderTest.assertTrue((String)("There should be no extra bindings. Extra: " + extraBindings), (boolean)extraBindings.isEmpty());
    }

    public void testMapBinderAggregatesMultipleModules() {
        AbstractModule abc = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        AbstractModule de = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"d").toInstance((Object)"D");
                multibinder.addBinding((Object)"e").toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{abc, de});
        Map abcde = (Map)injector.getInstance(Key.get(this.mapOfString));
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C", "d", "D", "e", "E"), (Object)abcde);
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(abc, de), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"), SpiUtils.instance("d", "D"), SpiUtils.instance("e", "E"));
        injector.getInstance(Key.get(this.mapOfStringProvider));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider));
    }

    public void testMapBinderAggregationForAnnotationInstance() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, (Annotation)Names.named((String)"abc"));
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, (Annotation)Names.named((String)"abc"));
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key key = Key.get(this.mapOfString, (Annotation)Names.named((String)"abc"));
        Map abc = (Map)injector.getInstance(key);
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)abc);
        SpiUtils.assertMapVisitor(key, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"));
        injector.getInstance(Key.get(this.mapOfStringProvider, (Annotation)Names.named((String)"abc")));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, (Annotation)Names.named((String)"abc")));
    }

    public void testMapBinderAggregationForAnnotationType() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, Abc.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, Abc.class);
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key key = Key.get(this.mapOfString, Abc.class);
        Map abc = (Map)injector.getInstance(key);
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)abc);
        SpiUtils.assertMapVisitor(key, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"));
        injector.getInstance(Key.get(this.mapOfStringProvider, Abc.class));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, Abc.class));
    }

    public void testMapBinderWithMultipleAnnotationValueSets() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder abcMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, (Annotation)Names.named((String)"abc"));
                abcMapBinder.addBinding((Object)"a").toInstance((Object)"A");
                abcMapBinder.addBinding((Object)"b").toInstance((Object)"B");
                abcMapBinder.addBinding((Object)"c").toInstance((Object)"C");
                MapBinder deMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, (Annotation)Names.named((String)"de"));
                deMapBinder.addBinding((Object)"d").toInstance((Object)"D");
                deMapBinder.addBinding((Object)"e").toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key abcKey = Key.get(this.mapOfString, (Annotation)Names.named((String)"abc"));
        Map abc = (Map)injector.getInstance(abcKey);
        Key deKey = Key.get(this.mapOfString, (Annotation)Names.named((String)"de"));
        Map de = (Map)injector.getInstance(deKey);
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)abc);
        MapBinderTest.assertEquals(this.mapOf("d", "D", "e", "E"), (Object)de);
        SpiUtils.assertMapVisitor(abcKey, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"));
        SpiUtils.assertMapVisitor(deKey, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("d", "D"), SpiUtils.instance("e", "E"));
        injector.getInstance(Key.get(this.mapOfStringProvider, (Annotation)Names.named((String)"abc")));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, (Annotation)Names.named((String)"abc")));
        injector.getInstance(Key.get(this.mapOfStringProvider, (Annotation)Names.named((String)"de")));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, (Annotation)Names.named((String)"de")));
    }

    public void testMapBinderWithMultipleAnnotationTypeSets() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder abcMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, Abc.class);
                abcMapBinder.addBinding((Object)"a").toInstance((Object)"A");
                abcMapBinder.addBinding((Object)"b").toInstance((Object)"B");
                abcMapBinder.addBinding((Object)"c").toInstance((Object)"C");
                MapBinder deMapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, De.class);
                deMapBinder.addBinding((Object)"d").toInstance((Object)"D");
                deMapBinder.addBinding((Object)"e").toInstance((Object)"E");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Key abcKey = Key.get(this.mapOfString, Abc.class);
        Map abc = (Map)injector.getInstance(abcKey);
        Key deKey = Key.get(this.mapOfString, De.class);
        Map de = (Map)injector.getInstance(deKey);
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)abc);
        MapBinderTest.assertEquals(this.mapOf("d", "D", "e", "E"), (Object)de);
        SpiUtils.assertMapVisitor(abcKey, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"));
        SpiUtils.assertMapVisitor(deKey, this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("d", "D"), SpiUtils.instance("e", "E"));
        injector.getInstance(Key.get(this.mapOfStringProvider, Abc.class));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, Abc.class));
        injector.getInstance(Key.get(this.mapOfStringProvider, De.class));
        injector.getInstance(Key.get(this.mapOfStringJakartaProvider, De.class));
    }

    public void testMapBinderWithMultipleTypes() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"a").toInstance((Object)"A");
                MapBinder.newMapBinder((Binder)this.binder(), String.class, Integer.class).addBinding((Object)"1").toInstance((Object)1);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        MapBinderTest.assertEquals(this.mapOf("a", "A"), (Object)injector.getInstance(Key.get(this.mapOfString)));
        MapBinderTest.assertEquals(this.mapOf("1", 1), (Object)injector.getInstance(Key.get(this.mapOfInteger)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("a", "A"));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfInteger), this.stringType, this.intType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 1, SpiUtils.instance("1", 1));
    }

    public void testMapBinderWithEmptyMap() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        Map map = (Map)injector.getInstance(Key.get(this.mapOfString));
        MapBinderTest.assertEquals(Collections.emptyMap(), (Object)map);
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, new SpiUtils.MapResult[0]);
    }

    public void testMapBinderMapIsUnmodifiable() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"a").toInstance((Object)"A");
            }
        }});
        Map map = (Map)injector.getInstance(Key.get(this.mapOfString));
        try {
            map.clear();
            MapBinderTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testMapBinderMapIsLazy() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, Integer.class).addBinding((Object)"num").toProvider((Provider)new Provider<Integer>(this){
                    int nextValue = 1;

                    public Integer get() {
                        return this.nextValue++;
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        MapBinderTest.assertEquals(this.mapOf("num", 1), (Object)injector.getInstance(Key.get(this.mapOfInteger)));
        MapBinderTest.assertEquals(this.mapOf("num", 2), (Object)injector.getInstance(Key.get(this.mapOfInteger)));
        MapBinderTest.assertEquals(this.mapOf("num", 3), (Object)injector.getInstance(Key.get(this.mapOfInteger)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfInteger), this.stringType, this.intType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.providerInstance("num", 1));
    }

    public void testMapBinderMapForbidsDuplicateKeys() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"a").toInstance((Object)"B");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            MapBinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Duplicate key \"a\" found in Map<String, String>.");
        }
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.MODULE, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("a", "B"));
    }

    public void testExhaustiveDuplicateErrorMessage() throws Exception {
        try {
            class Main
            extends AbstractModule {
                Main() {
                }

                protected void configure() {
                    MapBinder.newMapBinder((Binder)this.binder(), String.class, Object.class);
                    class Module1
                    extends AbstractModule {
                        Module1(MapBinderTest this$0) {
                        }

                        protected void configure() {
                            MapBinder mapbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Object.class);
                            mapbinder.addBinding((Object)"a").to(String.class);
                        }
                    }
                    this.install((Module)new Module1(MapBinderTest.this));
                    class Module2
                    extends AbstractModule {
                        Module2(MapBinderTest this$0) {
                        }

                        protected void configure() {
                            MapBinder mapbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Object.class);
                            mapbinder.addBinding((Object)"a").to(Integer.class);
                            mapbinder.addBinding((Object)"b").to(String.class);
                        }
                    }
                    this.install((Module)new Module2(MapBinderTest.this));
                    class Module3
                    extends AbstractModule {
                        Module3(MapBinderTest this$0) {
                        }

                        protected void configure() {
                            MapBinder mapbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Object.class);
                            mapbinder.addBinding((Object)"b").to(Integer.class);
                        }
                    }
                    this.install((Module)new Module3(MapBinderTest.this));
                }

                @Provides
                String provideString() {
                    return "foo";
                }

                @Provides
                Integer provideInt() {
                    return 42;
                }
            }
            Guice.createInjector((Module[])new Module[]{new Main()});
            MapBinderTest.fail();
        }
        catch (CreationException ce) {
            Asserts.assertContains(ce.getMessage(), "\"a\" and 1 other duplicate keys found in Map<String, Object>", "Key: \"a\"", "Bound at:", "MapBinderTest$1Main -> MapBinderTest$1Module1", "MapBinderTest$1Main -> MapBinderTest$1Module2", "Key: \"b\"", "Bound at:", "MapBinderTest$1Main -> MapBinderTest$1Module2", "MapBinderTest$1Main -> MapBinderTest$1Module3");
            MapBinderTest.assertEquals((int)1, (int)ce.getErrorMessages().size());
        }
    }

    public void testMapBinderMapPermitDuplicateElements() {
        AbstractModule ab = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.permitDuplicates();
            }
        };
        AbstractModule bc = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.permitDuplicates();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab, bc});
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)injector.getInstance(Key.get(this.mapOfString)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(ab, bc), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"));
    }

    public void testMapBinderMapDoesNotDedupeDuplicateValues() {
        AbstractModule m1 = new AbstractModule(){

            protected void configure() {
                class ValueType {
                    int keyPart;
                    int dataPart;

                    ValueType(MapBinderTest this$0, int keyPart, int dataPart) {
                        this.keyPart = keyPart;
                        this.dataPart = dataPart;
                    }

                    public boolean equals(Object obj) {
                        return obj instanceof ValueType && this.keyPart == ((ValueType)obj).keyPart;
                    }

                    public int hashCode() {
                        return this.keyPart;
                    }
                }
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ValueType.class);
                multibinder.addBinding((Object)"a").toInstance((Object)new ValueType(MapBinderTest.this, 1, 2));
            }
        };
        AbstractModule m2 = new AbstractModule(){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ValueType.class);
                multibinder.addBinding((Object)"b").toInstance((Object)new ValueType(MapBinderTest.this, 1, 3));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{m1, m2});
        Map map = (Map)injector.getInstance((Key)new Key<Map<String, ValueType>>(this){});
        MapBinderTest.assertEquals((int)2, (int)((ValueType)map.get((Object)"a")).dataPart);
        MapBinderTest.assertEquals((int)3, (int)((ValueType)map.get((Object)"b")).dataPart);
    }

    public void testMapBinderMultimap() {
        AbstractModule ab1c = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B1");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        AbstractModule b2c = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"b").toInstance((Object)"B2");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.permitDuplicates();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab1c, b2c});
        MapBinderTest.assertEquals(this.mapOf("a", this.setOf("A"), "b", this.setOf("B1", "B2"), "c", this.setOf("C")), (Object)injector.getInstance(Key.get(this.mapOfSetOfString)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(ab1c, b2c), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B1"), SpiUtils.instance("b", "B2"), SpiUtils.instance("c", "C"));
    }

    public void testMapBinderMultimapWithAnotation() {
        AbstractModule ab1 = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, Abc.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B1");
            }
        };
        AbstractModule b2c = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class, Abc.class);
                multibinder.addBinding((Object)"b").toInstance((Object)"B2");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.permitDuplicates();
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{ab1, b2c});
        MapBinderTest.assertEquals(this.mapOf("a", this.setOf("A"), "b", this.setOf("B1", "B2"), "c", this.setOf("C")), (Object)injector.getInstance(Key.get(this.mapOfSetOfString, Abc.class)));
        try {
            injector.getInstance(Key.get(this.mapOfSetOfString));
            MapBinderTest.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString, Abc.class), this.stringType, this.stringType, this.setOf(ab1, b2c), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B1"), SpiUtils.instance("b", "B2"), SpiUtils.instance("c", "C"));
    }

    public void testMapBinderMultimapIsUnmodifiable() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                mapBinder.addBinding((Object)"a").toInstance((Object)"A");
                mapBinder.permitDuplicates();
            }
        }});
        Map map = (Map)injector.getInstance(Key.get(this.mapOfSetOfString));
        try {
            map.clear();
            MapBinderTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ((Set)map.get("a")).clear();
            MapBinderTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testMapBinderMapForbidsNullKeys() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding(null);
                }
            }});
            MapBinderTest.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    public void testMapBinderMapForbidsNullValues() {
        class NullValueModule
        extends AbstractModule {
            NullValueModule(MapBinderTest this$0) {
            }

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"null").toProvider(Providers.of(null));
            }
        }
        NullValueModule m = new NullValueModule(this);
        Injector injector = Guice.createInjector((Module[])new Module[]{m});
        try {
            injector.getInstance(Key.get(this.mapOfString));
            MapBinderTest.fail();
        }
        catch (ProvisionException expected) {
            Asserts.assertContains(expected.getMessage(), "Map injection failed due to null value for key \"null\", bound at: MapBinderTest$1NullValueModule.configure");
        }
    }

    public void testMapBinderProviderIsScoped() {
        Provider<Integer> counter = new Provider<Integer>(this){
            int next = 1;

            public Integer get() {
                return this.next++;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (Provider)counter){
            final /* synthetic */ Provider val$counter;
            {
                this.val$counter = provider;
            }

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, Integer.class).addBinding((Object)"one").toProvider(this.val$counter).asEagerSingleton();
            }
        }});
        MapBinderTest.assertEquals((int)1, (int)((Integer)((Map)injector.getInstance(Key.get(this.mapOfInteger))).get("one")));
        MapBinderTest.assertEquals((int)1, (int)((Integer)((Map)injector.getInstance(Key.get(this.mapOfInteger))).get("one")));
    }

    public void testSourceLinesInMapBindings() {
        try {
            class SimpleBinding
            extends AbstractModule {
                SimpleBinding(MapBinderTest this$0) {
                }

                protected void configure() {
                    MapBinder.newMapBinder((Binder)this.binder(), String.class, Integer.class).addBinding((Object)"one");
                }
            }
            Guice.createInjector((Module[])new Module[]{new SimpleBinding(this)});
            MapBinderTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for Integer", "1  : MapBinderTest$1SimpleBinding.configure");
        }
    }

    public void testMultibinderDependencies() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class);
                mapBinder.addBinding((Object)1).toInstance((Object)"A");
                mapBinder.addBinding((Object)2).to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding((Key)new Key<Map<Integer, String>>(this){});
        HasDependencies withDependencies = (HasDependencies)binding;
        Set actualDependencies = withDependencies.getDependencies();
        MapBinderTest.assertEquals((int)2, (int)actualDependencies.size());
        for (Dependency dependency : actualDependencies) {
            Key key = dependency.getKey();
            MapBinderTest.assertEquals((Object)new TypeLiteral<String>(this){}, (Object)key.getTypeLiteral());
            Annotation annotation = dependency.getKey().getAnnotation();
            MapBinderTest.assertTrue((boolean)(annotation instanceof Element));
            Element element = (Element)annotation;
            MapBinderTest.assertEquals((String)"", (String)element.setName());
            MapBinderTest.assertEquals((Object)Element.Type.MAPBINDER, (Object)element.type());
            MapBinderTest.assertEquals((String)"java.lang.Integer", (String)element.keyType());
        }
        HashSet elements = Sets.newHashSet();
        elements.addAll(this.recurseForDependencies(injector, withDependencies));
        MapBinderTest.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B"), (Object)elements);
    }

    private Set<String> recurseForDependencies(Injector injector, HasDependencies hasDependencies) {
        HashSet elements = Sets.newHashSet();
        for (Dependency dependency : hasDependencies.getDependencies()) {
            Binding binding = injector.getBinding(dependency.getKey());
            HasDependencies deps = (HasDependencies)binding;
            if (binding instanceof InstanceBinding) {
                elements.add((String)((InstanceBinding)binding).getInstance());
                continue;
            }
            elements.addAll(this.recurseForDependencies(injector, deps));
        }
        return elements;
    }

    public void testMultibinderDependenciesInToolStage() {
        Injector injector = Guice.createInjector((Stage)Stage.TOOL, (Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class);
                mapBinder.addBinding((Object)1).toInstance((Object)"A");
                mapBinder.addBinding((Object)2).to(Key.get(String.class, (Annotation)Names.named((String)"b")));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"b")).to("B");
            }
        }});
        Binding binding = injector.getBinding((Key)new Key<Map<Integer, String>>(this){});
        HasDependencies withDependencies = (HasDependencies)binding;
        Set actualDependencies = withDependencies.getDependencies();
        MapBinderTest.assertEquals((int)2, (int)actualDependencies.size());
        for (Dependency dependency : actualDependencies) {
            Key key = dependency.getKey();
            MapBinderTest.assertEquals((Object)new TypeLiteral<String>(this){}, (Object)key.getTypeLiteral());
            Annotation annotation = dependency.getKey().getAnnotation();
            MapBinderTest.assertTrue((boolean)(annotation instanceof Element));
            Element element = (Element)annotation;
            MapBinderTest.assertEquals((String)"", (String)element.setName());
            MapBinderTest.assertEquals((Object)Element.Type.MAPBINDER, (Object)element.type());
            MapBinderTest.assertEquals((String)"java.lang.Integer", (String)element.keyType());
        }
    }

    public void testBindOrderEqualsIterationOrder() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                mapBinder.addBinding((Object)"leonardo").toInstance((Object)"blue");
                mapBinder.addBinding((Object)"donatello").toInstance((Object)"purple");
                this.install((Module)new AbstractModule(this){

                    protected void configure() {
                        MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"michaelangelo").toInstance((Object)"orange");
                    }
                });
            }
        }, new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"raphael").toInstance((Object)"red");
            }
        }});
        Map map = (Map)injector.getInstance((Key)new Key<Map<String, String>>(this){});
        Iterator iterator = map.entrySet().iterator();
        MapBinderTest.assertEquals((Object)Maps.immutableEntry((Object)"leonardo", (Object)"blue"), iterator.next());
        MapBinderTest.assertEquals((Object)Maps.immutableEntry((Object)"donatello", (Object)"purple"), iterator.next());
        MapBinderTest.assertEquals((Object)Maps.immutableEntry((Object)"michaelangelo", (Object)"orange"), iterator.next());
        MapBinderTest.assertEquals((Object)Maps.immutableEntry((Object)"raphael", (Object)"red"), iterator.next());
    }

    public void testModuleOverrideAndMapBindings() {
        AbstractModule ab = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
            }
        };
        AbstractModule cd = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.addBinding((Object)"d").toInstance((Object)"D");
            }
        };
        AbstractModule ef = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"e").toInstance((Object)"E");
                multibinder.addBinding((Object)"f").toInstance((Object)"F");
            }
        };
        Module abcd = Modules.override((Module[])new Module[]{ab}).with(new Module[]{cd});
        Injector injector = Guice.createInjector((Module[])new Module[]{abcd, ef});
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F"), (Object)injector.getInstance(Key.get(this.mapOfString)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(abcd, ef), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"), SpiUtils.instance("d", "D"), SpiUtils.instance("e", "E"), SpiUtils.instance("f", "F"));
    }

    public void testDeduplicateMapBindings() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapbinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                mapbinder.addBinding((Object)"a").toInstance((Object)"A");
                mapbinder.addBinding((Object)"a").toInstance((Object)"A");
                mapbinder.addBinding((Object)"b").toInstance((Object)"B");
                mapbinder.addBinding((Object)"b").toInstance((Object)"B");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B"), (Object)injector.getInstance(Key.get(this.mapOfString)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(module), SpiUtils.VisitType.BOTH, false, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"));
    }

    public void testModuleOverrideAndMapBindingsWithPermitDuplicates() {
        AbstractModule abc = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.permitDuplicates();
            }
        };
        AbstractModule cd = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
                multibinder.addBinding((Object)"d").toInstance((Object)"D");
                multibinder.permitDuplicates();
            }
        };
        AbstractModule ef = new AbstractModule(this){

            protected void configure() {
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"e").toInstance((Object)"E");
                multibinder.addBinding((Object)"f").toInstance((Object)"F");
                multibinder.permitDuplicates();
            }
        };
        Module abcd = Modules.override((Module[])new Module[]{abc}).with(new Module[]{cd});
        Injector injector = Guice.createInjector((Module[])new Module[]{abcd, ef});
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F"), (Object)injector.getInstance(Key.get(this.mapOfString)));
        SpiUtils.assertMapVisitor(Key.get(this.mapOfString), this.stringType, this.stringType, this.setOf(abcd, ef), SpiUtils.VisitType.BOTH, true, 0, SpiUtils.instance("a", "A"), SpiUtils.instance("b", "B"), SpiUtils.instance("c", "C"), SpiUtils.instance("d", "D"), SpiUtils.instance("e", "E"), SpiUtils.instance("f", "F"));
    }

    public void testBasicMapDependencyInjection() {
        final AtomicReference injectedMap = new AtomicReference();
        final Object anObject = new Object(this){

            @Inject
            void initialize(Map<String, String> map) {
                injectedMap.set(map);
            }
        };
        AbstractModule abc = new AbstractModule(this){

            protected void configure() {
                this.requestInjection(anObject);
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        Guice.createInjector((Module[])new Module[]{abc});
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), injectedMap.get());
    }

    public void testProviderMultimapDependencyInjection() {
        final AtomicReference injectedMultimap = new AtomicReference();
        final Object anObject = new Object(this){

            @Inject
            void initialize(Map<String, Set<Provider<String>>> multimap) {
                injectedMultimap.set(multimap);
            }
        };
        AbstractModule abc = new AbstractModule(this){

            protected void configure() {
                this.requestInjection(anObject);
                MapBinder multibinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                multibinder.permitDuplicates();
                multibinder.addBinding((Object)"a").toInstance((Object)"A");
                multibinder.addBinding((Object)"b").toInstance((Object)"B");
                multibinder.addBinding((Object)"c").toInstance((Object)"C");
            }
        };
        Guice.createInjector((Module[])new Module[]{abc});
        Map map = Maps.transformValues((Map)((Map)injectedMultimap.get()), stringProvidersSet -> (String)((Provider)Iterables.getOnlyElement((Iterable)stringProvidersSet)).get());
        MapBinderTest.assertEquals(this.mapOf("a", "A", "b", "B", "c", "C"), (Object)map);
    }

    private <K, V> Map<K, V> mapOf(Object ... elements) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < elements.length; i += 2) {
            result.put(elements[i], elements[i + 1]);
        }
        return result;
    }

    private <V> Set<V> setOf(V ... elements) {
        return new HashSet<V>(Arrays.asList(elements));
    }

    @Marker
    public void testMapBinderMatching() throws Exception {
        Method m = MapBinderTest.class.getDeclaredMethod("testMapBinderMatching", new Class[0]);
        MapBinderTest.assertNotNull((Object)m);
        final Marker marker = m.getAnnotation(Marker.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            public void configure() {
                MapBinder mb1 = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, Integer.class, Marker.class);
                MapBinder mb2 = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, Integer.class, (Annotation)marker);
                mb1.addBinding((Object)1).toInstance((Object)1);
                mb2.addBinding((Object)2).toInstance((Object)2);
                TestCase.assertEquals((Object)mb1, (Object)mb2);
            }
        }});
        TypeLiteral<Map<Integer, Integer>> t = new TypeLiteral<Map<Integer, Integer>>(this){};
        Map s1 = (Map)injector.getInstance(Key.get((TypeLiteral)t, Marker.class));
        Map s2 = (Map)injector.getInstance(Key.get((TypeLiteral)t, (Annotation)marker));
        MapBinderTest.assertEquals((Object)s1, (Object)s2);
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(1, 1);
        expected.put(2, 2);
        MapBinderTest.assertEquals(expected, (Object)s1);
    }

    public void testTwoMapBindersAreDistinct() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class).addBinding((Object)"A").toInstance((Object)"a");
                MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class).addBinding((Object)1).toInstance((Object)"b");
            }
        }});
        Collector collector = new Collector();
        Binding map1 = injector.getBinding(Key.get(this.mapOfString));
        map1.acceptTargetVisitor((BindingTargetVisitor)collector);
        MapBinderTest.assertNotNull(collector.mapbinding);
        MapBinderBinding<? extends Object> map1Binding = collector.mapbinding;
        Binding map2 = injector.getBinding(Key.get(this.mapOfIntString));
        map2.acceptTargetVisitor((BindingTargetVisitor)collector);
        MapBinderTest.assertNotNull(collector.mapbinding);
        MapBinderBinding<? extends Object> map2Binding = collector.mapbinding;
        List bindings = injector.findBindingsByType(this.stringType);
        MapBinderTest.assertEquals((String)("should have two elements: " + bindings), (int)2, (int)bindings.size());
        Binding a = (Binding)bindings.get(0);
        Binding b = (Binding)bindings.get(1);
        MapBinderTest.assertEquals((String)"a", (String)((String)((InstanceBinding)a).getInstance()));
        MapBinderTest.assertEquals((String)"b", (String)((String)((InstanceBinding)b).getInstance()));
        MapBinderTest.assertTrue((boolean)map1Binding.containsElement((com.google.inject.spi.Element)a));
        MapBinderTest.assertFalse((boolean)map1Binding.containsElement((com.google.inject.spi.Element)b));
        MapBinderTest.assertFalse((boolean)map2Binding.containsElement((com.google.inject.spi.Element)a));
        MapBinderTest.assertTrue((boolean)map2Binding.containsElement((com.google.inject.spi.Element)b));
    }

    public void testWeakKeySet_integration_mapbinder() {
        Key mapKey = Key.get((TypeLiteral)new TypeLiteral<Map<String, String>>(this){});
        Injector parentInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"hi");
            }
        }});
        WeakKeySetUtils.assertNotBanned(parentInjector, mapKey);
        Injector childInjector = parentInjector.createChildInjector(new Module[]{new AbstractModule(this){

            protected void configure() {
                MapBinder binder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                binder.addBinding((Object)"bar").toInstance((Object)"foo");
            }
        }});
        WeakReference<Injector> weakRef = new WeakReference<Injector>(childInjector);
        WeakKeySetUtils.assertBanned(parentInjector, mapKey);
        childInjector = null;
        Asserts.awaitClear(weakRef);
        WeakKeySetUtils.assertNotBanned(parentInjector, mapKey);
    }

    public void testGetEntries() {
        List elements = Elements.getElements((Module[])new Module[]{new MapBinderWithTwoEntriesModule()});
        MapBinderBinding<?> mapBinderBinding = MapBinderTest.getMapBinderBinding(elements);
        List mapEntries = mapBinderBinding.getEntries((Iterable)elements);
        Map.Entry firstEntry = (Map.Entry)mapEntries.get(0);
        MapBinderTest.assertEquals((Object)"keyOne", firstEntry.getKey());
        Binding firstBinding = (Binding)firstEntry.getValue();
        MapBinderTest.assertEquals((Object)"valueOne", (Object)((InstanceBinding)firstBinding).getInstance());
        Map.Entry secondEntry = (Map.Entry)mapEntries.get(1);
        MapBinderTest.assertEquals((Object)"keyTwo", secondEntry.getKey());
        Binding secondBinding = (Binding)secondEntry.getValue();
        MapBinderTest.assertEquals((Object)"valueTwo", (Object)((InstanceBinding)secondBinding).getInstance());
    }

    public void testGetEntriesWithDuplicateKeys() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                mapBinder.addBinding((Object)"A").toInstance((Object)"a1");
                mapBinder.addBinding((Object)"A").toInstance((Object)"a2");
                mapBinder.permitDuplicates();
            }
        };
        List elements = Elements.getElements((Module[])new Module[]{module});
        MapBinderBinding<?> mapBinderBinding = MapBinderTest.getMapBinderBinding(elements);
        List mapEntries = mapBinderBinding.getEntries((Iterable)elements);
        Map.Entry firstEntry = (Map.Entry)mapEntries.get(0);
        MapBinderTest.assertEquals((Object)"A", firstEntry.getKey());
        Binding firstBinding = (Binding)firstEntry.getValue();
        MapBinderTest.assertEquals((Object)"a1", (Object)((InstanceBinding)firstBinding).getInstance());
        Map.Entry secondEntry = (Map.Entry)mapEntries.get(1);
        MapBinderTest.assertEquals((Object)"A", secondEntry.getKey());
        Binding secondBinding = (Binding)secondEntry.getValue();
        MapBinderTest.assertEquals((Object)"a2", (Object)((InstanceBinding)secondBinding).getInstance());
    }

    public void testGetEntriesWithDuplicateValues() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
                mapBinder.addBinding((Object)"A").toInstance((Object)"a");
                mapBinder.addBinding((Object)"A").toInstance((Object)"a");
            }
        };
        List elements = Elements.getElements((Module[])new Module[]{module});
        MapBinderBinding<?> mapBinderBinding = MapBinderTest.getMapBinderBinding(elements);
        List mapEntries = mapBinderBinding.getEntries((Iterable)elements);
        Map.Entry firstEntry = (Map.Entry)mapEntries.get(0);
        MapBinderTest.assertEquals((Object)"A", firstEntry.getKey());
        Binding firstBinding = (Binding)firstEntry.getValue();
        MapBinderTest.assertEquals((Object)"a", (Object)((InstanceBinding)firstBinding).getInstance());
        Map.Entry secondEntry = (Map.Entry)mapEntries.get(1);
        MapBinderTest.assertEquals((Object)"A", secondEntry.getKey());
        Binding secondBinding = (Binding)secondEntry.getValue();
        MapBinderTest.assertEquals((Object)"a", (Object)((InstanceBinding)secondBinding).getInstance());
    }

    public void testGetEntriesMissingProviderMapEntry() {
        ArrayList elements = Lists.newArrayList((Iterable)Elements.getElements((Module[])new Module[]{new MapBinderWithTwoEntriesModule()}));
        MapBinderBinding<?> mapBinderBinding = MapBinderTest.getMapBinderBinding(elements);
        com.google.inject.spi.Element providerMapEntryForA = MapBinderTest.getProviderMapEntry("keyOne", elements);
        boolean removeSuccessful = elements.remove(providerMapEntryForA);
        MapBinderTest.assertTrue((boolean)removeSuccessful);
        try {
            mapBinderBinding.getEntries((Iterable)elements);
            MapBinderTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Expected a 1:1 mapping from map keys to values.", "Found these Bindings that were missing an associated entry:", "java.lang.String", "bound at:", "MapBinderWithTwoEntriesModule");
        }
    }

    private static com.google.inject.spi.Element getProviderMapEntry(Object kToFind, Iterable<com.google.inject.spi.Element> elements) {
        for (com.google.inject.spi.Element element : elements) {
            RealMapBinder.ProviderMapEntry pme;
            jakarta.inject.Provider usp;
            if (!(element instanceof ProviderInstanceBinding) || !((usp = ((ProviderInstanceBinding)element).getUserSuppliedProvider()) instanceof RealMapBinder.ProviderMapEntry) || !kToFind.equals((pme = (RealMapBinder.ProviderMapEntry)usp).getKey())) continue;
            return element;
        }
        return null;
    }

    public void testGetEntriesMissingBindingForValue() {
        ArrayList elements = Lists.newArrayList((Iterable)Elements.getElements((Module[])new Module[]{new MapBinderWithTwoEntriesModule()}));
        MapBinderBinding<?> mapBinderBinding = MapBinderTest.getMapBinderBinding(elements);
        com.google.inject.spi.Element bindingForA = MapBinderTest.getInstanceBindingForValue("valueOne", elements);
        boolean removeSuccessful = elements.remove(bindingForA);
        MapBinderTest.assertTrue((boolean)removeSuccessful);
        try {
            mapBinderBinding.getEntries((Iterable)elements);
            MapBinderTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Expected a 1:1 mapping from map keys to values.", "Found these map keys without a corresponding value:", "keyOne", "bound at:", "MapBinderWithTwoEntriesModule");
        }
    }

    public void testMapBinderWildcardsAlias() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class);
                mapBinder.addBinding((Object)1).toInstance((Object)"1");
                mapBinder.addBinding((Object)2).toInstance((Object)"2");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        ImmutableMap expectedMap = ImmutableMap.of((Object)1, (Object)"1", (Object)2, (Object)"2");
        MapBinderTest.assertEquals((Object)expectedMap, (Object)injector.getInstance((Key)new Key<Map<Integer, String>>(this){}));
        MapBinderTest.assertEquals((Object)expectedMap, (Object)injector.getInstance((Key)new Key<Map<Integer, ? extends String>>(this){}));
    }

    public void testMapBinderConflictsWithExistingWildcard() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class);
                mapBinder.addBinding((Object)1).toInstance((Object)"1");
                mapBinder.addBinding((Object)2).toInstance((Object)"2");
            }

            @Provides
            protected Map<Integer, ? extends String> provideMap() {
                return ImmutableMap.of((Object)1, (Object)"1", (Object)2, (Object)"2");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            MapBinderTest.fail();
        }
        catch (CreationException e) {
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Map<Integer, ? extends String> was bound multiple times.");
        }
    }

    public void testMapBinderConflictsWithExistingMapBinder() {
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), Integer.class, String.class);
                mapBinder.addBinding((Object)1).toInstance((Object)"1");
                mapBinder.addBinding((Object)2).toInstance((Object)"2");
                TypeLiteral valueType = TypeLiteral.get((Type)Types.subtypeOf(String.class));
                MapBinder mapBinder2 = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(Integer.class), (TypeLiteral)valueType);
                mapBinder2.addBinding((Object)1).toInstance((Object)"1");
                mapBinder2.addBinding((Object)2).toInstance((Object)"2");
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{module});
            MapBinderTest.fail();
        }
        catch (CreationException e) {
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Map<Integer, ? extends String> was bound multiple times.");
        }
    }

    private static com.google.inject.spi.Element getInstanceBindingForValue(Object vToFind, Iterable<com.google.inject.spi.Element> elements) {
        for (com.google.inject.spi.Element element : elements) {
            Object instanceFromBinding;
            if (!(element instanceof InstanceBinding) || !vToFind.equals(instanceFromBinding = ((InstanceBinding)element).getInstance())) continue;
            return element;
        }
        return null;
    }

    private static MapBinderBinding<?> getMapBinderBinding(Iterable<com.google.inject.spi.Element> elements) {
        final Collector collector = new Collector();
        for (com.google.inject.spi.Element element : elements) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    binding.acceptTargetVisitor((BindingTargetVisitor)collector);
                    return null;
                }
            });
        }
        return collector.mapbinding;
    }

    private static final class MapBinderWithTwoEntriesModule
    extends AbstractModule {
        private MapBinderWithTwoEntriesModule() {
        }

        protected void configure() {
            MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, String.class);
            mapBinder.addBinding((Object)"keyOne").toInstance((Object)"valueOne");
            mapBinder.addBinding((Object)"keyTwo").toInstance((Object)"valueTwo");
        }
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Marker {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface De {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Abc {
    }
}

