/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Asserts;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;

public class MoreTypesTest
extends TestCase {
    public void testParameterizedTypeToString() {
        TypeLiteral<Inner<String>> innerString = new TypeLiteral<Inner<String>>(this){};
        MoreTypesTest.assertEquals((String)"com.google.inject.internal.MoreTypesTest$Inner<java.lang.String>", (String)MoreTypes.typeToString((Type)innerString.getType()));
        TypeLiteral<Set<Inner<Integer>>> mapInnerInteger = new TypeLiteral<Set<Inner<Integer>>>(this){};
        MoreTypesTest.assertEquals((String)"java.util.Set<com.google.inject.internal.MoreTypesTest$Inner<java.lang.Integer>>", (String)MoreTypes.typeToString((Type)mapInnerInteger.getType()));
        TypeLiteral<Map<Inner<Long>, Set<Inner<Long>>>> mapInnerLongToSetInnerLong = new TypeLiteral<Map<Inner<Long>, Set<Inner<Long>>>>(this){};
        MoreTypesTest.assertEquals((String)"java.util.Map<com.google.inject.internal.MoreTypesTest$Inner<java.lang.Long>, java.util.Set<com.google.inject.internal.MoreTypesTest$Inner<java.lang.Long>>>", (String)MoreTypes.typeToString((Type)mapInnerLongToSetInnerLong.getType()));
    }

    public void testParameterizedType_lessArgs() {
        IllegalArgumentException expected = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new MoreTypes.ParameterizedTypeImpl(MoreTypesTest.class, D.class, new Type[]{String.class}));
        Asserts.assertContains(expected.getMessage(), "Length of provided type arguments is less than length of required parameters for class");
    }

    public void testParameterizedType_correctArgs() {
        MoreTypes.ParameterizedTypeImpl parameterizedType = new MoreTypes.ParameterizedTypeImpl(MoreTypesTest.class, D.class, new Type[]{String.class, Integer.class});
        MoreTypesTest.assertEquals((Object)parameterizedType.getRawType(), D.class);
    }

    public void testParameterizedType_moreArgs() {
        MoreTypes.ParameterizedTypeImpl parameterizedType = new MoreTypes.ParameterizedTypeImpl(MoreTypesTest.class, D.class, new Type[]{String.class, Integer.class, Integer.class});
        MoreTypesTest.assertEquals((Object)parameterizedType.getRawType(), D.class);
    }

    public <T> void testEquals_typeVariable() throws Exception {
        TypeVariable<Method> type = ((Object)((Object)this)).getClass().getMethod("testEquals_typeVariable", new Class[0]).getTypeParameters()[0];
        MoreTypesTest.assertTrue((boolean)MoreTypes.equals((Type)new TypeLiteral<T>(this){}.getType(), type));
    }

    public <T> void testGetRawType_wildcard() throws Exception {
        WildcardType wildcard = (WildcardType)((ParameterizedType)new TypeLiteral<List<?>>(this){}.getType()).getActualTypeArguments()[0];
        MoreTypesTest.assertEquals(Object.class, (Object)MoreTypes.getRawType((Type)wildcard));
    }

    static class E
    extends D<String, Integer> {
        E() {
        }
    }

    static class D<S, T> {
        D() {
        }
    }

    public static class Inner<T> {
    }
}

