/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.name;

import com.google.common.testing.EqualsTester;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.internal.Annotations;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import jakarta.inject.Qualifier;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Properties;
import junit.framework.TestCase;

public class NamedEquivalanceTest
extends TestCase {
    private static final Module GUICE_BINDING_MODULE = NamedEquivalanceTest.moduleWithAnnotation((Annotation)Names.named((String)"foo"));
    private static final Module JSR330_BINDING_MODULE = NamedEquivalanceTest.moduleWithAnnotation((Annotation)((Object)new JsrNamed("foo")));
    private static final Module JAKARTA_BINDING_MODULE = NamedEquivalanceTest.moduleWithAnnotation((Annotation)((Object)new JakartaNamed("foo")));
    private static final Module GUICE_PROVIDER_METHOD_MODULE = NamedEquivalanceTest.getGuiceBindingProviderMethodModule();
    private static final Module JSR330_PROVIDER_METHOD_MODULE = NamedEquivalanceTest.getJsr330BindingProviderMethodModule();
    private static final Module JAKARTA_PROVIDER_METHOD_MODULE = NamedEquivalanceTest.getJakartaBindingProviderMethodModule();

    public void testKeysCreatedWithDifferentTypesAreEqual() {
        new EqualsTester().addEqualityGroup(new Object[]{NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new GuiceNamed("foo"))), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JsrNamed("foo"))), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JakartaNamed("foo")))}).addEqualityGroup(new Object[]{NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new GuiceNamed("bar"))), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JsrNamed("bar"))), NamedEquivalanceTest.keyForAnnotation((Annotation)((Object)new JakartaNamed("bar")))}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{NamedEquivalanceTest.keyForAnnotationType(Named.class), NamedEquivalanceTest.keyForAnnotationType(jakarta.inject.Named.class), NamedEquivalanceTest.keyForAnnotationType(jakarta.inject.Named.class)}).addEqualityGroup(new Object[]{NamedEquivalanceTest.keyForAnnotationType(NotNamed.class)});
    }

    private static Key<String> keyForAnnotation(Annotation annotation) {
        return Key.get(String.class, (Annotation)annotation);
    }

    private static Key<String> keyForAnnotationType(Class<? extends Annotation> annotationType) {
        return Key.get(String.class, annotationType);
    }

    public void testBindingWithNamesCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(GUICE_BINDING_MODULE);
    }

    public void testBindingWithJsr330AnnotationCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JSR330_BINDING_MODULE);
    }

    public void testBindingWithJakartannotationCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JAKARTA_BINDING_MODULE);
    }

    public void testBindingWithGuiceNamedAnnotatedProviderMethodCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(GUICE_PROVIDER_METHOD_MODULE);
    }

    public void testBindingWithJsr330NamedAnnotatedProviderMethodCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JSR330_PROVIDER_METHOD_MODULE);
    }

    public void testBindingWithJakartaNamedAnnotatedProviderMethodCanInjectAllTypes() {
        NamedEquivalanceTest.assertInjectionsSucceed(JAKARTA_PROVIDER_METHOD_MODULE);
    }

    public void testBindingDifferentTypesWithSameValueIsIgnored() {
        NamedEquivalanceTest.assertDuplicateBinding(false, GUICE_BINDING_MODULE, JSR330_BINDING_MODULE, JAKARTA_BINDING_MODULE);
    }

    public void testBindingDifferentTypesWithSameValueIsAnErrorWithProviderMethods() {
        NamedEquivalanceTest.assertDuplicateBinding(true, GUICE_PROVIDER_METHOD_MODULE, JSR330_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, GUICE_PROVIDER_METHOD_MODULE, JAKARTA_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JSR330_PROVIDER_METHOD_MODULE, GUICE_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JSR330_PROVIDER_METHOD_MODULE, JAKARTA_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JAKARTA_PROVIDER_METHOD_MODULE, JSR330_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JAKARTA_PROVIDER_METHOD_MODULE, GUICE_PROVIDER_METHOD_MODULE);
    }

    public void testBindingDifferentTypesWithSameValueIsAnErrorMixed() {
        NamedEquivalanceTest.assertDuplicateBinding(true, GUICE_BINDING_MODULE, JSR330_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, GUICE_BINDING_MODULE, JAKARTA_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JSR330_BINDING_MODULE, GUICE_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JSR330_BINDING_MODULE, JAKARTA_PROVIDER_METHOD_MODULE);
        NamedEquivalanceTest.assertDuplicateBinding(true, JAKARTA_BINDING_MODULE, GUICE_PROVIDER_METHOD_MODULE);
    }

    public void testMissingBindingForGuiceNamedUsesSameTypeInErrorMessage() {
        NamedEquivalanceTest.assertMissingBindingErrorMessageUsesType(GuiceNamedClient.class);
    }

    public void testMissingBindingForJsr330NamedUsesSameTypeInErrorMessage() {
        NamedEquivalanceTest.assertMissingBindingErrorMessageUsesType(Jsr330NamedClient.class);
    }

    public void testMissingBindingForJakartaamedUsesSameTypeInErrorMessage() {
        NamedEquivalanceTest.assertMissingBindingErrorMessageUsesType(Jsr330NamedClient.class);
    }

    public void testBindPropertiesWorksWithJsr330() {
        NamedEquivalanceTest.assertInjectionsSucceed((Module)new AbstractModule(this){

            protected void configure() {
                Properties properties = new Properties();
                properties.put("foo", "bar");
                Names.bindProperties((Binder)this.binder(), (Properties)properties);
            }
        });
    }

    private static void assertMissingBindingErrorMessageUsesType(Class<?> clientType) {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(clientType);
            NamedEquivalanceTest.fail((String)"should have thrown ConfigurationException");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "No implementation for String annotated with @Named(" + Annotations.memberValueString((String)"value", (Object)"foo") + ") was bound.");
        }
    }

    private static void assertDuplicateBinding(boolean fails, Module ... modules) {
        try {
            Guice.createInjector((Module[])modules);
            if (fails) {
                NamedEquivalanceTest.fail((String)"should have thrown CreationException");
            }
        }
        catch (CreationException e) {
            if (fails) {
                Asserts.assertContains(e.getMessage(), "String annotated with @Named(" + Annotations.memberValueString((String)"value", (Object)"foo") + ") was bound multiple times.");
            }
            throw e;
        }
    }

    private static Module moduleWithAnnotation(final Annotation annotation) {
        return new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith(annotation).to("bar");
            }
        };
    }

    private static void assertInjectionsSucceed(Module module) {
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        NamedEquivalanceTest.assertInjected((GuiceNamedClient)injector.getInstance(GuiceNamedClient.class), (Jsr330NamedClient)injector.getInstance(Jsr330NamedClient.class), (JakartaNamedClient)injector.getInstance(JakartaNamedClient.class));
    }

    private static void assertInjected(GuiceNamedClient guiceClient, Jsr330NamedClient jsr330Client, JakartaNamedClient jakartaClient) {
        NamedEquivalanceTest.assertEquals((String)"bar", (String)guiceClient.foo);
        NamedEquivalanceTest.assertEquals((String)"bar", (String)jsr330Client.foo);
        NamedEquivalanceTest.assertEquals((String)"bar", (String)jakartaClient.foo);
    }

    private static Module getJakartaBindingProviderMethodModule() {
        return new AbstractModule(){

            @Provides
            @jakarta.inject.Named(value="foo")
            String provideFoo() {
                return "bar";
            }
        };
    }

    private static Module getJsr330BindingProviderMethodModule() {
        return new AbstractModule(){

            @Provides
            @jakarta.inject.Named(value="foo")
            String provideFoo() {
                return "bar";
            }
        };
    }

    private static Module getGuiceBindingProviderMethodModule() {
        return new AbstractModule(){

            @Provides
            @Named(value="foo")
            String provideFoo() {
                return "bar";
            }
        };
    }

    private static class GuiceNamed
    implements Named,
    Serializable {
        private final String value;
        private static final long serialVersionUID = 0L;

        public GuiceNamed(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Named)) {
                return false;
            }
            Named other = (Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            return "@" + Named.class.getName() + "(value=" + Annotations.memberValueString((String)"value", (Object)this.value) + ")";
        }

        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }
    }

    private static class JsrNamed
    implements jakarta.inject.Named,
    Serializable {
        private final String value;
        private static final long serialVersionUID = 0L;

        public JsrNamed(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof jakarta.inject.Named)) {
                return false;
            }
            jakarta.inject.Named other = (jakarta.inject.Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            return "@" + jakarta.inject.Named.class.getName() + "(value=" + Annotations.memberValueString((String)"value", (Object)this.value) + ")";
        }

        public Class<? extends Annotation> annotationType() {
            return jakarta.inject.Named.class;
        }
    }

    private static class JakartaNamed
    implements jakarta.inject.Named,
    Serializable {
        private final String value;
        private static final long serialVersionUID = 0L;

        public JakartaNamed(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof jakarta.inject.Named)) {
                return false;
            }
            jakarta.inject.Named other = (jakarta.inject.Named)o;
            return this.value.equals(other.value());
        }

        public String toString() {
            return "@" + jakarta.inject.Named.class.getName() + "(value=" + Annotations.memberValueString((String)"value", (Object)this.value) + ")";
        }

        public Class<? extends Annotation> annotationType() {
            return jakarta.inject.Named.class;
        }
    }

    private static class JakartaNamedClient {
        @Inject
        @jakarta.inject.Named(value="foo")
        String foo;

        private JakartaNamedClient() {
        }
    }

    private static class Jsr330NamedClient {
        @Inject
        @jakarta.inject.Named(value="foo")
        String foo;

        private Jsr330NamedClient() {
        }
    }

    private static class GuiceNamedClient {
        @Inject
        @Named(value="foo")
        String foo;

        private GuiceNamedClient() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NotNamed {
    }
}

