/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.name;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class NamesTest
extends TestCase {
    @Named(value="foo")
    private String foo;
    private Named namedFoo;

    protected void setUp() throws Exception {
        super.setUp();
        this.namedFoo = ((Object)((Object)this)).getClass().getDeclaredField("foo").getAnnotation(Named.class);
    }

    public void testConsistentEqualsAndHashcode() {
        Named actual = Names.named((String)"foo");
        Asserts.assertEqualsBothWays(this.namedFoo, actual);
        NamesTest.assertEquals((String)this.namedFoo.toString(), (String)actual.toString());
    }

    public void testNamedIsSerializable() throws IOException {
        Asserts.assertEqualWhenReserialized(Names.named((String)"foo"));
    }

    public void testBindPropertiesUsingProperties() {
        final Properties teams = new Properties();
        teams.setProperty("SanJose", "Sharks");
        teams.setProperty("Edmonton", "Oilers");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)teams);
            }
        }});
        NamesTest.assertEquals((String)"Sharks", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"SanJose")))));
        NamesTest.assertEquals((String)"Oilers", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Edmonton")))));
    }

    public void testBindPropertiesUsingMap() {
        ImmutableMap properties = ImmutableMap.of((Object)"SanJose", (Object)"Sharks", (Object)"Edmonton", (Object)"Oilers");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this, (Map)properties){
            final /* synthetic */ Map val$properties;
            {
                this.val$properties = map;
            }

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Map)this.val$properties);
            }
        }});
        NamesTest.assertEquals((String)"Sharks", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"SanJose")))));
        NamesTest.assertEquals((String)"Oilers", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Edmonton")))));
    }

    public void testBindPropertiesIncludesInheritedProperties() {
        Properties defaults = new Properties();
        defaults.setProperty("Edmonton", "Eskimos");
        defaults.setProperty("Regina", "Pats");
        final Properties teams = new Properties(defaults);
        teams.setProperty("SanJose", "Sharks");
        teams.setProperty("Edmonton", "Oilers");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)teams);
            }
        }});
        NamesTest.assertEquals((String)"Pats", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Regina")))));
        NamesTest.assertEquals((String)"Oilers", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Edmonton")))));
        NamesTest.assertEquals((String)"Sharks", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"SanJose")))));
        try {
            injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Calgary")));
            NamesTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

