/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.RestrictedBindingSource;
import com.google.inject.spi.BindingSourceRestriction;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.util.Modules;
import jakarta.inject.Named;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class BindingSourceRestrictionTest {
    @Test
    public void singleBinder() throws Exception {
        this.assertThatInjectorIsWiped(Guice.createInjector((Module[])new Module[]{new Module3()}));
    }

    @Test
    public void multipleNestedBinders() throws Exception {
        this.assertThatInjectorIsWiped(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{Modules.override((Module[])new Module[]{new Module3()}).with(new Module[]{new AbstractModule(this){

            @Provides
            @Named(value="2")
            String provideFoo2() {
                return "foo2.1";
            }
        }})}).with(new Module[]{new AbstractModule(this){

            @Provides
            @Named(value="1")
            String provideFoo() {
                return "foo1.1";
            }
        }})}));
    }

    void assertThatInjectorIsWiped(Injector injector) {
        for (Element element : injector.getElements()) {
            Object source = element.getSource();
            if (!(source instanceof ElementSource)) continue;
            this.assertThatTheElementSourceChainIsWiped((ElementSource)source);
        }
    }

    void assertThatTheElementSourceChainIsWiped(ElementSource elementSource) {
        while (elementSource != null) {
            Truth.assertThat((Boolean)BindingSourceRestriction.PermitMapConstruction.isElementSourceCleared((ElementSource)elementSource)).isTrue();
            elementSource = elementSource.getOriginalElementSource();
        }
    }

    @Permit3
    static class Module3
    extends AbstractModule {
        Module3() {
        }

        protected void configure() {
            this.install((Module)new Module2());
        }
    }

    @Permit2
    static class Module2
    extends AbstractModule {
        Module2() {
        }

        @Provides
        @Named(value="2")
        String provideFoo2() {
            return "foo2";
        }

        protected void configure() {
            this.install((Module)new Module1());
        }
    }

    @Permit1
    static class Module1
    extends AbstractModule {
        Module1() {
        }

        @Provides
        @Named(value="1")
        String provideFoo() {
            return "foo";
        }
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Permit3 {
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Permit2 {
    }

    @RestrictedBindingSource.Permit
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Permit1 {
    }
}

