/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.ModuleSource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import junit.framework.TestCase;

public class ElementSourceTest
extends TestCase {
    private static final StackTraceElement BINDER_INSTALL = new StackTraceElement("com.google.inject.spi.Elements$RecordingBinder", "install", "Unknown Source", 234);

    public void testGetCallStack_IntegrationTest() throws Exception {
        List elements = Elements.getElements((Module[])new Module[]{new A()});
        for (Element element : elements) {
            Binding binding;
            Class annotationType;
            if (!(element instanceof Binding) || (annotationType = (binding = (Binding)element).getKey().getAnnotationType()) == null || !annotationType.equals(SampleAnnotation.class)) continue;
            ElementSource elementSource = (ElementSource)binding.getSource();
            List moduleClassNames = elementSource.getModuleClassNames();
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$C", (String)((String)moduleClassNames.get(0)));
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$B", (String)((String)moduleClassNames.get(1)));
            ElementSourceTest.assertEquals((String)"com.google.inject.spi.ElementSourceTest$A", (String)((String)moduleClassNames.get(2)));
            return;
        }
        ElementSourceTest.fail((String)"The test should not reach this line.");
    }

    private ModuleSource createModuleSource() {
        ModuleSource moduleSource = new ModuleSource(A.class, null);
        moduleSource = moduleSource.createChild(B.class);
        return moduleSource.createChild(C.class);
    }

    private static class C
    extends AbstractModule {
        private C() {
        }

        public void configure() {
            this.bind(String.class).annotatedWith(SampleAnnotation.class).toInstance((Object)"the value");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    static @interface SampleAnnotation {
    }

    private static class B
    implements Module {
        private B() {
        }

        public void configure(Binder binder) {
            binder.install((Module)new C());
        }
    }

    private static class A
    extends AbstractModule {
        private A() {
        }

        public void configure() {
            this.install(new B());
        }
    }
}

