/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.ConstantBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.FailingBindingScopingVisitor;
import com.google.inject.spi.FailingElementVisitor;
import com.google.inject.spi.FailingTargetVisitor;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.spi.TypeListenerBinding;
import com.google.inject.spi.UntargettedBinding;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ElementsTest
extends TestCase {
    public void testAddMessageErrorCommand() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.addError("Message %s %d %s", new Object[]{"A", 5, "C"});
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Message A 5 C", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSources().toString(), ElementsTest.class.getName(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testAddThrowableErrorCommand() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.addError(new Exception("A"));
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"A", (String)command.getCause().getMessage());
                TestCase.assertEquals((String)"An exception was caught and reported. Message: A", (String)command.getMessage());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testErrorsAddedWhenExceptionsAreThrown() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.install((Module)new AbstractModule(this){

                    protected void configure() {
                        throw new RuntimeException("Throwing RuntimeException in AbstractModule.configure().");
                    }
                });
                this.addError("Code after the exception still gets executed", new Object[0]);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Throwing RuntimeException in AbstractModule.configure().", (String)command.getCause().getMessage());
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Code after the exception still gets executed", (String)command.getMessage());
                return null;
            }
        }});
    }

    private <T> T getInstance(Binding<T> binding) {
        return (T)binding.acceptTargetVisitor(Elements.getInstanceVisitor());
    }

    public void testBindConstantAnnotations() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith(SampleAnnotation.class).to("A");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"Bee")).to("B");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(String.class, SampleAnnotation.class), (Object)command.getKey());
                TestCase.assertEquals((Object)"A", (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"Bee")), (Object)command.getKey());
                TestCase.assertEquals((Object)"B", (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }});
    }

    public void testBindConstantTypes() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"String")).to("A");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"int")).to(2);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"long")).to(3L);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"boolean")).to(false);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"double")).to(5.0);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"float")).to(6.0f);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"short")).to((short)7);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"char")).to('h');
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"byte")).to((byte)8);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"Class")).to(Iterator.class);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"Enum")).to((Enum)CoinSide.TAILS);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"String")), (Object)command.getKey());
                TestCase.assertEquals((Object)"A", (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Integer.class, (Annotation)Names.named((String)"int")), (Object)command.getKey());
                TestCase.assertEquals((Object)2, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Long.class, (Annotation)Names.named((String)"long")), (Object)command.getKey());
                TestCase.assertEquals((Object)3L, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Boolean.class, (Annotation)Names.named((String)"boolean")), (Object)command.getKey());
                TestCase.assertEquals((Object)false, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Double.class, (Annotation)Names.named((String)"double")), (Object)command.getKey());
                TestCase.assertEquals((Object)5.0, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Float.class, (Annotation)Names.named((String)"float")), (Object)command.getKey());
                TestCase.assertEquals((Object)Float.valueOf(6.0f), (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Short.class, (Annotation)Names.named((String)"short")), (Object)command.getKey());
                TestCase.assertEquals((Object)7, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Character.class, (Annotation)Names.named((String)"char")), (Object)command.getKey());
                TestCase.assertEquals((Object)Character.valueOf('h'), (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Byte.class, (Annotation)Names.named((String)"byte")), (Object)command.getKey());
                TestCase.assertEquals((Object)8, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(Class.class, (Annotation)Names.named((String)"Class")), (Object)command.getKey());
                TestCase.assertEquals(Iterator.class, (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }, new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(CoinSide.class, (Annotation)Names.named((String)"Enum")), (Object)command.getKey());
                TestCase.assertEquals((Object)((Object)CoinSide.TAILS), (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }});
    }

    public void testBindKeysNoAnnotations() {
        FailingElementVisitor keyChecker = new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)command.getKey());
                return null;
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
                this.bind((TypeLiteral)new TypeLiteral<String>(this){}).toInstance((Object)"B");
                this.bind(Key.get(String.class)).toInstance((Object)"C");
            }
        }, new ElementVisitor[]{keyChecker, keyChecker, keyChecker});
    }

    public void testBindKeysWithAnnotationType() {
        FailingElementVisitor annotationChecker = new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, SampleAnnotation.class), (Object)command.getKey());
                return null;
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).annotatedWith(SampleAnnotation.class).toInstance((Object)"A");
                this.bind((TypeLiteral)new TypeLiteral<String>(this){}).annotatedWith(SampleAnnotation.class).toInstance((Object)"B");
            }
        }, new ElementVisitor[]{annotationChecker, annotationChecker});
    }

    public void testBindKeysWithAnnotationInstance() {
        FailingElementVisitor annotationChecker = new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, (Annotation)Names.named((String)"a")), (Object)command.getKey());
                return null;
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"B");
                this.bind((TypeLiteral)new TypeLiteral<String>(this){}).annotatedWith((Annotation)Names.named((String)"a")).toInstance((Object)"C");
            }
        }, new ElementVisitor[]{annotationChecker, annotationChecker});
    }

    public void testBindToProvider() {
        Provider<String> aProvider = new Provider<String>(this){

            public String get() {
                return "A";
            }
        };
        jakarta.inject.Provider<Integer> intSpecProvider = new jakarta.inject.Provider<Integer>(this){

            public Integer get() {
                return 42;
            }
        };
        jakarta.inject.Provider<Double> doubleSpecProvider = new jakarta.inject.Provider<Double>(this){
            @jakarta.inject.Inject
            String string;

            public Double get() {
                return 42.42;
            }
        };
        this.checkModule((Module)new AbstractModule(this, (Provider)aProvider, (jakarta.inject.Provider)intSpecProvider, (jakarta.inject.Provider)doubleSpecProvider){
            final /* synthetic */ Provider val$aProvider;
            final /* synthetic */ jakarta.inject.Provider val$intSpecProvider;
            final /* synthetic */ jakarta.inject.Provider val$doubleSpecProvider;
            {
                this.val$aProvider = provider;
                this.val$intSpecProvider = provider2;
                this.val$doubleSpecProvider = provider3;
            }

            protected void configure() {
                this.bind(String.class).toProvider(this.val$aProvider);
                this.bind(Integer.class).toProvider(this.val$intSpecProvider);
                this.bind(Double.class).toProvider(this.val$doubleSpecProvider);
                this.bind(List.class).toProvider(ListProvider.class);
                this.bind(Collection.class).toProvider(Key.get(ListProvider.class));
                this.bind(Iterable.class).toProvider((TypeLiteral)new TypeLiteral<TProvider<List<Object>>>(this){});
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this, (Provider)aProvider){
            final /* synthetic */ Provider val$aProvider;
            {
                this.val$aProvider = provider;
            }

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderInstanceBinding));
                TestCase.assertEquals((Object)Key.get(String.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ProviderInstanceBinding<? extends T> binding) {
                        TestCase.assertSame((Object)val$aProvider, (Object)binding.getUserSuppliedProvider());
                        TestCase.assertSame((Object)val$aProvider, (Object)binding.getProviderInstance());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this, (jakarta.inject.Provider)intSpecProvider){
            final /* synthetic */ jakarta.inject.Provider val$intSpecProvider;
            {
                this.val$intSpecProvider = provider;
            }

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderInstanceBinding));
                TestCase.assertEquals((Object)Key.get(Integer.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ProviderInstanceBinding<? extends T> binding) {
                        TestCase.assertSame((Object)val$intSpecProvider, (Object)binding.getUserSuppliedProvider());
                        TestCase.assertEquals((Object)42, (Object)binding.getProviderInstance().get());
                        TestCase.assertFalse((boolean)(binding.getProviderInstance() instanceof HasDependencies));
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this, (jakarta.inject.Provider)doubleSpecProvider){
            final /* synthetic */ jakarta.inject.Provider val$doubleSpecProvider;
            {
                this.val$doubleSpecProvider = provider;
            }

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderInstanceBinding));
                TestCase.assertEquals((Object)Key.get(Double.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ProviderInstanceBinding<? extends T> binding) {
                        TestCase.assertSame((Object)val$doubleSpecProvider, (Object)binding.getUserSuppliedProvider());
                        TestCase.assertEquals((Object)42.42, (Object)binding.getProviderInstance().get());
                        TestCase.assertTrue((boolean)(binding.getProviderInstance() instanceof HasDependencies));
                        Set deps = ((HasDependencies)binding.getProviderInstance()).getDependencies();
                        TestCase.assertEquals((int)1, (int)deps.size());
                        TestCase.assertEquals(String.class, (Object)((Dependency)deps.iterator().next()).getKey().getTypeLiteral().getRawType());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderKeyBinding));
                TestCase.assertEquals((Object)Key.get(List.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(ProviderKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get(ListProvider.class), (Object)binding.getProviderKey());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderKeyBinding));
                TestCase.assertEquals((Object)Key.get(Collection.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(ProviderKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get(ListProvider.class), (Object)binding.getProviderKey());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof ProviderKeyBinding));
                TestCase.assertEquals((Object)Key.get(Iterable.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(ProviderKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)new Key<TProvider<List<Object>>>(this){}, (Object)binding.getProviderKey());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testBindToLinkedBinding() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(List.class).to(ArrayList.class);
                this.bind(Map.class).to((TypeLiteral)new TypeLiteral<HashMap<Integer, String>>(this){});
                this.bind(Set.class).to(Key.get(TreeSet.class, SampleAnnotation.class));
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof LinkedKeyBinding));
                TestCase.assertEquals((Object)Key.get(List.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(LinkedKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get(ArrayList.class), (Object)binding.getLinkedKey());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof LinkedKeyBinding));
                TestCase.assertEquals((Object)Key.get(Map.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(LinkedKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get((TypeLiteral)new TypeLiteral<HashMap<Integer, String>>(this){}), (Object)binding.getLinkedKey());
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof LinkedKeyBinding));
                TestCase.assertEquals((Object)Key.get(Set.class), (Object)command.getKey());
                command.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(this){

                    public Void visit(LinkedKeyBinding<? extends T> binding) {
                        TestCase.assertEquals((Object)Key.get(TreeSet.class, SampleAnnotation.class), (Object)binding.getLinkedKey());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testBindToInstance() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertTrue((boolean)(command instanceof InstanceBinding));
                TestCase.assertEquals((Object)Key.get(String.class), (Object)command.getKey());
                TestCase.assertEquals((Object)"A", (Object)ElementsTest.this.getInstance(command));
                return null;
            }
        }});
    }

    public void testBindInScopes() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class);
                this.bind(List.class).to(ArrayList.class).in(Scopes.SINGLETON);
                this.bind(Map.class).to(HashMap.class).in(Singleton.class);
                this.bind(Set.class).to(TreeSet.class).asEagerSingleton();
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitNoScoping() {
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(List.class), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitScope(Scope scope) {
                        TestCase.assertEquals((Object)Scopes.SINGLETON, (Object)scope);
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(Map.class), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitScopeAnnotation(Class<? extends Annotation> annotation) {
                        TestCase.assertEquals(Singleton.class, annotation);
                        return null;
                    }
                });
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                TestCase.assertEquals((Object)Key.get(Set.class), (Object)command.getKey());
                command.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitEagerSingleton() {
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testBindToInstanceInScope() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                AnnotatedBindingBuilder b = this.bind(String.class);
                b.toInstance((Object)"A");
                b.in(Singleton.class);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Setting the scope is not permitted when binding to a single instance.", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindToInstanceScope() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)binding.getKey());
                binding.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitEagerSingleton() {
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testBindIntercepor() {
        final Matcher classMatcher = Matchers.subclassesOf(List.class);
        final Matcher methodMatcher = Matchers.any();
        final MethodInterceptor methodInterceptor = new MethodInterceptor(this){

            public Object invoke(MethodInvocation methodInvocation) {
                return null;
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bindInterceptor(classMatcher, methodMatcher, new MethodInterceptor[]{methodInterceptor});
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(InterceptorBinding command) {
                TestCase.assertSame((Object)classMatcher, (Object)command.getClassMatcher());
                TestCase.assertSame((Object)methodMatcher, (Object)command.getMethodMatcher());
                TestCase.assertEquals(Arrays.asList(methodInterceptor), (Object)command.getInterceptors());
                return null;
            }
        }});
    }

    public void testBindScope() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bindScope(SampleAnnotation.class, Scopes.NO_SCOPE);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(ScopeBinding command) {
                TestCase.assertSame(SampleAnnotation.class, (Object)command.getAnnotationType());
                TestCase.assertSame((Object)Scopes.NO_SCOPE, (Object)command.getScope());
                return null;
            }
        }});
    }

    public void testBindListener() {
        final Matcher typeMatcher = Matchers.only((Object)TypeLiteral.get(String.class));
        final TypeListener listener = new TypeListener(this){

            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                throw new UnsupportedOperationException();
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bindListener(typeMatcher, listener);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(TypeListenerBinding binding) {
                TestCase.assertSame((Object)typeMatcher, (Object)binding.getTypeMatcher());
                TestCase.assertSame((Object)listener, (Object)binding.getListener());
                return null;
            }
        }});
    }

    public void testConvertToTypes() {
        final TypeConverter typeConverter = new TypeConverter(this){

            public Object convert(String value, TypeLiteral<?> toType) {
                return value;
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.convertToTypes(Matchers.any(), typeConverter);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(TypeConverterBinding command) {
                TestCase.assertSame((Object)typeConverter, (Object)command.getTypeConverter());
                TestCase.assertSame((Object)Matchers.any(), (Object)command.getTypeMatcher());
                return null;
            }
        }});
    }

    public void testGetProvider() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                Provider keyGetProvider = this.getProvider(Key.get(String.class, SampleAnnotation.class));
                try {
                    keyGetProvider.get();
                    TestCase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException e) {
                    TestCase.assertEquals((String)"This Provider cannot be used until the Injector has been created.", (String)e.getMessage());
                }
                Provider typeGetProvider = this.getProvider(String.class);
                try {
                    typeGetProvider.get();
                    TestCase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException e) {
                    TestCase.assertEquals((String)"This Provider cannot be used until the Injector has been created.", (String)e.getMessage());
                }
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(ProviderLookup<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class, SampleAnnotation.class), (Object)command.getKey());
                TestCase.assertNull((Object)command.getDelegate());
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(ProviderLookup<T> command) {
                TestCase.assertEquals((Object)Key.get(String.class), (Object)command.getKey());
                TestCase.assertNull((Object)command.getDelegate());
                return null;
            }
        }});
    }

    public void testElementInitialization() {
        final AtomicReference providerFromBinder = new AtomicReference();
        final AtomicReference membersInjectorFromBinder = new AtomicReference();
        final AtomicReference lastInjected = new AtomicReference();
        MembersInjector<String> stringInjector = new MembersInjector<String>(this){

            public void injectMembers(String instance) {
                lastInjected.set(instance);
            }
        };
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                providerFromBinder.set(this.getProvider(String.class));
                membersInjectorFromBinder.set(this.getMembersInjector(String.class));
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(ProviderLookup<T> providerLookup) {
                ProviderLookup<T> stringLookup = providerLookup;
                stringLookup.initializeDelegate(Providers.of((Object)"out"));
                TestCase.assertEquals((String)"out", (String)((String)((Provider)providerFromBinder.get()).get()));
                return null;
            }
        }, new FailingElementVisitor(this, (MembersInjector)stringInjector, membersInjectorFromBinder, lastInjected){
            final /* synthetic */ MembersInjector val$stringInjector;
            final /* synthetic */ AtomicReference val$membersInjectorFromBinder;
            final /* synthetic */ AtomicReference val$lastInjected;
            {
                this.val$stringInjector = membersInjector;
                this.val$membersInjectorFromBinder = atomicReference;
                this.val$lastInjected = atomicReference2;
            }

            public <T> Void visit(MembersInjectorLookup<T> lookup) {
                MembersInjectorLookup<T> stringLookup = lookup;
                stringLookup.initializeDelegate(this.val$stringInjector);
                ((MembersInjector)this.val$membersInjectorFromBinder.get()).injectMembers((Object)"in");
                TestCase.assertEquals((String)"in", (String)((String)this.val$lastInjected.get()));
                return null;
            }
        }});
    }

    public void testGetMembersInjector() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                MembersInjector typeMembersInjector = this.getMembersInjector((TypeLiteral)new TypeLiteral<A<String>>(this){});
                try {
                    typeMembersInjector.injectMembers(new A());
                    TestCase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException e) {
                    TestCase.assertEquals((String)"This MembersInjector cannot be used until the Injector has been created.", (String)e.getMessage());
                }
                MembersInjector classMembersInjector = this.getMembersInjector(String.class);
                try {
                    classMembersInjector.injectMembers((Object)"hello");
                    TestCase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException e) {
                    TestCase.assertEquals((String)"This MembersInjector cannot be used until the Injector has been created.", (String)e.getMessage());
                }
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(MembersInjectorLookup<T> command) {
                TestCase.assertEquals((Object)new TypeLiteral<A<String>>(this){}, (Object)command.getType());
                TestCase.assertNull((Object)command.getDelegate());
                return null;
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(MembersInjectorLookup<T> command) {
                TestCase.assertEquals((Object)TypeLiteral.get(String.class), (Object)command.getType());
                TestCase.assertNull((Object)command.getDelegate());
                return null;
            }
        }});
    }

    public void testRequestInjection() {
        final Object firstObject = new Object();
        final Object secondObject = new Object();
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.requestInjection(firstObject);
                this.requestInjection(secondObject);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(InjectionRequest<?> command) {
                TestCase.assertEquals((Object)firstObject, (Object)command.getInstance());
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(InjectionRequest<?> command) {
                TestCase.assertEquals((Object)secondObject, (Object)command.getInstance());
                return null;
            }
        }});
    }

    public void testRequestStaticInjection() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.requestStaticInjection(new Class[]{ArrayList.class});
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public Void visit(StaticInjectionRequest command) {
                TestCase.assertEquals(ArrayList.class, (Object)command.getType());
                return null;
            }
        }});
    }

    public void testNewPrivateBinder() {
        Key<Collection<Object>> collection = new Key<Collection<Object>>(this, SampleAnnotation.class){};
        Key<ArrayList<Object>> arrayList = new Key<ArrayList<Object>>(this){};
        final ImmutableSet collections = ImmutableSet.of((Object)arrayList, (Object)collection);
        Key a = Key.get(String.class, (Annotation)Names.named((String)"a"));
        Key b = Key.get(String.class, (Annotation)Names.named((String)"b"));
        final ImmutableSet ab = ImmutableSet.of((Object)a, (Object)b);
        this.checkModule((Module)new AbstractModule(this, (Key)arrayList, (Key)collection, b){
            final /* synthetic */ Key val$arrayList;
            final /* synthetic */ Key val$collection;
            final /* synthetic */ Key val$b;
            {
                this.val$arrayList = key;
                this.val$collection = key2;
                this.val$b = key3;
            }

            protected void configure() {
                PrivateBinder one = this.binder().newPrivateBinder();
                one.expose(this.val$arrayList);
                one.expose(this.val$collection);
                one.bind((Key)new Key<List<Object>>(this){}).to(this.val$arrayList);
                PrivateBinder two = this.binder().withSource((Object)"1 FooBar").newPrivateBinder().withSource((Object)"2 FooBar");
                two.expose(String.class).annotatedWith((Annotation)Names.named((String)"a"));
                two.expose(this.val$b);
                two.bind((Key)new Key<List<Object>>(this){}).to(this.val$arrayList);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(){

            public Void visit(PrivateElements one) {
                TestCase.assertEquals((Object)collections, (Object)one.getExposedKeys());
                ElementsTest.this.checkElements(one.getElements(), new ElementVisitor[]{new FailingElementVisitor(this){

                    public <T> Void visit(Binding<T> binding) {
                        TestCase.assertEquals((Object)new Key<List<Object>>(this){}, (Object)binding.getKey());
                        return null;
                    }
                }});
                return null;
            }
        }, new ExternalFailureVisitor(){

            public Void visit(PrivateElements two) {
                TestCase.assertEquals((Object)ab, (Object)two.getExposedKeys());
                TestCase.assertEquals((String)"1 FooBar", (String)two.getSource().toString());
                ElementsTest.this.checkElements(two.getElements(), new ElementVisitor[]{new ExternalFailureVisitor(this){

                    public <T> Void visit(Binding<T> binding) {
                        TestCase.assertEquals((String)"2 FooBar", (String)binding.getSource().toString());
                        TestCase.assertEquals((Object)new Key<List<Object>>(this){}, (Object)binding.getKey());
                        return null;
                    }
                }});
                return null;
            }
        }});
    }

    public void testBindWithMultipleAnnotationsAddsError() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                AnnotatedBindingBuilder abb = this.bind(String.class);
                abb.annotatedWith(SampleAnnotation.class);
                abb.annotatedWith((Annotation)Names.named((String)"A"));
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"More than one annotation is specified for this binding.", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindWithMultipleTargetsAddsError() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                AnnotatedBindingBuilder abb = this.bind(String.class);
                abb.toInstance((Object)"A");
                abb.toInstance((Object)"B");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Implementation is set more than once.", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindWithMultipleScopesAddsError() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                ScopedBindingBuilder sbb = this.bind(List.class).to(ArrayList.class);
                sbb.in(Scopes.NO_SCOPE);
                sbb.asEagerSingleton();
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"Scope is set more than once.", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindConstantWithMultipleAnnotationsAddsError() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                AnnotatedConstantBindingBuilder cbb = this.bindConstant();
                cbb.annotatedWith(SampleAnnotation.class).to("A");
                cbb.annotatedWith((Annotation)Names.named((String)"A"));
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message command) {
                TestCase.assertEquals((String)"More than one annotation is specified for this binding.", (String)command.getMessage());
                TestCase.assertNull((Object)command.getCause());
                Asserts.assertContains(command.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindConstantWithMultipleTargetsAddsError() {
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                ConstantBindingBuilder cbb = this.bindConstant().annotatedWith(SampleAnnotation.class);
                cbb.to("A");
                cbb.to("B");
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> command) {
                return null;
            }
        }, new FailingElementVisitor(this){

            public Void visit(Message message) {
                TestCase.assertEquals((String)"Constant value is set more than once.", (String)message.getMessage());
                TestCase.assertNull((Object)message.getCause());
                Asserts.assertContains(message.getSource(), Asserts.getDeclaringSourcePart(ElementsTest.class));
                return null;
            }
        }});
    }

    public void testBindToConstructor() throws NoSuchMethodException, NoSuchFieldException {
        final Constructor aConstructor = A.class.getDeclaredConstructor(new Class[0]);
        final Constructor bConstructor = B.class.getDeclaredConstructor(Object.class);
        final Field field = B.class.getDeclaredField("stage");
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(A.class).toConstructor(aConstructor);
                this.bind(B.class).toConstructor(bConstructor, (TypeLiteral)new TypeLiteral<B<Integer>>(this){}).in(Singleton.class);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertEquals((Object)new Key<A>(this){}, (Object)binding.getKey());
                return (Void)binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ConstructorBinding<? extends T> constructorBinding) {
                        InjectionPoint injectionPoint = constructorBinding.getConstructor();
                        TestCase.assertEquals((Object)aConstructor, (Object)injectionPoint.getMember());
                        TestCase.assertEquals((Object)new TypeLiteral<A>(this){}, (Object)injectionPoint.getDeclaringType());
                        return null;
                    }
                });
            }
        }, new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertEquals((Object)new Key<B>(this){}, (Object)binding.getKey());
                binding.acceptScopingVisitor((BindingScopingVisitor)new FailingBindingScopingVisitor(this){

                    @Override
                    public Void visitScopeAnnotation(Class<? extends Annotation> annotation) {
                        TestCase.assertEquals(Singleton.class, annotation);
                        return null;
                    }
                });
                binding.acceptTargetVisitor((BindingTargetVisitor)new FailingTargetVisitor<T>(){

                    public Void visit(ConstructorBinding<? extends T> constructorBinding) {
                        TestCase.assertEquals((Object)bConstructor, (Object)constructorBinding.getConstructor().getMember());
                        TestCase.assertEquals((Object)Key.get(Integer.class), (Object)((Dependency)Iterables.getOnlyElement((Iterable)constructorBinding.getConstructor().getDependencies())).getKey());
                        TestCase.assertEquals((Object)field, (Object)((InjectionPoint)Iterables.getOnlyElement((Iterable)constructorBinding.getInjectableMembers())).getMember());
                        TestCase.assertEquals((int)2, (int)constructorBinding.getDependencies().size());
                        TestCase.assertEquals((Object)ImmutableMap.of(), (Object)constructorBinding.getMethodInterceptors());
                        return null;
                    }
                });
                return null;
            }
        }});
    }

    public void testBindToMalformedConstructor() throws NoSuchMethodException, NoSuchFieldException {
        final Constructor constructor = C.class.getDeclaredConstructor(Integer.class);
        this.checkModule((Module)new AbstractModule(this){

            protected void configure() {
                this.bind(C.class).toConstructor(constructor);
            }
        }, new ElementVisitor[]{new FailingElementVisitor(this){

            public <T> Void visit(Binding<T> binding) {
                TestCase.assertEquals((Object)Key.get(C.class), (Object)binding.getKey());
                TestCase.assertTrue((boolean)(binding instanceof UntargettedBinding));
                return null;
            }
        }, new ExternalFailureVisitor(this){

            public Void visit(Message message) {
                Asserts.assertContains(message.getMessage(), C.class.getName() + ".a has more than one annotation ", Named.class.getName(), SampleAnnotation.class.getName());
                return null;
            }
        }, new ExternalFailureVisitor(this){

            public Void visit(Message message) {
                Asserts.assertContains(message.getMessage(), C.class.getName() + ".<init>() has more than one annotation ", Named.class.getName(), SampleAnnotation.class.getName());
                return null;
            }
        }});
    }

    public void testModulesAreInstalledAtMostOnce() {
        final AtomicInteger aConfigureCount = new AtomicInteger(0);
        AbstractModule a = new AbstractModule(this){

            public void configure() {
                aConfigureCount.incrementAndGet();
            }
        };
        Elements.getElements((Module[])new Module[]{a, a});
        ElementsTest.assertEquals((int)1, (int)aConfigureCount.get());
        aConfigureCount.set(0);
        AbstractModule b = new AbstractModule(this, (Module)a){
            final /* synthetic */ Module val$a;
            {
                this.val$a = module;
            }

            protected void configure() {
                this.install(this.val$a);
                this.install(this.val$a);
            }
        };
        Elements.getElements((Module[])new Module[]{b});
        ElementsTest.assertEquals((int)1, (int)aConfigureCount.get());
    }

    protected void checkModule(Module module, ElementVisitor<?> ... visitors) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        ElementsTest.assertEquals((int)elements.size(), (int)visitors.length);
        this.checkElements(elements, visitors);
    }

    protected void checkElements(List<Element> elements, ElementVisitor<?> ... visitors) {
        for (int i = 0; i < visitors.length; ++i) {
            ElementVisitor<?> visitor = visitors[i];
            Element element = elements.get(i);
            if (!(element instanceof Message)) {
                ElementSource source = (ElementSource)element.getSource();
                ElementsTest.assertFalse((boolean)source.getModuleClassNames().isEmpty());
            }
            if (!(visitor instanceof ExternalFailureVisitor)) {
                Asserts.assertContains(element.getSource().toString(), Asserts.getDeclaringSourcePart(ElementsTest.class));
            }
            element.acceptVisitor(visitor);
        }
    }

    static class C {
        @Inject
        @Named(value="foo")
        @SampleAnnotation
        String a;

        C(@Named(value="bar") @SampleAnnotation Integer b) {
        }
    }

    static class B<T> {
        @Inject
        Stage stage;

        B(T t) {
        }
    }

    static class A<T> {
        @Inject
        Stage stage;

        A() {
        }
    }

    public static enum CoinSide {
        HEADS,
        TAILS;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface SampleAnnotation {
    }

    static abstract class ExternalFailureVisitor
    extends FailingElementVisitor {
        ExternalFailureVisitor() {
        }
    }

    private static class TProvider<T>
    implements Provider<T> {
        private TProvider() {
        }

        public T get() {
            return null;
        }
    }

    private static class ListProvider
    implements Provider<List<Object>> {
        private ListProvider() {
        }

        public List<Object> get() {
            return new ArrayList<Object>();
        }
    }
}

