/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverterBinding;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class InjectorSpiTest
extends TestCase {
    public void testExistingBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Foo.class);
                this.bind(Baz.class);
            }
        }});
        for (Map.Entry entry : injector.getAllBindings().entrySet()) {
            InjectorSpiTest.assertSame(entry.getValue(), (Object)injector.getExistingBinding((Key)entry.getKey()));
        }
        Binding binding = injector.getExistingBinding(Key.get(Foo.class));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Foo.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertTrue((boolean)injector.getAllBindings().containsKey(Key.get((TypeLiteral)new TypeLiteral<Provider<Foo>>(this){})));
        binding = injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Foo>>(this){}));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Provider.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertEquals(Foo.class, ((Provider)binding.getProvider().get()).get().getClass());
        binding = injector.getExistingBinding(Key.get(Baz.class));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Baz.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertFalse((boolean)injector.getAllBindings().containsKey(Key.get((TypeLiteral)new TypeLiteral<Provider<Baz>>(this){})));
        binding = injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Baz>>(this){}));
        InjectorSpiTest.assertNotNull((Object)binding);
        InjectorSpiTest.assertEquals(Provider.class, (Object)binding.getKey().getTypeLiteral().getRawType());
        InjectorSpiTest.assertEquals(Baz.class, ((Provider)binding.getProvider().get()).get().getClass());
        InjectorSpiTest.assertNull((Object)injector.getExistingBinding(Key.get(Bar.class)));
        InjectorSpiTest.assertNull((Object)injector.getExistingBinding(Key.get((TypeLiteral)new TypeLiteral<Provider<Bar>>(this){})));
    }

    private static void customMethod(Foo foo, Bar bar) {
    }

    public void testGetElements_standardItems() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){}});
        final ArrayList bindings = new ArrayList();
        final ArrayList typeConverters = new ArrayList();
        final ArrayList scopes = new ArrayList();
        for (Element element : injector.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){

                public <T> Void visit(Binding<T> binding) {
                    bindings.add(binding);
                    return null;
                }

                public Void visit(ScopeBinding scopeBinding) {
                    scopes.add(scopeBinding);
                    return null;
                }

                public Void visit(TypeConverterBinding typeConverterBinding) {
                    typeConverters.add(typeConverterBinding);
                    return null;
                }

                protected Void visitOther(Element element) {
                    throw new IllegalStateException("Unexpected element: " + element);
                }
            });
        }
        HashSet<Key> actualKeys = new HashSet<Key>();
        for (Binding binding : bindings) {
            actualKeys.add(binding.getKey());
        }
        Truth.assertThat(actualKeys).containsExactly(new Object[]{Key.get(Stage.class), Key.get(Injector.class), Key.get(Logger.class)});
        Truth.assertThat(scopes).hasSize(2);
        Truth.assertThat(typeConverters).hasSize(10);
    }

    public void testGetElements_providerLookups() {
        Method customMethod;
        try {
            customMethod = ((Object)((Object)this)).getClass().getDeclaredMethod("customMethod", Foo.class, Bar.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        InjectionPoint ip = InjectionPoint.forMethod((Method)customMethod, (TypeLiteral)TypeLiteral.get(((Object)((Object)this)).getClass()));
        final Dependency fooDep = ((Dependency)ip.getDependencies().get(0)).getParameterIndex() == 0 ? (Dependency)ip.getDependencies().get(0) : (Dependency)ip.getDependencies().get(1);
        final Dependency barDep = ((Dependency)ip.getDependencies().get(1)).getParameterIndex() == 1 ? (Dependency)ip.getDependencies().get(1) : (Dependency)ip.getDependencies().get(0);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Foo.class);
                this.bind(Baz.class);
                this.binder().getProvider(fooDep);
                this.binder().getProvider(barDep);
            }
        }});
        final ArrayList lookups = new ArrayList();
        for (Element element : injector.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){

                public <T> Void visit(ProviderLookup<T> providerLookup) {
                    lookups.add(providerLookup);
                    return null;
                }
            });
        }
        boolean foundFooLookup = false;
        boolean foundBarLookup = false;
        for (ProviderLookup lookup : lookups) {
            if (lookup.getKey().getTypeLiteral().getRawType().equals(Foo.class)) {
                foundFooLookup = true;
                Truth.assertThat((Object)lookup.getDependency()).isEqualTo((Object)fooDep);
                continue;
            }
            if (lookup.getKey().getTypeLiteral().getRawType().equals(Bar.class)) {
                foundBarLookup = true;
                Truth.assertThat((Object)lookup.getDependency()).isEqualTo((Object)barDep);
                continue;
            }
            InjectorSpiTest.fail((String)("Unexpected lookup: " + lookup));
        }
        InjectorSpiTest.assertTrue((boolean)foundFooLookup);
        InjectorSpiTest.assertTrue((boolean)foundBarLookup);
    }

    public void testGetElements_staticInjectionRequests() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"");
                this.bind(Number.class).toInstance((Object)1);
                this.requestStaticInjection(new Class[]{StaticallyInject.class});
            }
        }});
        final ArrayList requests = new ArrayList();
        for (Element element : injector.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){

                public Void visit(StaticInjectionRequest staticInjectionRequest) {
                    requests.add(staticInjectionRequest);
                    return null;
                }
            });
        }
        Truth.assertThat(requests).hasSize(1);
        Truth.assertThat((Class)((StaticInjectionRequest)requests.get(0)).getType()).isEqualTo(StaticallyInject.class);
        Truth.assertThat((Iterable)((StaticInjectionRequest)requests.get(0)).getInjectionPoints()).containsExactly(new Object[]{new InjectionPoint(TypeLiteral.get(SuperStatic.class), SuperStatic.class.getDeclaredField("staticNumber"), false), new InjectionPoint(TypeLiteral.get(StaticallyInject.class), StaticallyInject.class.getDeclaredField("staticString"), false)});
    }

    public void testGetElements_injectionRequest() throws Exception {
        Object foo = new Object(this){
            @Inject
            String string;
        };
        final AtomicReference<13> finalFoo = new AtomicReference<13>(foo);
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"");
                this.requestInjection(finalFoo.get());
            }
        }});
        finalFoo.set(null);
        final ArrayList requests = new ArrayList();
        for (Element element : injector.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){

                public Void visit(InjectionRequest<?> injectionRequests) {
                    requests.add(injectionRequests);
                    return null;
                }
            });
        }
        Truth.assertThat(requests).hasSize(1);
        Truth.assertThat((Object)((InjectionRequest)requests.get(0)).getType()).isEqualTo((Object)TypeLiteral.get(foo.getClass()));
        Truth.assertThat((Object)((InjectionRequest)requests.get(0)).getInstance()).isNull();
        Truth.assertThat((Iterable)((InjectionRequest)requests.get(0)).getInjectionPoints()).containsExactly(new Object[]{new InjectionPoint(TypeLiteral.get(foo.getClass()), foo.getClass().getDeclaredField("string"), false)});
        WeakReference<13> fooRef = new WeakReference<13>(foo);
        foo = null;
        Asserts.awaitClear(fooRef);
    }

    public void testGetElements_membersInjectorLookup() throws Exception {
        final Object foo = new Object(this){
            @Inject
            String string;
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"");
                this.getMembersInjector(foo.getClass());
            }
        }});
        final ArrayList lookups = new ArrayList();
        for (Element element : injector.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(this){

                public <T> Void visit(MembersInjectorLookup<T> lookup) {
                    lookups.add(lookup);
                    return null;
                }
            });
        }
        Truth.assertThat(lookups).hasSize(1);
        Truth.assertThat((Object)((MembersInjectorLookup)lookups.get(0)).getType()).isEqualTo((Object)TypeLiteral.get(foo.getClass()));
        Truth.assertThat((Iterable)((MembersInjectorLookup)lookups.get(0)).getInjectionPoints()).containsExactly(new Object[]{new InjectionPoint(TypeLiteral.get(foo.getClass()), foo.getClass().getDeclaredField("string"), false)});
    }

    public void testGetAllMembersInjectorInjectionPoints_injectMembers_returned() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)42);
                this.bind(String.class).toInstance((Object)"bar");
            }
        }});
        injector.injectMembers((Object)new ClassWithInjectableField("foo"));
        Map injectionPoints = injector.getAllMembersInjectorInjectionPoints();
        TypeLiteral expectedTypeLiteral = TypeLiteral.get(ClassWithInjectableField.class);
        Truth.assertThat(injectionPoints.keySet()).containsExactly(new Object[]{expectedTypeLiteral});
        Key actualDependencyKey = ((Dependency)Iterables.getOnlyElement((Iterable)((InjectionPoint)Iterables.getOnlyElement((Iterable)((Iterable)injectionPoints.get(expectedTypeLiteral)))).getDependencies())).getKey();
        InjectorSpiTest.assertEquals((Object)Key.get(Integer.class), (Object)actualDependencyKey);
    }

    public void testGetAllMembersInjectorInjectionPoints_getInstance() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)42);
                this.bind(String.class).toInstance((Object)"bar");
            }
        }});
        injector.getInstance(ClassWithInjectableField.class);
        Map injectionPoints = injector.getAllMembersInjectorInjectionPoints();
        Truth.assertThat((Map)injectionPoints).isEmpty();
    }

    public void testGetAllMembersInjectorInjectionPoints_getInstanceAndInjectMembers() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)42);
                this.bind(String.class).toInstance((Object)"bar");
            }
        }});
        injector.injectMembers((Object)new ClassWithInjectableField("foo"));
        injector.getInstance(ClassWithInjectableField.class);
        Map injectionPoints = injector.getAllMembersInjectorInjectionPoints();
        TypeLiteral expectedTypeLiteral = TypeLiteral.get(ClassWithInjectableField.class);
        Truth.assertThat(injectionPoints.keySet()).containsExactly(new Object[]{expectedTypeLiteral});
        Key actualDependencyKey = ((Dependency)Iterables.getOnlyElement((Iterable)((InjectionPoint)Iterables.getOnlyElement((Iterable)((Iterable)injectionPoints.get(expectedTypeLiteral)))).getDependencies())).getKey();
        InjectorSpiTest.assertEquals((Object)Key.get(Integer.class), (Object)actualDependencyKey);
    }

    private static class ClassWithInjectableField {
        @Inject
        private Integer instanceField;
        @Inject
        private static Double staticField;

        @Inject
        ClassWithInjectableField(String name) {
        }
    }

    private static class Baz {
        @Inject
        Provider<Foo> fooP;

        private Baz() {
        }
    }

    private static class Bar {
        private Bar() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }

    static class SuperStatic {
        @Inject
        static Number staticNumber;

        SuperStatic() {
        }
    }

    static class StaticallyInject
    extends SuperStatic {
        @Inject
        static String staticString;

        StaticallyInject() {
        }
    }
}

