/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import com.google.inject.util.Enhanced;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class EnhancedTest {
    @Test
    public void isEnhanced() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        Injector injector = Guice.createInjector((Module[])new Module[]{new InterceptingModule()});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Bar bar = (Bar)injector.getInstance(Bar.class);
        Truth.assertThat((String)foo.foo()).isEqualTo((Object)"intercepted-foo");
        Truth.assertThat((String)bar.bar()).isEqualTo((Object)"bar");
        Truth.assertThat((Boolean)Enhanced.isEnhanced(foo.getClass())).isTrue();
        Truth.assertThat((Boolean)Enhanced.isEnhanced(bar.getClass())).isFalse();
    }

    @Test
    public void unenhancedClass() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        Injector injector = Guice.createInjector((Module[])new Module[]{new InterceptingModule()});
        Foo foo = (Foo)injector.getInstance(Foo.class);
        Bar bar = (Bar)injector.getInstance(Bar.class);
        Truth.assertThat((String)foo.foo()).isEqualTo((Object)"intercepted-foo");
        Truth.assertThat((String)bar.bar()).isEqualTo((Object)"bar");
        Truth8.assertThat((Optional)Enhanced.unenhancedClass(foo.getClass())).isEqualTo(Optional.of(Foo.class));
        Truth8.assertThat((Optional)Enhanced.unenhancedClass(bar.getClass())).isEmpty();
    }

    public static class Bar {
        public String bar() {
            return "bar";
        }
    }

    public static class Foo {
        public String foo() {
            return "foo";
        }
    }

    private static class InterceptingModule
    extends AbstractModule {
        private InterceptingModule() {
        }

        protected void configure() {
            this.binder().bindInterceptor(Matchers.only(Foo.class), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                public Object invoke(MethodInvocation i) throws Throwable {
                    return "intercepted-" + i.proceed();
                }
            }});
            this.bind(Foo.class);
            this.bind(Bar.class);
        }
    }
}

