/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Exposed;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class OverrideModuleTest
extends TestCase {
    private static final Key<String> key2 = Key.get(String.class, (Annotation)Names.named((String)"2"));
    private static final Key<String> key3 = Key.get(String.class, (Annotation)Names.named((String)"3"));
    private static final Module EMPTY_MODULE = new Module(){

        public void configure(Binder binder) {
        }
    };
    private static final String RESULT = "RESULT";
    private static final String PRIVATE_INPUT = "PRIVATE_INPUT";
    private static final String OVERRIDDEN_INPUT = "FOO";
    private static final String OVERRIDDEN_RESULT = "Size: 3";
    private static final Key<String> RESULT_KEY = Key.get(String.class, (Annotation)Names.named((String)"RESULT"));
    private static final Key<String> INPUT_KEY = Key.get(String.class, (Annotation)Names.named((String)"PRIVATE_INPUT"));

    public void testOverride() {
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{OverrideModuleTest.newModule("A")}).with(new Module[]{OverrideModuleTest.newModule("B")})});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(String.class)));
    }

    public void testOverrideMultiple() {
        Module module = Modules.override((Module[])new Module[]{OverrideModuleTest.newModule("A"), OverrideModuleTest.newModule(1), OverrideModuleTest.newModule(Float.valueOf(0.5f))}).with(new Module[]{OverrideModuleTest.newModule("B"), OverrideModuleTest.newModule(2), OverrideModuleTest.newModule(1.5)});
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(String.class)));
        OverrideModuleTest.assertEquals((int)2, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((float)0.5f, (float)((Float)injector.getInstance(Float.class)).floatValue(), (float)0.0f);
        OverrideModuleTest.assertEquals((double)1.5, (double)((Double)injector.getInstance(Double.class)), (double)0.0);
    }

    public void testOverrideUnmatchedTolerated() {
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{EMPTY_MODULE}).with(new Module[]{OverrideModuleTest.newModule("B")})});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(String.class)));
    }

    public void testOverrideConstant() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"Test")).to("A");
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"Test")).to("B");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements})});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"Test")))));
    }

    public void testGetProviderInModule() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
                this.bind(key2).toProvider(this.getProvider(String.class));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{EMPTY_MODULE})});
        OverrideModuleTest.assertEquals((String)"A", (String)((String)injector.getInstance(String.class)));
        OverrideModuleTest.assertEquals((String)"A", (String)((String)injector.getInstance(key2)));
    }

    public void testOverrideWhatGetProviderProvided() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
                this.bind(key2).toProvider(this.getProvider(String.class));
            }
        };
        Module replacements = OverrideModuleTest.newModule("B");
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements})});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(String.class)));
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(key2)));
    }

    public void testOverrideUsingOriginalsGetProvider() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
                this.bind(key2).toInstance((Object)"B");
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toProvider(this.getProvider(key2));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements})});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(String.class)));
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(key2)));
    }

    public void testOverrideOfOverride() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A1");
                this.bind(key2).toInstance((Object)"A2");
                this.bind(key3).toInstance((Object)"A3");
            }
        };
        AbstractModule replacements1 = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"B1");
                this.bind(key2).toInstance((Object)"B2");
            }
        };
        Module overrides = Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements1});
        AbstractModule replacements2 = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"C1");
                this.bind(key3).toInstance((Object)"C3");
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{overrides}).with(new Module[]{replacements2})});
        OverrideModuleTest.assertEquals((String)"C1", (String)((String)injector.getInstance(String.class)));
        OverrideModuleTest.assertEquals((String)"B2", (String)((String)injector.getInstance(key2)));
        OverrideModuleTest.assertEquals((String)"C3", (String)((String)injector.getInstance(key3)));
    }

    public void testOverridesTwiceFails() {
        Module original = OverrideModuleTest.newModule("A");
        OuterReplacementsModule replacements = new OuterReplacementsModule();
        Module module = Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements});
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OverrideModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "String was bound multiple times.", "1  : OverrideModuleTest$InnerReplacementsModule.configure(", "Modules$OverrideModule -> OverrideModuleTest$OuterReplacementsModule -> OverrideModuleTest$InnerReplacementsModule", "2  : OverrideModuleTest$InnerReplacementsModule.configure(", "Modules$OverrideModule -> OverrideModuleTest$OuterReplacementsModule -> OverrideModuleTest$InnerReplacementsModule");
        }
    }

    public void testOverridesDoesntFixTwiceBoundInOriginal() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"A");
                this.bind(String.class).toInstance((Object)"B");
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toInstance((Object)"C");
            }
        };
        Module module = Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements});
        try {
            Guice.createInjector((Module[])new Module[]{module});
            OverrideModuleTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "String was bound multiple times.", "1  : OverrideModuleTest$12.configure(", "Modules$OverrideModule -> OverrideModuleTest$12", "2  : OverrideModuleTest$11.configure(", "Modules$OverrideModule -> OverrideModuleTest$11");
        }
    }

    public void testStandardScopeAnnotation() {
        final SingleUseScope scope = new SingleUseScope();
        AbstractModule module = new AbstractModule(this){

            protected void configure() {
                this.bindScope(TestScopeAnnotation.class, scope);
                this.bind(String.class).in(TestScopeAnnotation.class);
            }
        };
        OverrideModuleTest.assertFalse((boolean)scope.used);
        Guice.createInjector((Module[])new Module[]{module});
        OverrideModuleTest.assertTrue((boolean)scope.used);
    }

    public void testOverrideUntargettedBinding() {
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bind(Date.class);
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bind(Date.class).toInstance((Object)new Date(0L));
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements})});
        OverrideModuleTest.assertEquals((long)0L, (long)((Date)injector.getInstance(Date.class)).getTime());
    }

    public void testOverrideScopeAnnotation() {
        final Scope scope = new Scope(this){

            public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
                throw new AssertionError((Object)"Should not be called");
            }
        };
        final SingleUseScope replacementScope = new SingleUseScope();
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bindScope(TestScopeAnnotation.class, scope);
                this.bind(Date.class).in(TestScopeAnnotation.class);
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bindScope(TestScopeAnnotation.class, replacementScope);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{original}).with(new Module[]{replacements})});
        injector.getInstance(Date.class);
        OverrideModuleTest.assertTrue((boolean)replacementScope.used);
    }

    public void testFailsIfOverridenScopeInstanceHasBeenUsed() {
        final Scope scope = new Scope(this){

            public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
                return unscoped;
            }

            public String toString() {
                return "ORIGINAL SCOPE";
            }
        };
        AbstractModule original = new AbstractModule(this){

            protected void configure() {
                this.bindScope(TestScopeAnnotation.class, scope);
                this.bind(Date.class).in(scope);
                this.bind(String.class).in(scope);
            }
        };
        AbstractModule originalWrapper = new AbstractModule(this, (Module)original){
            final /* synthetic */ Module val$original;
            {
                this.val$original = module;
            }

            protected void configure() {
                this.install(this.val$original);
            }
        };
        AbstractModule replacements = new AbstractModule(this){

            protected void configure() {
                this.bindScope(TestScopeAnnotation.class, new SingleUseScope());
            }
        };
        try {
            Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{originalWrapper}).with(new Module[]{replacements})});
            OverrideModuleTest.fail((String)"Exception expected");
        }
        catch (CreationException e) {
            String className = original.getClass().getName().replace("com.google.inject.util.", "");
            String moduleChain = originalWrapper.getClass().getName().replace("com.google.inject.util.", "") + " -> " + className;
            Asserts.assertContains(e.getMessage(), "1) The scope for @TestScopeAnnotation is bound directly and cannot be overridden.", "original binding at " + className + ".configure(", moduleChain, "bound directly at " + className + ".configure(", moduleChain, "bound directly at " + className + ".configure(", moduleChain, "at OverrideModuleTest$22.configure", "Modules$OverrideModule -> OverrideModuleTest$22");
        }
    }

    public void testOverrideIsLazy() {
        final AtomicReference<String> value = new AtomicReference<String>("A");
        Module overridden = Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"original")).toInstance((Object)((String)value.get()));
            }
        }}).with(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"override")).toInstance((Object)((String)value.get()));
            }
        }});
        value.set("B");
        Injector injector = Guice.createInjector((Module[])new Module[]{overridden});
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"original")))));
        OverrideModuleTest.assertEquals((String)"B", (String)((String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"override")))));
    }

    public void testOverridePrivateModuleOverPrivateModule() {
        AbstractModule exposes5and6 = new AbstractModule(this){

            protected void configure() {
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Integer.class).toInstance((Object)5);
                        this.expose(Integer.class);
                        this.bind(Character.class).toInstance((Object)Character.valueOf('E'));
                    }
                });
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Long.class).toInstance((Object)6L);
                        this.expose(Long.class);
                        this.bind(Character.class).toInstance((Object)Character.valueOf('F'));
                    }
                });
            }
        };
        AbstractModule exposes15 = new AbstractModule(this){

            protected void configure() {
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Integer.class).toInstance((Object)15);
                        this.expose(Integer.class);
                        this.bind(Character.class).toInstance((Object)Character.valueOf('G'));
                    }
                });
                this.install((Module)new PrivateModule(this){

                    protected void configure() {
                        this.bind(Character.class).toInstance((Object)Character.valueOf('H'));
                    }
                });
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{exposes5and6}).with(new Module[]{exposes15})});
        OverrideModuleTest.assertEquals((int)15, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((long)6L, (long)((Long)injector.getInstance(Long.class)));
        Injector reverse = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{exposes15}).with(new Module[]{exposes5and6})});
        OverrideModuleTest.assertEquals((int)5, (int)((Integer)reverse.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((long)6L, (long)((Long)reverse.getInstance(Long.class)));
    }

    public void testOverrideModuleAndPrivateModule() {
        PrivateModule exposes5 = new PrivateModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)5);
                this.expose(Integer.class);
            }
        };
        AbstractModule binds15 = new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)15);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{exposes5}).with(new Module[]{binds15})});
        OverrideModuleTest.assertEquals((int)15, (int)((Integer)injector.getInstance(Integer.class)));
        Injector reverse = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{binds15}).with(new Module[]{exposes5})});
        OverrideModuleTest.assertEquals((int)5, (int)((Integer)reverse.getInstance(Integer.class)));
    }

    public void testOverrideDeepExpose() {
        final AtomicReference<Object> charAProvider = new AtomicReference<Object>();
        PrivateModule exposes5 = new PrivateModule(this){

            protected void configure() {
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        this.bind(Integer.class).toInstance((Object)5);
                        this.expose(Integer.class);
                        charAProvider.set(this.getProvider(Character.class));
                        this.bind(Character.class).toInstance((Object)Character.valueOf('A'));
                    }
                });
                this.expose(Integer.class);
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{exposes5}).with(new Module[]{EMPTY_MODULE})});
        OverrideModuleTest.assertEquals((int)5, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((char)'A', (char)((Character)((Provider)charAProvider.getAndSet(null)).get()).charValue());
        injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{EMPTY_MODULE}).with(new Module[]{exposes5})});
        OverrideModuleTest.assertEquals((int)5, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((char)'A', (char)((Character)((Provider)charAProvider.getAndSet(null)).get()).charValue());
        final AtomicReference<Object> charBProvider = new AtomicReference<Object>();
        AbstractModule binds15 = new AbstractModule(this){

            protected void configure() {
                this.bind(Integer.class).toInstance((Object)15);
                this.install((Module)new PrivateModule(){

                    protected void configure() {
                        charBProvider.set(this.getProvider(Character.class));
                        this.bind(Character.class).toInstance((Object)Character.valueOf('B'));
                    }
                });
            }
        };
        injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{binds15}).with(new Module[]{exposes5})});
        OverrideModuleTest.assertEquals((int)5, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((char)'A', (char)((Character)((Provider)charAProvider.getAndSet(null)).get()).charValue());
        OverrideModuleTest.assertEquals((char)'B', (char)((Character)((Provider)charBProvider.getAndSet(null)).get()).charValue());
        injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{exposes5}).with(new Module[]{binds15})});
        OverrideModuleTest.assertEquals((int)15, (int)((Integer)injector.getInstance(Integer.class)));
        OverrideModuleTest.assertEquals((char)'A', (char)((Character)((Provider)charAProvider.getAndSet(null)).get()).charValue());
        OverrideModuleTest.assertEquals((char)'B', (char)((Character)((Provider)charBProvider.getAndSet(null)).get()).charValue());
    }

    private static <T> Module newModule(T bound) {
        return new NewModule<T>(bound);
    }

    public void testExposedBindingOverride() throws Exception {
        Injector inj = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ExampleModule()}).with(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(RESULT_KEY).toInstance((Object)OverrideModuleTest.OVERRIDDEN_RESULT);
            }
        }})});
        OverrideModuleTest.assertEquals((String)OVERRIDDEN_RESULT, (String)((String)inj.getInstance(RESULT_KEY)));
    }

    public void testPrivateBindingOverride() throws Exception {
        Injector inj = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ExampleModule()}).with(new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(INPUT_KEY).toInstance((Object)OverrideModuleTest.OVERRIDDEN_INPUT);
            }
        }})});
        OverrideModuleTest.assertEquals((String)OVERRIDDEN_RESULT, (String)((String)inj.getInstance(RESULT_KEY)));
    }

    public void testEqualsNotCalledByDefaultOnInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnEquals = true;
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class);
                this.bind(HashEqualsTester.class).toInstance((Object)a);
            }
        }}).with()});
    }

    public void testEqualsNotCalledByDefaultOnProvider() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnEquals = true;
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class);
                this.bind(Object.class).toProvider((Provider)a);
            }
        }}).with()});
    }

    public void testHashcodeNeverCalledOnInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnHashcode = true;
        a.equality = "test";
        final HashEqualsTester b = new HashEqualsTester();
        b.throwOnHashcode = true;
        b.equality = "test";
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class);
                this.bind(HashEqualsTester.class).toInstance((Object)a);
                this.bind(HashEqualsTester.class).toInstance((Object)b);
            }
        }}).with()});
    }

    public void testHashcodeNeverCalledOnProviderInstance() {
        final HashEqualsTester a = new HashEqualsTester();
        a.throwOnHashcode = true;
        a.equality = "test";
        final HashEqualsTester b = new HashEqualsTester();
        b.throwOnHashcode = true;
        b.equality = "test";
        Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class);
                this.bind(Object.class).toProvider((Provider)a);
                this.bind(Object.class).toProvider((Provider)b);
            }
        }}).with()});
    }

    public void testCorrectStage() {
        Stage stage = Stage.PRODUCTION;
        Module module = Modules.override((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                if (this.currentStage() != Stage.PRODUCTION) {
                    this.addError("Wronge stage in overridden module:" + this.currentStage(), new Object[0]);
                }
            }
        }}).with(new Module[]{new AbstractModule(this){

            protected void configure() {
                if (this.currentStage() != Stage.PRODUCTION) {
                    this.addError("Wronge stage in overriding module:" + this.currentStage(), new Object[0]);
                }
            }
        }});
        Guice.createInjector((Stage)stage, (Module[])new Module[]{module});
    }

    public void testOverridesApplyOriginalScanners() {
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{NamedMunger.module()}).with(new Module[]{new AbstractModule(this){

            @TestProvides
            @Named(value="test")
            String provideString() {
                return "foo";
            }
        }})});
        OverrideModuleTest.assertNull((Object)injector.getExistingBinding(Key.get(String.class, (Annotation)Names.named((String)"test"))));
        Binding binding = injector.getBinding(Key.get(String.class, (Annotation)Names.named((String)"test-munged")));
        OverrideModuleTest.assertEquals((String)"foo", (String)((String)binding.getProvider().get()));
    }

    private static class NamedMunger
    extends ModuleAnnotatedMethodScanner {
        private NamedMunger() {
        }

        static Module module() {
            return new AbstractModule(){

                protected void configure() {
                    this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)new NamedMunger());
                }
            };
        }

        public String toString() {
            return "NamedMunger";
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(TestProvides.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key.withAnnotation((Annotation)Names.named((String)(((Named)key.getAnnotation()).value() + "-munged")));
        }
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestProvides {
    }

    private static class HashEqualsTester
    implements Provider<Object> {
        private String equality;
        private boolean throwOnEquals;
        private boolean throwOnHashcode;

        private HashEqualsTester() {
        }

        public boolean equals(Object obj) {
            if (this.throwOnEquals) {
                throw new RuntimeException();
            }
            if (obj instanceof HashEqualsTester) {
                HashEqualsTester o = (HashEqualsTester)obj;
                if (o.throwOnEquals) {
                    throw new RuntimeException();
                }
                if (this.equality == null && o.equality == null) {
                    return this == o;
                }
                return Objects.equal((Object)this.equality, (Object)o.equality);
            }
            return false;
        }

        public int hashCode() {
            if (this.throwOnHashcode) {
                throw new RuntimeException();
            }
            return super.hashCode();
        }

        public Object get() {
            return new Object();
        }
    }

    public static class ExampleModule
    extends PrivateModule {
        @Provides
        @Exposed
        @Named(value="RESULT")
        public String provideResult(@Named(value="PRIVATE_INPUT") String input) {
            return "Size: " + input.length();
        }

        @Provides
        @Named(value="PRIVATE_INPUT")
        public String provideInput() {
            return "Hello World";
        }

        protected void configure() {
        }
    }

    static class NewModule<T>
    extends AbstractModule {
        private final T bound;

        NewModule(T bound) {
            this.bound = bound;
        }

        protected void configure() {
            Class<?> type = this.bound.getClass();
            this.bind(type).toInstance(this.bound);
        }
    }

    private static class SingleUseScope
    implements Scope {
        boolean used = false;

        private SingleUseScope() {
        }

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            TestCase.assertFalse((boolean)this.used);
            this.used = true;
            return unscoped;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ScopeAnnotation
    private static @interface TestScopeAnnotation {
    }

    static class InnerReplacementsModule
    extends AbstractModule {
        InnerReplacementsModule() {
        }

        protected void configure() {
            this.bind(String.class).toInstance((Object)"B");
            this.bind(String.class).toInstance((Object)"C");
        }
    }

    static class OuterReplacementsModule
    extends AbstractModule {
        OuterReplacementsModule() {
        }

        protected void configure() {
            this.install((Module)new InnerReplacementsModule());
        }
    }
}

