/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.common.base.Objects;
import com.google.common.testing.EqualsTester;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import jakarta.inject.Inject;
import junit.framework.TestCase;

public class ProvidersTest
extends TestCase {
    public void testOfInstance() {
        String foo = "foo";
        Provider p = Providers.of((Object)foo);
        ProvidersTest.assertSame((Object)foo, (Object)p.get());
        ProvidersTest.assertSame((Object)foo, (Object)p.get());
    }

    public void testOfNull() {
        Provider p = Providers.of(null);
        ProvidersTest.assertNull((Object)p.get());
    }

    public void testOfEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{Providers.of(null), Providers.of(null)}).addEqualityGroup(new Object[]{Providers.of((Object)"Hello"), Providers.of((Object)"Hello")}).testEquals();
    }

    public void testGuicifyEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{Providers.guicify((jakarta.inject.Provider)new JakartaProvider(10)), Providers.guicify((jakarta.inject.Provider)new JakartaProvider(10))}).addEqualityGroup(new Object[]{Providers.guicify((jakarta.inject.Provider)new JakartaProvider(11)), Providers.guicify((jakarta.inject.Provider)new JakartaProvider(11))}).addEqualityGroup(new Object[]{Providers.guicify((jakarta.inject.Provider)new JakartaProviderWithDependencies()), Providers.guicify((jakarta.inject.Provider)new JakartaProviderWithDependencies())}).testEquals();
    }

    private static class JakartaProviderWithDependencies
    implements jakarta.inject.Provider<Integer> {
        private int value;

        private JakartaProviderWithDependencies() {
        }

        @Inject
        void setValue(int value) {
            this.value = value;
        }

        public Integer get() {
            return this.value;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof JakartaProviderWithDependencies;
        }
    }

    private static class JakartaProvider
    implements jakarta.inject.Provider<Integer> {
        private final int value;

        public JakartaProvider(int value) {
            this.value = value;
        }

        public Integer get() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        public boolean equals(Object obj) {
            return obj instanceof JakartaProvider && this.value == ((JakartaProvider)obj).value;
        }
    }
}

