/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.inject.Asserts;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.util.Types;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TypesTest
extends TestCase {
    Map<String, Integer> a;
    Inner<Float, Double> b;
    List<Set<String>[][]> c;
    List<String> d;
    Set<String> e;
    Outer.Inner f;
    private ParameterizedType mapStringInteger;
    private ParameterizedType innerFloatDouble;
    private ParameterizedType listSetStringArray;
    private ParameterizedType listString;
    private ParameterizedType setString;
    private ParameterizedType outerInner;
    private GenericArrayType setStringArray;
    public List<? extends CharSequence> wildcardExtends;
    public List<? super CharSequence> wildcardSuper;
    public List<?> wildcardObject;

    protected void setUp() throws Exception {
        super.setUp();
        this.mapStringInteger = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("a").getGenericType();
        this.innerFloatDouble = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("b").getGenericType();
        this.listSetStringArray = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("c").getGenericType();
        this.listString = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("d").getGenericType();
        this.setString = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("e").getGenericType();
        this.outerInner = (ParameterizedType)((Object)((Object)this)).getClass().getDeclaredField("f").getGenericType();
        this.setStringArray = (GenericArrayType)this.listSetStringArray.getActualTypeArguments()[0];
    }

    public void testListSetMap() {
        Asserts.assertEqualsBothWays(this.mapStringInteger, Types.mapOf(String.class, Integer.class));
        Asserts.assertEqualsBothWays(this.listString, Types.listOf(String.class));
        Asserts.assertEqualsBothWays(this.setString, Types.setOf(String.class));
    }

    public void testDefensiveCopies() {
        Type[] arguments = new Type[]{String.class, Integer.class};
        ParameterizedType parameterizedType = Types.newParameterizedType(Map.class, (Type[])arguments);
        arguments[0] = null;
        TypesTest.assertEquals(String.class, (Object)parameterizedType.getActualTypeArguments()[0]);
        parameterizedType.getActualTypeArguments()[1] = null;
        TypesTest.assertEquals(Integer.class, (Object)parameterizedType.getActualTypeArguments()[1]);
    }

    public void testTypeWithOwnerType() {
        ParameterizedType actual = Types.newParameterizedTypeWithOwner(TypesTest.class, Inner.class, (Type[])new Type[]{Float.class, Double.class});
        TypesTest.assertEquals(TypesTest.class, (Object)actual.getOwnerType());
        Asserts.assertEqualsBothWays(this.innerFloatDouble, actual);
        TypesTest.assertEquals((String)"com.google.inject.util.TypesTest$Inner<java.lang.Float, java.lang.Double>", (String)actual.toString());
    }

    public void testTypeParametersMustNotBePrimitives() {
        try {
            Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Integer.TYPE});
            TypesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Primitive types are not allowed in type parameters: int");
        }
    }

    public void testWildcardTypes() throws NoSuchFieldException, IOException {
        Asserts.assertEqualsBothWays(this.getWildcard("wildcardSuper"), Types.supertypeOf(CharSequence.class));
        Asserts.assertEqualsBothWays(this.getWildcard("wildcardExtends"), Types.subtypeOf(CharSequence.class));
        Asserts.assertEqualsBothWays(this.getWildcard("wildcardObject"), Types.subtypeOf(Object.class));
        TypesTest.assertEquals((String)"? super java.lang.CharSequence", (String)Types.supertypeOf(CharSequence.class).toString());
        TypesTest.assertEquals((String)"? extends java.lang.CharSequence", (String)Types.subtypeOf(CharSequence.class).toString());
        TypesTest.assertEquals((String)"?", (String)Types.subtypeOf(Object.class).toString());
        Asserts.assertEqualWhenReserialized(Types.supertypeOf(CharSequence.class));
        Asserts.assertEqualWhenReserialized(Types.subtypeOf(CharSequence.class));
    }

    public void testWildcardBoundsMustNotBePrimitives() {
        try {
            Types.supertypeOf(Integer.TYPE);
            TypesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Primitive types are not allowed in wildcard bounds: int");
        }
        try {
            Types.subtypeOf(Integer.TYPE);
            TypesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Primitive types are not allowed in wildcard bounds: int");
        }
    }

    private WildcardType getWildcard(String fieldName) throws NoSuchFieldException {
        ParameterizedType type = (ParameterizedType)((Object)((Object)this)).getClass().getField(fieldName).getGenericType();
        return (WildcardType)type.getActualTypeArguments()[0];
    }

    public void testEqualsAndHashcode() {
        ParameterizedType parameterizedType = Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Integer.class});
        Asserts.assertEqualsBothWays(this.mapStringInteger, parameterizedType);
        TypesTest.assertEquals((String)this.mapStringInteger.toString(), (String)parameterizedType.toString());
        GenericArrayType genericArrayType = Types.arrayOf((Type)Types.arrayOf((Type)Types.newParameterizedType(Set.class, (Type[])new Type[]{String.class})));
        Asserts.assertEqualsBothWays(this.setStringArray, genericArrayType);
        TypesTest.assertEquals((String)this.setStringArray.toString(), (String)genericArrayType.toString());
    }

    public void testToString() {
        Assert.assertEquals((String)"java.lang.String", (String)MoreTypes.typeToString(String.class));
        TypesTest.assertEquals((String)"java.util.Set<java.lang.String>[][]", (String)MoreTypes.typeToString((Type)this.setStringArray));
        TypesTest.assertEquals((String)"java.util.Map<java.lang.String, java.lang.Integer>", (String)MoreTypes.typeToString((Type)this.mapStringInteger));
        TypesTest.assertEquals((String)"java.util.List<java.util.Set<java.lang.String>[][]>", (String)MoreTypes.typeToString((Type)this.listSetStringArray));
        TypesTest.assertEquals((String)this.innerFloatDouble.toString(), (String)MoreTypes.typeToString((Type)this.innerFloatDouble));
    }

    public void testCanonicalizeRequiresOwnerTypes() {
        try {
            Types.newParameterizedType(Owning.class, (Type[])new Type[]{String.class});
            TypesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "No owner type for enclosed " + Owning.class);
        }
        try {
            Types.newParameterizedTypeWithOwner(Object.class, Set.class, (Type[])new Type[]{String.class});
            TypesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Asserts.assertContains(expected.getMessage(), "Owner type for unenclosed " + Set.class);
        }
    }

    public void testInnerParameterizedEvenWithZeroArgs() {
        TypeLiteral<Outer.Inner> type = new TypeLiteral<Outer.Inner>(this){};
        Asserts.assertEqualsBothWays(this.outerInner, type.getType());
        ParameterizedType parameterizedType = (ParameterizedType)type.getType();
        TypesTest.assertEquals((int)0, (int)parameterizedType.getActualTypeArguments().length);
        TypesTest.assertEquals((Object)new TypeLiteral<Outer<String>>(this){}.getType(), (Object)parameterizedType.getOwnerType());
        TypesTest.assertEquals(Outer.Inner.class, (Object)parameterizedType.getRawType());
    }

    static class Outer<T> {
        Outer() {
        }

        class Inner {
            Inner(Outer this$0) {
            }
        }
    }

    class Inner<T1, T2> {
        Inner(TypesTest this$0) {
        }
    }

    static class Owning<A> {
        Owning() {
        }
    }
}

