/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice;

import com.google.common.testing.GcFinalization;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matchers;
import com.googlecode.guice.PackageVisibilityTestModule;
import jakarta.inject.Inject;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BytecodeGenTest {
    private final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private final Module interceptorModule = new AbstractModule(this){

        protected void configure() {
            this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                public Object invoke(MethodInvocation chain) throws Throwable {
                    return chain.proceed() + " WORLD";
                }
            }});
        }
    };
    private final Module noopInterceptorModule = new AbstractModule(this){

        protected void configure() {
            this.bindInterceptor(Matchers.any(), Matchers.any(), new MethodInterceptor[]{new MethodInterceptor(this){

                public Object invoke(MethodInvocation chain) throws Throwable {
                    return chain.proceed();
                }
            }});
        }
    };
    private Class<ProxyTest> proxyTestClass;
    private Class<ProxyTestImpl> realClass;
    private Module testModule;

    @Test
    public void testPackageVisibility() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new PackageVisibilityTestModule()});
        injector.getInstance(PackageVisibilityTestModule.PublicUserOfPackagePrivate.class);
    }

    @Test
    public void testInterceptedPackageVisibility() {
        Assume.assumeTrue((InternalFlags.getCustomClassLoadingOption() != InternalFlags.CustomClassLoadingOption.CHILD ? 1 : 0) != 0);
        Injector injector = Guice.createInjector((Module[])new Module[]{this.interceptorModule, new PackageVisibilityTestModule()});
        injector.getInstance(PackageVisibilityTestModule.PublicUserOfPackagePrivate.class);
    }

    @Test
    public void testEnhancerNaming() {
        Assume.assumeTrue((InternalFlags.getCustomClassLoadingOption() != InternalFlags.CustomClassLoadingOption.CHILD ? 1 : 0) != 0);
        Injector injector = Guice.createInjector((Module[])new Module[]{this.interceptorModule, new PackageVisibilityTestModule()});
        PackageVisibilityTestModule.PublicUserOfPackagePrivate pupp = (PackageVisibilityTestModule.PublicUserOfPackagePrivate)injector.getInstance(PackageVisibilityTestModule.PublicUserOfPackagePrivate.class);
        Assert.assertTrue((boolean)pupp.getClass().getName().startsWith(PackageVisibilityTestModule.PublicUserOfPackagePrivate.class.getName() + "$$EnhancerByGuice$$"));
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        TestVisibilityClassLoader testClassLoader = new TestVisibilityClassLoader(true);
        this.proxyTestClass = testClassLoader.loadClass(ProxyTest.class.getName());
        this.realClass = testClassLoader.loadClass(ProxyTestImpl.class.getName());
        this.testModule = new AbstractModule(){

            public void configure() {
                this.bind(BytecodeGenTest.this.proxyTestClass).to(BytecodeGenTest.this.realClass);
            }
        };
    }

    @Test
    public void testProxyClassLoading() throws Exception {
        Object testObject = Guice.createInjector((Module[])new Module[]{this.interceptorModule, this.testModule}).getInstance(this.proxyTestClass);
        Method m = this.realClass.getMethod("sayHello", new Class[0]);
        Assert.assertEquals((Object)"HELLO WORLD", (Object)m.invoke(testObject, new Object[0]));
    }

    @Test
    public void testSystemClassLoaderIsUsedIfProxiedClassUsesIt() {
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.CHILD) {
            return;
        }
        ProxyTest testProxy = (ProxyTest)Guice.createInjector((Module[])new Module[]{this.interceptorModule, new Module(this){

            public void configure(Binder binder) {
                binder.bind(ProxyTest.class).to(ProxyTestImpl.class);
            }
        }}).getInstance(ProxyTest.class);
        if (ProxyTest.class.getClassLoader() == this.systemClassLoader) {
            Assert.assertSame((Object)testProxy.getClass().getClassLoader(), (Object)this.systemClassLoader);
        } else {
            Assert.assertNotSame((Object)testProxy.getClass().getClassLoader(), (Object)this.systemClassLoader);
        }
    }

    @Test
    public void testProxyClassUnloading() {
        Object testObject = Guice.createInjector((Module[])new Module[]{this.interceptorModule, this.testModule}).getInstance(this.proxyTestClass);
        Assert.assertNotNull((Object)testObject.getClass().getClassLoader());
        Assert.assertNotSame((Object)testObject.getClass().getClassLoader(), (Object)this.systemClassLoader);
        WeakReference clazzRef = new WeakReference(testObject.getClass());
        Assert.assertNotNull(clazzRef.get());
        testObject = null;
        this.proxyTestClass = null;
        this.realClass = null;
        GcFinalization.awaitClear(clazzRef);
        Assert.assertNull((String)"Proxy class was not unloaded.", clazzRef.get());
    }

    @Test
    public void testProxyingPackagePrivateMethods() {
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.CHILD) {
            return;
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{this.interceptorModule});
        Assert.assertEquals((Object)"HI WORLD", (Object)((PackageClassPackageMethod)injector.getInstance(PackageClassPackageMethod.class)).sayHi());
        Assert.assertEquals((Object)"HI WORLD", (Object)((PublicClassPackageMethod)injector.getInstance(PublicClassPackageMethod.class)).sayHi());
        Assert.assertEquals((Object)"HI WORLD", (Object)((ProtectedClassProtectedMethod)injector.getInstance(ProtectedClassProtectedMethod.class)).sayHi());
    }

    @Test
    public void testClassLoaderBridging() throws Exception {
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.CHILD) {
            return;
        }
        TestVisibilityClassLoader testClassLoader = new TestVisibilityClassLoader(false);
        Class<?> hiddenMethodReturnClass = testClassLoader.loadClass(HiddenMethodReturn.class.getName());
        Class<?> hiddenMethodParameterClass = testClassLoader.loadClass(HiddenMethodParameter.class.getName());
        Injector injector = Guice.createInjector((Module[])new Module[]{this.noopInterceptorModule});
        Class<?> hiddenClass = testClassLoader.loadClass(Hidden.class.getName());
        Constructor<?> ctor = hiddenClass.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        Object o1 = injector.getInstance(hiddenMethodParameterClass);
        o1.getClass().getDeclaredMethod("method", hiddenClass).invoke(o1, ctor.newInstance(new Object[0]));
        Object o2 = injector.getInstance(hiddenMethodReturnClass);
        o2.getClass().getDeclaredMethod("method", new Class[0]).invoke(o2, new Object[0]);
    }

    @Test
    public void testFastClassWithDifferentVersionsOfGuice() throws Throwable {
        if (InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.CHILD) {
            return;
        }
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ((PublicInject)injector.getInstance(PublicInject.class)).assertIsFastClassInvoked();
        ((ProtectedInject)injector.getInstance(ProtectedInject.class)).assertIsFastClassInvoked();
        ((PackagePrivateInject)injector.getInstance(PackagePrivateInject.class)).assertIsFastClassInvoked();
        ((PrivateInject)injector.getInstance(PrivateInject.class)).assertIsReflectionInvoked();
        MultipleVersionsOfGuiceClassLoader fakeLoader = new MultipleVersionsOfGuiceClassLoader();
        ((LogCreator)injector.getInstance(fakeLoader.loadLogCreatorType(PublicInject.class))).assertIsFastClassInvoked();
        ((LogCreator)injector.getInstance(fakeLoader.loadLogCreatorType(ProtectedInject.class))).assertIsFastClassInvoked();
        ((LogCreator)injector.getInstance(fakeLoader.loadLogCreatorType(PackagePrivateInject.class))).assertIsFastClassInvoked();
        ((LogCreator)injector.getInstance(fakeLoader.loadLogCreatorType(PrivateInject.class))).assertIsReflectionInvoked();
    }

    private static class PrivateInject
    extends LogCreator {
        @Inject
        private PrivateInject() {
        }
    }

    protected static class ProtectedInject
    extends LogCreator {
        @Inject
        protected ProtectedInject() {
        }
    }

    static class PackagePrivateInject
    extends LogCreator {
        @Inject
        PackagePrivateInject() {
        }
    }

    public static class PublicInject
    extends LogCreator {
        @Inject
        public PublicInject() {
        }
    }

    public static class LogCreator {
        final Throwable caller = new Throwable();

        void assertIsFastClassInvoked() throws Throwable {
            if (!this.caller.getStackTrace()[2].getClassName().contains("$$FastClassByGuice$$")) {
                throw ((Throwable)((Object)new AssertionError((Object)"Caller was not FastClass"))).initCause(this.caller);
            }
        }

        void assertIsReflectionInvoked() throws Throwable {
            for (StackTraceElement element : this.caller.getStackTrace()) {
                if (element.getClassName().equals(BytecodeGenTest.class.getName())) break;
                if (!element.getClassName().equals(Constructor.class.getName()) || !element.getMethodName().equals("newInstance")) continue;
                return;
            }
            throw ((Throwable)((Object)new AssertionError((Object)"Caller was not Constructor.newInstance"))).initCause(this.caller);
        }
    }

    static class MultipleVersionsOfGuiceClassLoader
    extends URLClassLoader {
        MultipleVersionsOfGuiceClassLoader() {
            this(MultipleVersionsOfGuiceClassLoader.class.getClassLoader());
        }

        MultipleVersionsOfGuiceClassLoader(ClassLoader classloader) {
            super(Asserts.getClassPathUrls(), classloader);
        }

        public Class<? extends LogCreator> loadLogCreatorType(Class<? extends LogCreator> cls) throws ClassNotFoundException {
            return this.loadClass(cls.getName()).asSubclass(LogCreator.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            MultipleVersionsOfGuiceClassLoader multipleVersionsOfGuiceClassLoader = this;
            synchronized (multipleVersionsOfGuiceClassLoader) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            if (name.startsWith("java.") || name.startsWith("jakarta.") || name.equals(LogCreator.class.getName()) || !name.startsWith("com.google.inject.") && !name.startsWith("com.googlecode.guice")) {
                return super.loadClass(name, resolve);
            }
            Class<?> clazz = this.findClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    public static class HiddenMethodParameter {
        public void method(Hidden h) {
        }
    }

    public static class HiddenMethodReturn {
        public Hidden method() {
            return new Hidden();
        }
    }

    static class Hidden {
        Hidden() {
        }
    }

    protected static class ProtectedClassProtectedMethod {
        protected ProtectedClassProtectedMethod() {
        }

        protected String sayHi() {
            return "HI";
        }
    }

    public static class PublicClassPackageMethod {
        String sayHi() {
            return "HI";
        }
    }

    static class PackageClassPackageMethod {
        PackageClassPackageMethod() {
        }

        String sayHi() {
            return "HI";
        }
    }

    public static class ProxyTestImpl
    implements ProxyTest {
        @Override
        public String sayHello() {
            return "HELLO";
        }
    }

    static interface ProxyTest {
        public String sayHello();
    }

    static class TestVisibilityClassLoader
    extends URLClassLoader {
        final boolean hideInternals;

        TestVisibilityClassLoader(boolean hideInternals) {
            this(TestVisibilityClassLoader.class.getClassLoader(), hideInternals);
        }

        TestVisibilityClassLoader(ClassLoader classloader, boolean hideInternals) {
            super(Asserts.getClassPathUrls(), classloader);
            this.hideInternals = hideInternals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            TestVisibilityClassLoader testVisibilityClassLoader = this;
            synchronized (testVisibilityClassLoader) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            if (name.startsWith("java.")) {
                return super.loadClass(name, resolve);
            }
            if (!name.contains(".internal.")) {
                Class<?> clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            if (this.hideInternals) {
                throw new ClassNotFoundException();
            }
            return super.loadClass(name, resolve);
        }
    }
}

