/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.util.Providers;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import junit.framework.TestCase;

public class JakartaTest
extends TestCase {
    private final B b = new B();
    private final C c = new C();
    private final D d = new D();
    private final E e = new E();
    public static final Red RED = new Red(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Red.class;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Red;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    };

    protected void setUp() throws Exception {
        J.nextInstanceId = 0;
        K.nextInstanceId = 0;
    }

    public void testInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).toInstance((Object)JakartaTest.this.b);
                this.bind(C.class).toInstance((Object)JakartaTest.this.c);
                this.bind(D.class).toInstance((Object)JakartaTest.this.d);
                this.bind(E.class).toInstance((Object)JakartaTest.this.e);
                this.bind(A.class);
            }
        }});
        A a = (A)injector.getInstance(A.class);
        JakartaTest.assertSame((Object)this.b, (Object)a.b);
        JakartaTest.assertSame((Object)this.c, (Object)a.c);
        JakartaTest.assertSame((Object)this.d, (Object)a.d);
        JakartaTest.assertSame((Object)this.e, (Object)a.e);
    }

    public void testQualifiedInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"jodie")).toInstance((Object)JakartaTest.this.b);
                this.bind(C.class).annotatedWith(Red.class).toInstance((Object)JakartaTest.this.c);
                this.bind(D.class).annotatedWith((Annotation)RED).toInstance((Object)JakartaTest.this.d);
                this.bind(E.class).annotatedWith((Annotation)Names.named((String)"jesse")).toInstance((Object)JakartaTest.this.e);
                this.bind(F.class);
            }
        }});
        F f = (F)injector.getInstance(F.class);
        JakartaTest.assertSame((Object)this.b, (Object)f.b);
        JakartaTest.assertSame((Object)this.c, (Object)f.c);
        JakartaTest.assertSame((Object)this.d, (Object)f.d);
        JakartaTest.assertSame((Object)this.e, (Object)f.e);
    }

    public void testProviderInject() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(B.class).annotatedWith((Annotation)Names.named((String)"jodie")).toInstance((Object)JakartaTest.this.b);
                this.bind(C.class).toInstance((Object)JakartaTest.this.c);
                this.bind(D.class).annotatedWith((Annotation)RED).toInstance((Object)JakartaTest.this.d);
                this.bind(E.class).toInstance((Object)JakartaTest.this.e);
                this.bind(G.class);
            }
        }});
        G g = (G)injector.getInstance(G.class);
        JakartaTest.assertSame((Object)this.b, (Object)g.bProvider.get());
        JakartaTest.assertSame((Object)this.c, (Object)g.cProvider.get());
        JakartaTest.assertSame((Object)this.d, (Object)g.dProvider.get());
        JakartaTest.assertSame((Object)this.e, (Object)g.eProvider.get());
    }

    public void testScopeAnnotation() {
        final TestScope scope = new TestScope();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(B.class).in((Scope)scope);
                this.bind(C.class).in(TestScoped.class);
                this.bindScope(TestScoped.class, scope);
            }
        }});
        B b = (B)injector.getInstance(B.class);
        JakartaTest.assertSame((Object)b, (Object)injector.getInstance(B.class));
        JakartaTest.assertSame((Object)b, (Object)injector.getInstance(B.class));
        C c = (C)injector.getInstance(C.class);
        JakartaTest.assertSame((Object)c, (Object)injector.getInstance(C.class));
        JakartaTest.assertSame((Object)c, (Object)injector.getInstance(C.class));
        H h = (H)injector.getInstance(H.class);
        JakartaTest.assertSame((Object)h, (Object)injector.getInstance(H.class));
        JakartaTest.assertSame((Object)h, (Object)injector.getInstance(H.class));
        scope.reset();
        JakartaTest.assertNotSame((Object)b, (Object)injector.getInstance(B.class));
        JakartaTest.assertNotSame((Object)c, (Object)injector.getInstance(C.class));
        JakartaTest.assertNotSame((Object)h, (Object)injector.getInstance(H.class));
    }

    public void testSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(B.class).in(Singleton.class);
            }
        }});
        B b = (B)injector.getInstance(B.class);
        JakartaTest.assertSame((Object)b, (Object)injector.getInstance(B.class));
        JakartaTest.assertSame((Object)b, (Object)injector.getInstance(B.class));
        J j = (J)injector.getInstance(J.class);
        JakartaTest.assertSame((Object)j, (Object)injector.getInstance(J.class));
        JakartaTest.assertSame((Object)j, (Object)injector.getInstance(J.class));
    }

    public void testEagerSingleton() {
        Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(J.class);
                this.bind(K.class).in(Singleton.class);
            }
        }});
        JakartaTest.assertEquals((int)1, (int)J.nextInstanceId);
        JakartaTest.assertEquals((int)1, (int)K.nextInstanceId);
    }

    public void testScopesIsSingleton() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(J.class);
                this.bind(K.class).in(Singleton.class);
            }
        }});
        JakartaTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(J.class)));
        JakartaTest.assertTrue((boolean)Scopes.isSingleton((Binding)injector.getBinding(K.class)));
    }

    public void testInjectingFinalFieldsIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(L.class);
                }
            }});
            JakartaTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Injected field JakartaTest$L.b cannot be final.");
        }
    }

    public void testInjectingAbstractMethodsIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(M.class);
                }
            }});
            JakartaTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Injected method JakartaTest$AbstractM.setB() cannot be abstract.");
        }
    }

    public void testInjectingMethodsWithTypeParametersIsForbidden() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

                protected void configure() {
                    this.bind(N.class);
                }
            }});
            JakartaTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Injected method JakartaTest$N.setB() cannot declare type ");
        }
    }

    public void testInjectingMethodsWithNonVoidReturnTypes() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(P.class);
            }
        }});
    }

    public void testGuicifyJakartaProvider() {
        jakarta.inject.Provider<String> jakartaProvider = new jakarta.inject.Provider<String>(this){

            public String get() {
                return "A";
            }

            public String toString() {
                return "jakartaProvider";
            }
        };
        Provider guicified = Providers.guicify((jakarta.inject.Provider)jakartaProvider);
        JakartaTest.assertEquals((String)"guicified(jakartaProvider)", (String)guicified.toString());
        JakartaTest.assertEquals((String)"A", (String)((String)guicified.get()));
        JakartaTest.assertSame((Object)guicified, (Object)Providers.guicify((Provider)guicified));
        JakartaTest.assertFalse((boolean)(guicified instanceof HasDependencies));
    }

    public void testGuicifyWithDependencies() {
        jakarta.inject.Provider<String> jakartaProvider = new jakarta.inject.Provider<String>(this){
            @Inject
            double d;
            int i;

            @Inject
            void injectMe(int i) {
                this.i = i;
            }

            public String get() {
                return this.d + "-" + this.i;
            }
        };
        final Provider guicified = Providers.guicify((jakarta.inject.Provider)jakartaProvider);
        JakartaTest.assertTrue((boolean)(guicified instanceof HasDependencies));
        Set actual = ((HasDependencies)guicified).getDependencies();
        this.validateDependencies(actual, jakartaProvider.getClass());
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                this.bind(String.class).toProvider(guicified);
                this.bind(Integer.TYPE).toInstance((Object)1);
                this.bind(Double.TYPE).toInstance((Object)2.0);
            }
        }});
        Binding binding = injector.getBinding(String.class);
        JakartaTest.assertEquals((String)"2.0-1", (String)((String)binding.getProvider().get()));
        this.validateDependencies(actual, jakartaProvider.getClass());
    }

    private void validateDependencies(Set<Dependency<?>> actual, Class<?> owner) {
        JakartaTest.assertEquals((String)actual.toString(), (int)2, (int)actual.size());
        Dependency<?> dDep = null;
        Dependency<?> iDep = null;
        for (Dependency<?> dep : actual) {
            if (dep.getKey().equals((Object)Key.get(Double.class))) {
                dDep = dep;
                continue;
            }
            if (!dep.getKey().equals((Object)Key.get(Integer.class))) continue;
            iDep = dep;
        }
        JakartaTest.assertNotNull(dDep);
        JakartaTest.assertNotNull(iDep);
        JakartaTest.assertEquals((Object)TypeLiteral.get(owner), (Object)dDep.getInjectionPoint().getDeclaringType());
        JakartaTest.assertEquals((String)"d", (String)dDep.getInjectionPoint().getMember().getName());
        JakartaTest.assertEquals((int)-1, (int)dDep.getParameterIndex());
        JakartaTest.assertEquals((Object)TypeLiteral.get(owner), (Object)iDep.getInjectionPoint().getDeclaringType());
        JakartaTest.assertEquals((String)"injectMe", (String)iDep.getInjectionPoint().getMember().getName());
        JakartaTest.assertEquals((int)0, (int)iDep.getParameterIndex());
    }

    static class BProvider
    implements jakarta.inject.Provider<B> {
        BProvider() {
        }

        public B get() {
            return new B();
        }
    }

    static class P {
        P() {
        }

        @Inject
        B setB(B b) {
            return b;
        }
    }

    static class N {
        N() {
        }

        @Inject
        <T> void setB(B b) {
        }
    }

    static class M
    extends AbstractM {
        M() {
        }

        @Override
        void setB(B b) {
        }
    }

    static abstract class AbstractM {
        AbstractM() {
        }

        @Inject
        abstract void setB(B var1);
    }

    static class L {
        @Inject
        final B b = null;

        L() {
        }
    }

    static class K {
        static int nextInstanceId = 0;
        int instanceId = nextInstanceId++;

        K() {
        }
    }

    @Singleton
    static class J {
        static int nextInstanceId = 0;
        int instanceId = nextInstanceId++;

        J() {
        }
    }

    @TestScoped
    static class H {
        H() {
        }
    }

    static class TestScope
    implements Scope {
        private int now = 0;

        TestScope() {
        }

        public <T> Provider<T> scope(Key<T> key, final Provider<T> unscoped) {
            return new Provider<T>(){
                private T value;
                private int snapshotTime = -1;

                public T get() {
                    if (this.snapshotTime != now) {
                        this.value = unscoped.get();
                        this.snapshotTime = now;
                    }
                    return this.value;
                }
            };
        }

        public void reset() {
            ++this.now;
        }
    }

    @jakarta.inject.Scope
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestScoped {
    }

    static class G {
        final jakarta.inject.Provider<B> bProvider;
        @Inject
        jakarta.inject.Provider<C> cProvider;
        jakarta.inject.Provider<D> dProvider;
        jakarta.inject.Provider<E> eProvider;

        @Inject
        G(@Named(value="jodie") jakarta.inject.Provider<B> bProvider) {
            this.bProvider = bProvider;
        }

        @Inject
        void injectD(@Red jakarta.inject.Provider<D> dProvider, jakarta.inject.Provider<E> eProvider) {
            this.dProvider = dProvider;
            this.eProvider = eProvider;
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Red {
    }

    static class F {
        final B b;
        @Inject
        @Red
        C c;
        D d;
        E e;

        @Inject
        F(@Named(value="jodie") B b) {
            this.b = b;
        }

        @Inject
        void injectD(@Red D d, @Named(value="jesse") E e) {
            this.d = d;
            this.e = e;
        }
    }

    static class E {
        E() {
        }
    }

    static class D {
        D() {
        }
    }

    static class C {
        C() {
        }
    }

    static class B {
        B() {
        }
    }

    static class A {
        final B b;
        @Inject
        C c;
        D d;
        E e;

        @Inject
        A(B b) {
            this.b = b;
        }

        @Inject
        void injectD(D d, E e) {
            this.d = d;
            this.e = e;
        }
    }
}

