/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.debugging.sourcemap.Base64;
import java.io.IOException;

final class Base64VLQ {
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;

    private Base64VLQ() {
    }

    private static int toVLQSigned(int n) {
        if (n < 0) {
            return (-n << 1) + 1;
        }
        return (n << 1) + 0;
    }

    private static int fromVLQSigned(int n) {
        boolean bl = (n & 1) == 1;
        return bl ? -n : (n >>= 1);
    }

    public static void encode(Appendable appendable, int n) throws IOException {
        n = Base64VLQ.toVLQSigned(n);
        do {
            int n2 = n & 0x1F;
            if ((n >>>= 5) > 0) {
                n2 |= 0x20;
            }
            appendable.append(Base64.toBase64(n2));
        } while (n > 0);
    }

    public static int decode(CharIterator charIterator) {
        boolean bl;
        int n = 0;
        int n2 = 0;
        do {
            char c;
            int n3;
            bl = ((n3 = Base64.fromBase64(c = charIterator.next())) & 0x20) != 0;
            n += (n3 &= 0x1F) << n2;
            n2 += 5;
        } while (bl);
        return Base64VLQ.fromVLQSigned(n);
    }

    static interface CharIterator {
        public boolean hasNext();

        public char next();
    }
}

