/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Shorts;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.proto.Mapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceMapConsumerV1
implements SourceMapConsumer {
    private static final String LINEMAP_HEADER = "/** Begin line maps. **/";
    private static final String FILEINFO_HEADER = "/** Begin file information. **/";
    private static final String DEFINITION_HEADER = "/** Begin mapping definitions. **/";
    private ImmutableList<ImmutableList<LineFragment>> characterMap;
    private ImmutableList<SourceFile> mappings;

    @Override
    public void parse(String string) throws SourceMapParseException {
        ParseState parseState = new ParseState(string);
        try {
            this.parseInternal(parseState);
        }
        catch (JSONException jSONException) {
            parseState.fail("JSON parse exception: " + (Object)((Object)jSONException));
        }
    }

    private int parseCharacterMap(ParseState parseState, int n, ImmutableList.Builder<ImmutableList<LineFragment>> builder) throws SourceMapParseException, JSONException {
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string = parseState.readLine();
            if (string.isEmpty()) continue;
            ImmutableList.Builder builder2 = ImmutableList.builder();
            LineFragment lineFragment = null;
            JSONArray jSONArray = new JSONArray(string);
            int n3 = jSONArray.length();
            int n4 = -1;
            int n5 = Integer.MIN_VALUE;
            ArrayList arrayList = Lists.newArrayList();
            for (int j = 0; j < jSONArray.length(); ++j) {
                int n6 = n4;
                if (!jSONArray.isNull(j) && (n6 = jSONArray.optInt(j)) > n2) {
                    n2 = n6;
                }
                if (n5 == Integer.MIN_VALUE) {
                    n5 = n6;
                } else if (n6 - n4 > 127 || n6 - n4 < -128) {
                    lineFragment = new LineFragment(n5, Bytes.toArray((Collection)arrayList));
                    arrayList.clear();
                    builder2.add((Object)lineFragment);
                    n5 = n6;
                } else {
                    arrayList.add((byte)(n6 - n4));
                }
                n4 = n6;
            }
            if (n5 != Integer.MIN_VALUE) {
                lineFragment = new LineFragment(n5, Bytes.toArray((Collection)arrayList));
                builder2.add((Object)lineFragment);
            }
            builder.add((Object)builder2.build());
        }
        return n2;
    }

    private FileName splitFileName(Interner<String> interner, String string) {
        int n = string.lastIndexOf(47);
        String string2 = (String)interner.intern((Object)string.substring(0, n + 1));
        String string3 = (String)interner.intern((Object)string.substring(n + 1));
        return new FileName(string2, string3);
    }

    private void parseFileMappings(ParseState parseState, int n) throws SourceMapParseException, JSONException {
        Object object;
        Interner interner = Interners.newStrongInterner();
        ImmutableList.Builder builder = ImmutableList.builder();
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i <= n; ++i) {
            object = parseState.readLine();
            JSONArray jSONArray = new JSONArray((String)object);
            if (jSONArray.length() < 3) {
                parseState.fail("Invalid mapping array");
            }
            String string2 = jSONArray.getString(0);
            int n5 = jSONArray.getInt(1);
            if (!string2.equals(string) || n5 - n2 > 127 || n5 - n2 < -128) {
                if (string != null) {
                    FileName fileName = this.splitFileName((Interner<String>)interner, string);
                    SourceFile.Builder builder2 = SourceFile.newBuilder().setDir(fileName.dir).setFileName(fileName.name).setStartLine(n3).setStartMapId(n4).setLineOffsets(arrayList).setColumns(arrayList2).setIdentifiers(arrayList3);
                    builder.add((Object)builder2.build());
                }
                string = string2;
                n3 = n5;
                n2 = n5;
                n4 = i;
                arrayList2.clear();
                arrayList.clear();
                arrayList3.clear();
            }
            arrayList.add((byte)(n5 - n2));
            arrayList2.add((short)jSONArray.getInt(2));
            arrayList3.add(interner.intern((Object)jSONArray.optString(3, "")));
            n2 = n5;
        }
        if (string != null) {
            FileName fileName = this.splitFileName((Interner<String>)interner, string);
            object = SourceFile.newBuilder().setDir(fileName.dir).setFileName(fileName.name).setStartLine(n3).setStartMapId(n4).setLineOffsets(arrayList).setColumns(arrayList2).setIdentifiers(arrayList3);
            builder.add((Object)((SourceFile.Builder)object).build());
        }
        this.mappings = builder.build();
    }

    private void parseInternal(ParseState parseState) throws SourceMapParseException, JSONException {
        int n;
        String string = parseState.readLine();
        Preconditions.checkArgument((boolean)string.startsWith(LINEMAP_HEADER), (String)"Expected %s", (Object[])new Object[]{LINEMAP_HEADER});
        JSONObject jSONObject = new JSONObject(string.substring(LINEMAP_HEADER.length()));
        if (!jSONObject.has("count")) {
            parseState.fail("Missing 'count'");
        }
        if ((n = jSONObject.getInt("count")) <= 0) {
            parseState.fail("Count must be >= 1");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int n2 = this.parseCharacterMap(parseState, n, (ImmutableList.Builder<ImmutableList<LineFragment>>)builder);
        this.characterMap = builder.build();
        parseState.expectLine(FILEINFO_HEADER);
        for (int i = 0; i < n; ++i) {
            parseState.readLine();
        }
        parseState.expectLine(DEFINITION_HEADER);
        this.parseFileMappings(parseState, n2);
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int n, int n2) {
        Preconditions.checkNotNull(this.characterMap, (Object)"parse() must be called first");
        if (n < 1 || n > this.characterMap.size() || n2 < 1) {
            return null;
        }
        List list = (List)this.characterMap.get(n - 1);
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n3 = 0;
        LineFragment lineFragment = (LineFragment)list.get(list.size() - 1);
        int n4 = lineFragment.valueAtColumn(lineFragment.length());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n5 = n2 - n3;
            LineFragment lineFragment2 = (LineFragment)iterator.next();
            if (n5 <= lineFragment2.length()) {
                n4 = lineFragment2.valueAtColumn(n5);
                break;
            }
            n3 += lineFragment2.length();
        }
        if (n4 < 0) {
            return null;
        }
        return this.getMappingFromId(n4);
    }

    private SourceFile binarySearch(int n) {
        int n2 = 0;
        int n3 = this.mappings.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            SourceFile sourceFile = (SourceFile)this.mappings.get(n4);
            if (n < sourceFile.getStartMapId()) {
                n3 = n4 - 1;
                continue;
            }
            if (n < sourceFile.getStartMapId() + sourceFile.getLength()) {
                return sourceFile;
            }
            n2 = n4 + 1;
        }
        return null;
    }

    private Mapping.OriginalMapping getMappingFromId(int n) {
        SourceFile sourceFile = this.binarySearch(n);
        if (sourceFile == null) {
            return null;
        }
        int n2 = n - sourceFile.getStartMapId();
        return sourceFile.getOriginalMapping(n2);
    }

    private static final class SourceFile {
        final String dir;
        final String fileName;
        final int startMapId;
        final int startLine;
        final byte[] lineOffsets;
        final short[] columns;
        final String[] identifiers;

        private SourceFile(String string, String string2, int n, int n2, byte[] byArray, short[] sArray, String[] stringArray) {
            this.fileName = (String)Preconditions.checkNotNull((Object)string2);
            this.dir = (String)Preconditions.checkNotNull((Object)string);
            this.startLine = n;
            this.startMapId = n2;
            this.lineOffsets = (byte[])Preconditions.checkNotNull((Object)byArray);
            this.columns = (short[])Preconditions.checkNotNull((Object)sArray);
            this.identifiers = (String[])Preconditions.checkNotNull((Object)stringArray);
            Preconditions.checkArgument((byArray.length == sArray.length && sArray.length == stringArray.length ? 1 : 0) != 0);
        }

        private SourceFile(int n) {
            this.startMapId = n;
            this.fileName = null;
            this.dir = null;
            this.startLine = 0;
            this.lineOffsets = null;
            this.columns = null;
            this.identifiers = null;
        }

        int getLength() {
            return this.lineOffsets.length;
        }

        int getStartMapId() {
            return this.startMapId;
        }

        Mapping.OriginalMapping getOriginalMapping(int n) {
            int n2 = this.startLine;
            for (int i = 0; i <= n; ++i) {
                n2 += this.lineOffsets[i];
            }
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(this.dir + this.fileName).setLineNumber(n2).setColumnPosition(this.columns[n]).setIdentifier(this.identifiers[n]);
            return builder.build();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            String dir;
            String fileName;
            int startMapId;
            int startLine;
            byte[] lineOffsets;
            short[] columns;
            String[] identifiers;

            Builder() {
            }

            Builder setDir(String string) {
                this.dir = string;
                return this;
            }

            Builder setFileName(String string) {
                this.fileName = string;
                return this;
            }

            Builder setStartMapId(int n) {
                this.startMapId = n;
                return this;
            }

            Builder setStartLine(int n) {
                this.startLine = n;
                return this;
            }

            Builder setLineOffsets(List<Byte> list) {
                this.lineOffsets = Bytes.toArray(list);
                return this;
            }

            Builder setColumns(List<Short> list) {
                this.columns = Shorts.toArray(list);
                return this;
            }

            Builder setIdentifiers(List<String> list) {
                this.identifiers = list.toArray(new String[0]);
                return this;
            }

            SourceFile build() {
                return new SourceFile(this.dir, this.fileName, this.startLine, this.startMapId, this.lineOffsets, this.columns, this.identifiers);
            }
        }
    }

    private static final class LineFragment {
        private final int startIndex;
        private final byte[] offsets;

        LineFragment(int n, byte[] byArray) {
            this.startIndex = n;
            this.offsets = byArray;
        }

        int length() {
            return this.offsets.length + 1;
        }

        int valueAtColumn(int n) {
            Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
            int n2 = this.startIndex;
            for (int i = 0; i < n - 1; ++i) {
                n2 += this.offsets[i];
            }
            return n2;
        }
    }

    private class FileName {
        private final String dir;
        private final String name;

        FileName(String string, String string2) {
            this.dir = string;
            this.name = string2;
        }
    }

    private static class ParseState {
        final String contents;
        int currentPosition = 0;

        ParseState(String string) {
            this.contents = string;
        }

        String readLineOrNull() {
            if (this.currentPosition >= this.contents.length()) {
                return null;
            }
            int n = this.contents.indexOf(10, this.currentPosition);
            if (n < 0) {
                n = this.contents.length();
            }
            String string = this.contents.substring(this.currentPosition, n);
            this.currentPosition = n + 1;
            return string;
        }

        String readLine() throws SourceMapParseException {
            String string = this.readLineOrNull();
            if (string == null) {
                this.fail("EOF");
            }
            return string;
        }

        void expectLine(String string) throws SourceMapParseException {
            String string2 = this.readLine();
            if (!string.equals(string2)) {
                this.fail("Expected " + string + " got " + string2);
            }
        }

        void fail(String string) throws SourceMapParseException {
            throw new SourceMapParseException(string);
        }
    }
}

