/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SourceMapGeneratorV3
implements SourceMapGenerator {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = Lists.newArrayList();
    private LinkedHashMap<String, Integer> sourceFileMap = Maps.newLinkedHashMap();
    private LinkedHashMap<String, Integer> originalNameMap = Maps.newLinkedHashMap();
    private String lastSourceFile = null;
    private int lastSourceFileIndex = -1;
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    @Override
    public void reset() {
        this.mappings.clear();
        this.lastMapping = null;
        this.sourceFileMap.clear();
        this.originalNameMap.clear();
        this.lastSourceFile = null;
        this.lastSourceFileIndex = -1;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void validate(boolean bl) {
    }

    @Override
    public void setWrapperPrefix(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        this.prefixPosition = new FilePosition(n, n2);
    }

    @Override
    public void setStartingPosition(int n, int n2) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new FilePosition(n, n2);
    }

    @Override
    public void addMapping(String string, @Nullable String string2, FilePosition filePosition, FilePosition filePosition2, FilePosition filePosition3) {
        int n;
        int n2;
        if (string == null || filePosition.getLine() < 0) {
            return;
        }
        FilePosition filePosition4 = filePosition2;
        FilePosition filePosition5 = filePosition3;
        if (this.offsetPosition.getLine() != 0 || this.offsetPosition.getColumn() != 0) {
            int n3 = this.offsetPosition.getLine();
            n2 = this.offsetPosition.getColumn();
            n = this.offsetPosition.getColumn();
            if (filePosition2.getLine() > 0) {
                n2 = 0;
            }
            if (filePosition3.getLine() > 0) {
                n = 0;
            }
            filePosition4 = new FilePosition(filePosition2.getLine() + n3, filePosition2.getColumn() + n2);
            filePosition5 = new FilePosition(filePosition3.getLine() + n3, filePosition3.getColumn() + n);
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = string;
        mapping.originalPosition = filePosition;
        mapping.originalName = string2;
        mapping.startPosition = filePosition4;
        mapping.endPosition = filePosition5;
        if (this.lastMapping != null) {
            n2 = this.lastMapping.startPosition.getLine();
            n = this.lastMapping.startPosition.getColumn();
            int n4 = mapping.startPosition.getLine();
            int n5 = mapping.startPosition.getColumn();
            Preconditions.checkState((n4 > n2 || n4 == n2 && n5 >= n ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", (Object[])new Object[]{n2, n, n4, n5});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void appendTo(Appendable appendable, String string) throws IOException {
        int n = this.prepMappings();
        appendable.append("{\n");
        SourceMapGeneratorV3.appendFirstField(appendable, "version", "3");
        SourceMapGeneratorV3.appendField(appendable, "file", SourceMapGeneratorV3.escapeString(string));
        SourceMapGeneratorV3.appendField(appendable, "lineCount", String.valueOf(n + 1));
        SourceMapGeneratorV3.appendFieldStart(appendable, "mappings");
        new LineMapper(appendable).appendLineMappings();
        SourceMapGeneratorV3.appendFieldEnd(appendable);
        SourceMapGeneratorV3.appendFieldStart(appendable, "sources");
        appendable.append("[");
        this.addSourceNameMap(appendable);
        appendable.append("]");
        SourceMapGeneratorV3.appendFieldEnd(appendable);
        SourceMapGeneratorV3.appendFieldStart(appendable, "names");
        appendable.append("[");
        this.addSymbolNameMap(appendable);
        appendable.append("]");
        SourceMapGeneratorV3.appendFieldEnd(appendable);
        appendable.append("\n}\n");
    }

    private void addSourceNameMap(Appendable appendable) throws IOException {
        this.addNameMap(appendable, this.sourceFileMap);
    }

    private void addSymbolNameMap(Appendable appendable) throws IOException {
        this.addNameMap(appendable, this.originalNameMap);
    }

    private void addNameMap(Appendable appendable, Map<String, Integer> map) throws IOException {
        int n = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey();
            if (n != 0) {
                appendable.append(",");
            }
            appendable.append(SourceMapGeneratorV3.escapeString(string));
            ++n;
        }
    }

    private static String escapeString(String string) {
        return Util.escapeString(string);
    }

    private static void appendFirstField(Appendable appendable, String string, String string2) throws IOException {
        appendable.append("\"");
        appendable.append(string);
        appendable.append("\"");
        appendable.append(":");
        appendable.append(string2);
    }

    private static void appendField(Appendable appendable, String string, String string2) throws IOException {
        appendable.append(",\n");
        appendable.append("\"");
        appendable.append(string);
        appendable.append("\"");
        appendable.append(":");
        appendable.append(string2);
    }

    private static void appendFieldStart(Appendable appendable, String string) throws IOException {
        SourceMapGeneratorV3.appendField(appendable, string, "");
    }

    private static void appendFieldEnd(Appendable appendable) throws IOException {
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (Mapping mapping : this.mappings) {
            if (!mapping.used) continue;
            mapping.id = n++;
            int n3 = mapping.endPosition.getLine();
            n2 = Math.max(n2, n3);
        }
        return n2 + this.prefixPosition.getLine();
    }

    @Override
    public void writeMetaMap(Appendable appendable, String string, List<SourceMapSection> list) throws IOException {
        appendable.append("{\n");
        SourceMapGeneratorV3.appendFirstField(appendable, "version", "3");
        SourceMapGeneratorV3.appendField(appendable, "file", SourceMapGeneratorV3.escapeString(string));
        SourceMapGeneratorV3.appendFieldStart(appendable, "sections");
        appendable.append("[\n");
        boolean bl = true;
        Long l = new Long(0L);
        for (SourceMapSection sourceMapSection : list) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(",\n");
            }
            appendable.append("{\n");
            SourceMapGeneratorV3.appendFirstField(appendable, "offset", l.toString());
            SourceMapGeneratorV3.appendField(appendable, "url", SourceMapGeneratorV3.escapeString(sourceMapSection.getSectionUrl()));
            appendable.append("\n}");
            l = l + sourceMapSection.getLength();
        }
        appendable.append("\n]");
        SourceMapGeneratorV3.appendFieldEnd(appendable);
        appendable.append("\n}\n");
    }

    private int getSourceId(String string) {
        if (string != this.lastSourceFile) {
            this.lastSourceFile = string;
            Integer n = this.sourceFileMap.get(string);
            if (n != null) {
                this.lastSourceFileIndex = n;
            } else {
                this.lastSourceFileIndex = this.sourceFileMap.size();
                this.sourceFileMap.put(string, this.lastSourceFileIndex);
            }
        }
        return this.lastSourceFileIndex;
    }

    private int getNameId(String string) {
        int n;
        Integer n2 = this.originalNameMap.get(string);
        if (n2 != null) {
            n = n2;
        } else {
            n = this.originalNameMap.size();
            this.originalNameMap.put(string, n);
        }
        return n;
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private int previousLine = -1;
        private int previousColumn = 0;
        private int previousSourceFileId;
        private int previousSourceLine;
        private int previousSourceColumn;
        private int previousNameId;

        LineMapper(Appendable appendable) {
            this.out = appendable;
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            int n5;
            int n6 = n5 = mapping != null ? mapping.id : -1;
            if (this.previousLine != n) {
                this.previousColumn = 0;
            }
            if (n != n3 || n2 != n4) {
                if (this.previousLine == n) {
                    this.out.append(',');
                }
                this.writeEntry(mapping, n2);
                this.previousLine = n;
                this.previousColumn = n2;
            }
            for (int i = n; i <= n3 && i != n3; ++i) {
                this.closeLine(false);
                this.openLine(false);
            }
        }

        void writeEntry(Mapping mapping, int n) throws IOException {
            Base64VLQ.encode(this.out, n - this.previousColumn);
            this.previousColumn = n;
            if (mapping != null) {
                int n2 = SourceMapGeneratorV3.this.getSourceId(mapping.sourceFile);
                Base64VLQ.encode(this.out, n2 - this.previousSourceFileId);
                this.previousSourceFileId = n2;
                int n3 = mapping.originalPosition.getLine();
                int n4 = mapping.originalPosition.getColumn();
                Base64VLQ.encode(this.out, n3 - this.previousSourceLine);
                this.previousSourceLine = n3;
                Base64VLQ.encode(this.out, n4 - this.previousSourceColumn);
                this.previousSourceColumn = n4;
                if (mapping.originalName != null) {
                    int n5 = SourceMapGeneratorV3.this.getNameId(mapping.originalName);
                    Base64VLQ.encode(this.out, n5 - this.previousNameId);
                    this.previousNameId = n5;
                }
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine(true);
            new MappingTraversal().traverse(this);
            this.closeLine(true);
        }

        private void openLine(boolean bl) throws IOException {
            if (bl) {
                this.out.append('\"');
            }
        }

        private void closeLine(boolean bl) throws IOException {
            this.out.append(';');
            if (bl) {
                this.out.append('\"');
            }
        }
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor mappingVisitor) throws IOException {
            ArrayDeque<Mapping> arrayDeque = new ArrayDeque<Mapping>();
            for (Mapping mapping : SourceMapGeneratorV3.this.mappings) {
                Mapping mapping2;
                while (!arrayDeque.isEmpty() && !this.isOverlapped((Mapping)arrayDeque.peek(), mapping)) {
                    mapping2 = (Mapping)arrayDeque.pop();
                    this.maybeVisit(mappingVisitor, mapping2);
                }
                mapping2 = (Mapping)arrayDeque.peek();
                this.maybeVisitParent(mappingVisitor, mapping2, mapping);
                arrayDeque.push(mapping);
            }
            while (!arrayDeque.isEmpty()) {
                Mapping mapping = (Mapping)arrayDeque.pop();
                this.maybeVisit(mappingVisitor, mapping);
            }
        }

        private int getAdjustedLine(FilePosition filePosition) {
            return filePosition.getLine() + SourceMapGeneratorV3.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition filePosition) {
            int n = filePosition.getLine();
            int n2 = filePosition.getColumn();
            return n != 0 ? n2 : n2 + SourceMapGeneratorV3.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping mapping, Mapping mapping2) {
            int n = mapping.endPosition.getLine();
            int n2 = mapping2.startPosition.getLine();
            int n3 = mapping.endPosition.getColumn();
            int n4 = mapping2.startPosition.getColumn();
            return n == n2 && n3 >= n4 || n > n2;
        }

        private void maybeVisit(MappingVisitor mappingVisitor, Mapping mapping) throws IOException {
            int n = this.getAdjustedLine(mapping.endPosition);
            int n2 = this.getAdjustedCol(mapping.endPosition);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void maybeVisitParent(MappingVisitor mappingVisitor, Mapping mapping, Mapping mapping2) throws IOException {
            int n = this.getAdjustedLine(mapping2.startPosition);
            int n2 = this.getAdjustedCol(mapping2.startPosition);
            Preconditions.checkState((this.line < n || this.col <= n2 ? 1 : 0) != 0);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void visit(MappingVisitor mappingVisitor, Mapping mapping, int n, int n2) throws IOException {
            Preconditions.checkState((this.line <= n ? 1 : 0) != 0);
            Preconditions.checkState((this.line < n || this.col < n2 ? 1 : 0) != 0);
            if (this.line == n && this.col == n2) {
                Preconditions.checkState((boolean)false);
                return;
            }
            mappingVisitor.visit(mapping, this.line, this.col, n, n2);
            this.line = n;
            this.col = n2;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            if (mapping != null) {
                mapping.used = true;
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

