/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;

class CheckUnreachableCode
implements NodeTraversal.ScopedCallback {
    static final DiagnosticType UNREACHABLE_CODE = DiagnosticType.error("JSC_UNREACHABLE_CODE", "unreachable code");
    private final AbstractCompiler compiler;
    private final CheckLevel level;

    CheckUnreachableCode(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.level = checkLevel;
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        this.initScope(nodeTraversal.getControlFlowGraph());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        GraphNode graphNode = nodeTraversal.getControlFlowGraph().getNode(node);
        if (graphNode != null && graphNode.getAnnotation() != GraphReachability.REACHABLE && node.getLineno() != -1 && node.getType() != 124 && node.getType() != 116) {
            this.compiler.report(nodeTraversal.makeError(node, this.level, UNREACHABLE_CODE, new String[0]));
            new GraphReachability(nodeTraversal.getControlFlowGraph()).recompute(node);
            return false;
        }
        return true;
    }

    private void initScope(ControlFlowGraph<Node> controlFlowGraph) {
        new GraphReachability<Node, ControlFlowGraph.Branch>(controlFlowGraph, new ReachablePredicate()).compute((Node)controlFlowGraph.getEntry().getValue());
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    private final class ReachablePredicate
    implements Predicate<GraphReachability.EdgeTuple<Node, ControlFlowGraph.Branch>> {
        private ReachablePredicate() {
        }

        public boolean apply(GraphReachability.EdgeTuple<Node, ControlFlowGraph.Branch> edgeTuple) {
            TernaryValue ternaryValue;
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)edgeTuple.edge);
            if (!branch.isConditional()) {
                return true;
            }
            Node node = (Node)edgeTuple.sourceNode;
            Node node2 = NodeUtil.getConditionExpression(node);
            if (node2 != null && (ternaryValue = NodeUtil.getImpureBooleanValue(node2)) != TernaryValue.UNKNOWN) {
                return ternaryValue.toBoolean(true) == (branch == ControlFlowGraph.Branch.ON_TRUE);
            }
            return true;
        }
    }
}

