/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CompilerInput
implements SourceAst,
DependencyInfo {
    private static final long serialVersionUID = 1L;
    private JSModule module;
    private boolean isExtern;
    private final String name;
    private final SourceAst ast;
    private final Set<String> provides = Sets.newHashSet();
    private final Set<String> requires = Sets.newHashSet();
    private boolean generatedDependencyInfoFromSource = false;
    private ErrorManager errorManager;
    private AbstractCompiler compiler;

    public CompilerInput(SourceAst sourceAst) {
        this(sourceAst, sourceAst.getSourceFile().getName(), false);
    }

    public CompilerInput(SourceAst sourceAst, boolean bl) {
        this(sourceAst, sourceAst.getSourceFile().getName(), bl);
    }

    public CompilerInput(SourceAst sourceAst, String string, boolean bl) {
        this.ast = sourceAst;
        this.name = string;
        this.isExtern = bl;
    }

    public CompilerInput(JSSourceFile jSSourceFile) {
        this(jSSourceFile, false);
    }

    public CompilerInput(JSSourceFile jSSourceFile, boolean bl) {
        this.ast = new JsAst(jSSourceFile);
        this.name = jSSourceFile.getName();
        this.isExtern = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getAstRoot(AbstractCompiler abstractCompiler) {
        return this.ast.getAstRoot(abstractCompiler);
    }

    @Override
    public void clearAst() {
        this.ast.clearAst();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.ast.getSourceFile();
    }

    @Override
    public void setSourceFile(SourceFile sourceFile) {
        this.ast.setSourceFile(sourceFile);
    }

    public SourceAst getSourceAst() {
        return this.ast;
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public void setCompiler(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.setErrorManager(abstractCompiler.getErrorManager());
    }

    @Override
    public Collection<String> getRequires() {
        Preconditions.checkNotNull((Object)this.errorManager, (Object)"Expected setErrorManager to be called first");
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.requires);
        }
        catch (IOException iOException) {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    @Override
    public Collection<String> getProvides() {
        Preconditions.checkNotNull((Object)this.errorManager, (Object)"Expected setErrorManager to be called first");
        try {
            this.regenerateDependencyInfoIfNecessary();
            return Collections.unmodifiableSet(this.provides);
        }
        catch (IOException iOException) {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName()));
            return ImmutableList.of();
        }
    }

    private void regenerateDependencyInfoIfNecessary() throws IOException {
        if (!(this.ast instanceof JsAst)) {
            Preconditions.checkNotNull((Object)this.compiler, (Object)"Expected setCompiler to be called first");
            DepsFinder depsFinder = new DepsFinder();
            Node node = this.getAstRoot(this.compiler);
            if (node == null) {
                return;
            }
            depsFinder.visitTree(this.getAstRoot(this.compiler));
            this.provides.addAll(depsFinder.provides);
            this.requires.addAll(depsFinder.requires);
        } else if (!this.generatedDependencyInfoFromSource) {
            DependencyInfo dependencyInfo = new JsFileParser(this.errorManager).parseFile(this.getName(), this.getName(), this.getCode());
            this.provides.addAll(dependencyInfo.getProvides());
            this.requires.addAll(dependencyInfo.getRequires());
            this.generatedDependencyInfoFromSource = true;
        }
    }

    public String getLine(int n) {
        return this.getSourceFile().getLine(n);
    }

    public Region getRegion(int n) {
        return this.getSourceFile().getRegion(n);
    }

    public String getCode() throws IOException {
        return this.getSourceFile().getCode();
    }

    public JSModule getModule() {
        return this.module;
    }

    public void setModule(JSModule jSModule) {
        Preconditions.checkArgument((jSModule == null || this.module == null || this.module == jSModule ? 1 : 0) != 0);
        this.module = jSModule;
    }

    public boolean isExtern() {
        return this.isExtern;
    }

    void setIsExtern(boolean bl) {
        this.isExtern = bl;
    }

    private static class DepsFinder {
        private final List<String> provides = Lists.newArrayList();
        private final List<String> requires = Lists.newArrayList();
        private final CodingConvention codingConvention = new ClosureCodingConvention();

        private DepsFinder() {
        }

        void visitTree(Node node) {
            this.visitSubtree(node, null);
        }

        void visitSubtree(Node node, Node node2) {
            if (node.getType() == 37) {
                String string;
                String string2 = this.codingConvention.extractClassNameIfRequire(node, node2);
                if (string2 != null) {
                    this.requires.add(string2);
                }
                if ((string = this.codingConvention.extractClassNameIfProvide(node, node2)) != null) {
                    this.provides.add(string);
                }
                return;
            }
            if (node2 != null && node2.getType() != 130 && node2.getType() != 132) {
                return;
            }
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                this.visitSubtree(node3, node);
            }
        }
    }
}

