/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.Serializable;

class ControlStructureCheck
implements CompilerPass {
    private AbstractCompiler compiler;
    private String sourceName = null;
    static final DiagnosticType USE_OF_WITH = DiagnosticType.warning("JSC_USE_OF_WITH", "The use of the 'with' structure should be avoided.");

    ControlStructureCheck(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.check(node2);
    }

    private void check(Node node) {
        Serializable serializable;
        switch (node.getType()) {
            case 119: {
                boolean bl;
                serializable = node.getJSDocInfo();
                boolean bl2 = bl = serializable != null && ((JSDocInfo)serializable).getSuppressions().contains("with");
                if (bl) break;
                this.report(node, USE_OF_WITH);
                break;
            }
            case 132: {
                this.sourceName = (String)node.getProp(16);
            }
        }
        serializable = node.getFirstChild();
        while (serializable != null) {
            Node node2 = ((Node)serializable).getNext();
            this.check((Node)serializable);
            serializable = node2;
        }
    }

    private void report(Node node, DiagnosticType diagnosticType) {
        this.compiler.report(JSError.make(this.sourceName, node, diagnosticType, new String[0]));
    }
}

