/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Set;

class DefinitionsRemover {
    DefinitionsRemover() {
    }

    static Definition getDefinition(Node node, boolean bl) {
        Node node2 = node.getParent();
        if (node2 == null) {
            return null;
        }
        if (NodeUtil.isVarDeclaration(node) && node.hasChildren()) {
            return new VarDefinition(node, bl);
        }
        if (NodeUtil.isFunction(node2) && node2.getFirstChild() == node) {
            if (!NodeUtil.isFunctionExpression(node2)) {
                return new NamedFunctionDefinition(node2, bl);
            }
            if (!node.getString().equals("")) {
                return new FunctionExpressionDefinition(node2, bl);
            }
        } else {
            if (NodeUtil.isAssign(node2) && node2.getFirstChild() == node) {
                return new AssignmentDefinition(node2, bl);
            }
            if (NodeUtil.isObjectLitKey(node, node2)) {
                return new ObjectLiteralPropertyDefinition(node2, node, node.getFirstChild(), bl);
            }
            if (node2.getType() == 83) {
                Node node3 = node2.getParent();
                return new FunctionArgumentDefinition(node3, node, bl);
            }
        }
        return null;
    }

    static boolean isDefinitionNode(Node node) {
        Node node2 = node.getParent();
        if (node2 == null) {
            return false;
        }
        if (NodeUtil.isVarDeclaration(node) && node.hasChildren()) {
            return true;
        }
        if (NodeUtil.isFunction(node2) && node2.getFirstChild() == node) {
            if (!NodeUtil.isFunctionExpression(node2)) {
                return true;
            }
            if (!node.getString().equals("")) {
                return true;
            }
        } else {
            if (NodeUtil.isAssign(node2) && node2.getFirstChild() == node) {
                return true;
            }
            if (NodeUtil.isObjectLitKey(node, node2)) {
                return true;
            }
            if (node2.getType() == 83) {
                return true;
            }
        }
        return false;
    }

    static final class VarDefinition
    extends Definition {
        private final Node name;

        VarDefinition(Node node, boolean bl) {
            super(bl);
            Preconditions.checkArgument((boolean)NodeUtil.isVarDeclaration(node));
            Preconditions.checkArgument((boolean)node.hasChildren(), (Object)("VAR Declaration of " + node.getString() + "should be assigned a value."));
            this.name = node;
        }

        @Override
        public void performRemove() {
            Node node = this.name.getParent();
            Preconditions.checkState((node.getFirstChild() == node.getLastChild() ? 1 : 0) != 0, (Object)"AST should be normalized first");
            Node node2 = node.getParent();
            Node node3 = this.name.removeFirstChild();
            Preconditions.checkState((node2.getType() != 115 ? 1 : 0) != 0);
            node2.replaceChild(node, NodeUtil.newExpr(node3));
        }

        @Override
        public Node getLValue() {
            return this.name;
        }

        @Override
        public Node getRValue() {
            return this.name.getFirstChild();
        }
    }

    static final class ObjectLiteralPropertyDefinition
    extends Definition {
        private final Node literal;
        private final Node name;
        private final Node value;

        ObjectLiteralPropertyDefinition(Node node, Node node2, Node node3, boolean bl) {
            super(bl);
            this.literal = node;
            this.name = node2;
            this.value = node3;
        }

        @Override
        public void performRemove() {
            this.literal.removeChild(this.name);
        }

        @Override
        public Node getLValue() {
            switch (this.name.getType()) {
                case 40: 
                case 147: 
                case 148: {
                    return new Node(33, new Node(64), this.name.cloneNode());
                }
            }
            throw new IllegalStateException("unexpected");
        }

        @Override
        public Node getRValue() {
            return this.value;
        }
    }

    static final class AssignmentDefinition
    extends Definition {
        private final Node assignment;

        AssignmentDefinition(Node node, boolean bl) {
            super(bl);
            Preconditions.checkArgument((boolean)NodeUtil.isAssign(node));
            this.assignment = node;
        }

        @Override
        public void performRemove() {
            Node node = this.assignment.getParent();
            Node node2 = this.assignment.getLastChild();
            this.assignment.removeChild(node2);
            node.replaceChild(this.assignment, node2);
        }

        @Override
        public Node getLValue() {
            return this.assignment.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.assignment.getLastChild();
        }
    }

    static final class FunctionExpressionDefinition
    extends FunctionDefinition {
        FunctionExpressionDefinition(Node node, boolean bl) {
            super(node, bl);
            Preconditions.checkArgument((boolean)NodeUtil.isFunctionExpression(node));
        }

        @Override
        public void performRemove() {
            this.function.replaceChild(this.function.getFirstChild(), Node.newString(38, ""));
        }
    }

    static final class NamedFunctionDefinition
    extends FunctionDefinition {
        NamedFunctionDefinition(Node node, boolean bl) {
            super(node, bl);
        }

        @Override
        public void performRemove() {
            this.function.detachFromParent();
        }
    }

    static abstract class FunctionDefinition
    extends Definition {
        protected final Node function;

        FunctionDefinition(Node node, boolean bl) {
            super(bl);
            Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
            this.function = node;
        }

        @Override
        public Node getLValue() {
            return this.function.getFirstChild();
        }

        @Override
        public Node getRValue() {
            return this.function;
        }
    }

    static final class FunctionArgumentDefinition
    extends IncompleteDefinition {
        FunctionArgumentDefinition(Node node, Node node2, boolean bl) {
            super(node2, bl);
            Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
            Preconditions.checkArgument((boolean)NodeUtil.isName(node2));
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove a FunctionArgumentDefinition");
        }
    }

    static final class ExternalNameOnlyDefinition
    extends IncompleteDefinition {
        ExternalNameOnlyDefinition(Node node) {
            super(node, true);
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove external name-only definition");
        }
    }

    static final class UnknownDefinition
    extends IncompleteDefinition {
        UnknownDefinition(Node node, boolean bl) {
            super(node, bl);
        }

        @Override
        public void performRemove() {
            throw new IllegalArgumentException("Can't remove an UnknownDefinition");
        }
    }

    static abstract class IncompleteDefinition
    extends Definition {
        private static final Set<Integer> ALLOWED_TYPES = ImmutableSet.of((Object)38, (Object)33, (Object)35);
        private final Node lValue;

        IncompleteDefinition(Node node, boolean bl) {
            super(bl);
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkArgument((boolean)ALLOWED_TYPES.contains(node.getType()), (Object)("Unexpected lValue type " + Token.name(node.getType())));
            this.lValue = node;
        }

        @Override
        public Node getLValue() {
            return this.lValue;
        }

        @Override
        public Node getRValue() {
            return null;
        }
    }

    static abstract class Definition {
        private final boolean isExtern;

        Definition(boolean bl) {
            this.isExtern = bl;
        }

        public void remove() {
            if (this.isExtern) {
                throw new IllegalStateException("Attempt to remove() an extern definition.");
            }
            this.performRemove();
        }

        protected abstract void performRemove();

        public abstract Node getLValue();

        public abstract Node getRValue();

        public boolean isExtern() {
            return this.isExtern;
        }
    }
}

