/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;

public class DiagnosticGroupWarningsGuard
extends WarningsGuard {
    final DiagnosticGroup group;
    final CheckLevel level;

    public DiagnosticGroupWarningsGuard(DiagnosticGroup diagnosticGroup, CheckLevel checkLevel) {
        this.group = diagnosticGroup;
        this.level = checkLevel;
    }

    @Override
    public CheckLevel level(JSError jSError) {
        return this.group.matches(jSError) ? this.level : null;
    }

    @Override
    public boolean disables(DiagnosticGroup diagnosticGroup) {
        return !this.level.isOn() && this.group.isSubGroup(diagnosticGroup);
    }

    @Override
    public boolean enables(DiagnosticGroup diagnosticGroup) {
        if (this.level.isOn()) {
            for (DiagnosticType diagnosticType : diagnosticGroup.getTypes()) {
                if (!this.group.matches(diagnosticType)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.group + "(" + (Object)((Object)this.level) + ")";
    }
}

