/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.LinkedList;
import java.util.List;

class ExtractPrototypeMemberDeclarations
implements CompilerPass {
    private static final int GLOBAL_VAR_DECL_OVERHEAD = "var t;".length();
    private static final int PER_EXTRACTION_INSTANCE_OVERHEAD = "t=y.prototype;".length();
    private static final int PER_PROTOTYPE_MEMBER_DELTA = "t.y=".length() - "x[p].y=".length();
    private String prototypeAlias = "JSCompiler_prototypeAlias";
    private final AbstractCompiler compiler;

    public ExtractPrototypeMemberDeclarations(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        GatherExtractionInfo gatherExtractionInfo = new GatherExtractionInfo();
        NodeTraversal.traverse(this.compiler, node2, gatherExtractionInfo);
        if (gatherExtractionInfo.shouldExtract()) {
            this.doExtraction(gatherExtractionInfo);
            this.compiler.reportCodeChange();
        }
    }

    private void doExtraction(GatherExtractionInfo gatherExtractionInfo) {
        Node node = this.compiler.getNodeForCodeInsertion(null);
        Node node2 = NodeUtil.newVarNode(this.prototypeAlias, null).copyInformationFromForTree(node);
        node.addChildrenToFront(node2);
        for (ExtractionInstance extractionInstance : gatherExtractionInfo.instances) {
            this.extractInstance(extractionInstance);
        }
    }

    private void extractInstance(ExtractionInstance extractionInstance) {
        PrototypeMemberDeclaration prototypeMemberDeclaration = extractionInstance.declarations.getFirst();
        String string = prototypeMemberDeclaration.qualifiedClassName;
        Node node = new Node(prototypeMemberDeclaration.node.getType(), new Node(86, Node.newString(38, this.prototypeAlias), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string + ".prototype", extractionInstance.parent, string + ".prototype"))).copyInformationFromForTree(prototypeMemberDeclaration.node);
        extractionInstance.parent.addChildBefore(node, prototypeMemberDeclaration.node);
        for (PrototypeMemberDeclaration prototypeMemberDeclaration2 : extractionInstance.declarations) {
            this.replacePrototypeMemberDeclaration(prototypeMemberDeclaration2);
        }
    }

    private void replacePrototypeMemberDeclaration(PrototypeMemberDeclaration prototypeMemberDeclaration) {
        Node node = prototypeMemberDeclaration.node.getFirstChild();
        Node node2 = node.getFirstChild();
        Node node3 = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.prototypeAlias + "." + prototypeMemberDeclaration.memberName, prototypeMemberDeclaration.node, prototypeMemberDeclaration.memberName);
        Node node4 = prototypeMemberDeclaration.lhs.getFirstChild().getFirstChild();
        Object object = node4.getProp(40);
        String string = "?";
        if (object != null) {
            string = object.toString();
        }
        NodeUtil.setDebugInformation(node3.getFirstChild(), node2, string + ".prototype");
        node.replaceChild(node2, node3);
    }

    static /* synthetic */ int access$400() {
        return GLOBAL_VAR_DECL_OVERHEAD;
    }

    private static class PrototypeMemberDeclaration {
        final String memberName;
        final Node node;
        final String qualifiedClassName;
        final Node lhs;

        private PrototypeMemberDeclaration(Node node, Node node2) {
            this.lhs = node;
            this.memberName = NodeUtil.getPrototypePropertyName(node);
            this.node = node2;
            this.qualifiedClassName = NodeUtil.getPrototypeClassName(node).getQualifiedName();
        }

        private boolean isSameClass(PrototypeMemberDeclaration prototypeMemberDeclaration) {
            return this.qualifiedClassName.equals(prototypeMemberDeclaration.qualifiedClassName);
        }

        private static PrototypeMemberDeclaration extractDeclaration(Node node) {
            if (!NodeUtil.isPrototypePropertyDeclaration(node)) {
                return null;
            }
            Node node2 = node.getFirstChild().getFirstChild();
            return new PrototypeMemberDeclaration(node2, node);
        }
    }

    private static class ExtractionInstance {
        LinkedList<PrototypeMemberDeclaration> declarations = Lists.newLinkedList();
        private int delta = 0;
        private final Node parent;

        private ExtractionInstance(PrototypeMemberDeclaration prototypeMemberDeclaration, Node node) {
            this.parent = node;
            this.declarations.add(prototypeMemberDeclaration);
            this.delta = PER_EXTRACTION_INSTANCE_OVERHEAD + PER_PROTOTYPE_MEMBER_DELTA;
            for (Node node2 = prototypeMemberDeclaration.node.getNext(); node2 != null; node2 = node2.getNext()) {
                if (NodeUtil.isFunction(node2)) continue;
                PrototypeMemberDeclaration prototypeMemberDeclaration2 = PrototypeMemberDeclaration.extractDeclaration(node2);
                if (prototypeMemberDeclaration2 == null || !prototypeMemberDeclaration.isSameClass(prototypeMemberDeclaration2)) break;
                this.declarations.add(prototypeMemberDeclaration2);
                this.delta += PER_PROTOTYPE_MEMBER_DELTA;
            }
        }

        boolean isFavorable() {
            return this.delta <= 0;
        }
    }

    private class GatherExtractionInfo
    extends NodeTraversal.AbstractShallowCallback {
        private List<ExtractionInstance> instances = Lists.newLinkedList();
        private int totalDelta = ExtractPrototypeMemberDeclarations.access$400();

        private GatherExtractionInfo() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 132 && node.getType() != 125) {
                return;
            }
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                PrototypeMemberDeclaration prototypeMemberDeclaration = PrototypeMemberDeclaration.extractDeclaration(node3);
                if (prototypeMemberDeclaration == null) continue;
                ExtractionInstance extractionInstance = new ExtractionInstance(prototypeMemberDeclaration, node);
                node3 = extractionInstance.declarations.getLast().node;
                if (!extractionInstance.isFavorable()) continue;
                this.instances.add(extractionInstance);
                this.totalDelta += extractionInstance.delta;
            }
        }

        private boolean shouldExtract() {
            return this.totalDelta < 0;
        }
    }
}

