/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalNamespace {
    private AbstractCompiler compiler;
    private final Node root;
    private final Node externsRoot;
    private boolean inExterns;
    private Scope externsScope;
    private boolean generated = false;
    private List<Name> globalNames = new ArrayList<Name>();
    private Map<String, Name> nameMap = new HashMap<String, Name>();

    GlobalNamespace(AbstractCompiler abstractCompiler, Node node) {
        this(abstractCompiler, null, node);
    }

    GlobalNamespace(AbstractCompiler abstractCompiler, Node node, Node node2) {
        this.compiler = abstractCompiler;
        this.externsRoot = node;
        this.root = node2;
    }

    List<Name> getNameForest() {
        if (!this.generated) {
            this.process();
        }
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        if (!this.generated) {
            this.process();
        }
        return this.nameMap;
    }

    void scanNewNodes(Scope scope, Set<Node> set) {
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, new BuildGlobalNamespace(new NodeFilter(set)));
        nodeTraversal.traverseAtScope(scope);
    }

    private void process() {
        if (this.externsRoot != null) {
            this.inExterns = true;
            NodeTraversal.traverse(this.compiler, this.externsRoot, new BuildGlobalNamespace());
        }
        this.inExterns = false;
        NodeTraversal.traverse(this.compiler, this.root, new BuildGlobalNamespace());
        this.generated = true;
    }

    private boolean isGlobalNameReference(String string, Scope scope) {
        String string2 = this.getTopVarName(string);
        return this.isGlobalVarReference(string2, scope);
    }

    private String getTopVarName(String string) {
        int n = string.indexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    private boolean isGlobalVarReference(String string, Scope scope) {
        Scope.Var var = scope.getVar(string);
        if (var == null && this.externsScope != null) {
            var = this.externsScope.getVar(string);
        }
        return var != null && !var.isLocal();
    }

    private boolean isGlobalScope(Scope scope) {
        return scope.getParent() == null;
    }

    static class Ref {
        Node node;
        final Type type;
        final CompilerInput source;
        final Scope scope;
        private Ref twin = null;

        Ref(NodeTraversal nodeTraversal, Node node, Type type) {
            this.node = node;
            this.source = nodeTraversal.getInput();
            this.type = type;
            this.scope = nodeTraversal.getScope();
        }

        private Ref(Ref ref, Type type) {
            this.node = ref.node;
            this.source = ref.source;
            this.type = type;
            this.scope = ref.scope;
        }

        private Ref(Type type) {
            this.type = type;
            this.source = null;
            this.scope = null;
        }

        JSModule getModule() {
            return this.source == null ? null : this.source.getModule();
        }

        String getSourceName() {
            return this.source == null ? "" : this.source.getName();
        }

        Ref getTwin() {
            return this.twin;
        }

        boolean isSet() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.SET_FROM_LOCAL;
        }

        static void markTwins(Ref ref, Ref ref2) {
            Preconditions.checkArgument((!(ref.type != Type.ALIASING_GET && ref2.type != Type.ALIASING_GET || ref.type != Type.SET_FROM_GLOBAL && ref.type != Type.SET_FROM_LOCAL && ref2.type != Type.SET_FROM_GLOBAL && ref2.type != Type.SET_FROM_LOCAL) ? 1 : 0) != 0);
            ref.twin = ref2;
            ref2.twin = ref;
        }

        Ref cloneAndReclassify(Type type) {
            return new Ref(this, type);
        }

        static Ref createRefForTesting(Type type) {
            return new Ref(type);
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET;

        }
    }

    static class Name {
        final String name;
        final Name parent;
        List<Name> props;
        Ref declaration;
        private List<Ref> refs;
        Type type;
        private boolean isClassOrEnum = false;
        private boolean hasClassOrEnumDescendant = false;
        int globalSets = 0;
        int localSets = 0;
        int aliasingGets = 0;
        int totalGets = 0;
        int callGets = 0;
        boolean inExterns;
        JSDocInfo docInfo = null;

        Name(String string, Name name, boolean bl) {
            this.name = string;
            this.parent = name;
            this.type = Type.OTHER;
            this.inExterns = bl;
        }

        Name addProperty(String string, boolean bl) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name name = new Name(string, this, bl);
            this.props.add(name);
            return name;
        }

        void addRef(Ref ref) {
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                        this.docInfo = Name.getDocInfoForDeclaration(ref);
                    }
                    this.addRefInternal(ref);
                    ++this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    this.addRefInternal(ref);
                    ++this.localSets;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    this.addRefInternal(ref);
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    this.addRefInternal(ref);
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    this.addRefInternal(ref);
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        void removeRef(Ref ref) {
            if (this.refs != null && this.refs.remove(ref)) {
                if (ref == this.declaration) {
                    this.declaration = null;
                    if (this.refs != null) {
                        for (Ref ref2 : this.refs) {
                            if (ref2.type != Ref.Type.SET_FROM_GLOBAL) continue;
                            this.declaration = ref2;
                            break;
                        }
                    }
                }
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        --this.globalSets;
                        break;
                    }
                    case SET_FROM_LOCAL: {
                        --this.localSets;
                        break;
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: {
                        --this.totalGets;
                        break;
                    }
                    case ALIASING_GET: {
                        --this.aliasingGets;
                        --this.totalGets;
                        break;
                    }
                    case CALL_GET: {
                        --this.callGets;
                        --this.totalGets;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        List<Ref> getRefs() {
            return this.refs == null ? ImmutableList.of() : this.refs;
        }

        void addRefInternal(Ref ref) {
            if (this.refs == null) {
                this.refs = Lists.newArrayList();
            }
            this.refs.add(ref);
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name name : this.props) {
                    if (name.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean canCollapse() {
            return !(this.inExterns || this.isGetOrSetDefinition() || !this.isClassOrEnum && (this.parent != null && !this.parent.canCollapseUnannotatedChildNames() || this.globalSets <= 0 && this.localSets <= 0));
        }

        boolean isGetOrSetDefinition() {
            return this.type == Type.GET || this.type == Type.SET;
        }

        boolean canCollapseUnannotatedChildNames() {
            if (this.type == Type.OTHER || this.isGetOrSetDefinition() || this.globalSets != 1 || this.localSets != 0) {
                return false;
            }
            Preconditions.checkNotNull((Object)this.declaration);
            if (this.declaration.getTwin() != null) {
                return false;
            }
            if (this.isClassOrEnum) {
                return true;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                return false;
            }
            if (this.aliasingGets > 0) {
                return false;
            }
            return this.parent == null || this.parent.canCollapseUnannotatedChildNames();
        }

        boolean shouldKeepKeys() {
            return this.type == Type.OBJECTLIT && this.aliasingGets > 0;
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0;
        }

        void setIsClassOrEnum() {
            this.isClassOrEnum = true;
            Name name = this.parent;
            while (name != null) {
                name.hasClassOrEnumDescendant = true;
                name = name.parent;
            }
        }

        boolean isNamespace() {
            return this.hasClassOrEnumDescendant && this.type == Type.OBJECTLIT;
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        public String toString() {
            return this.fullName() + " (" + (Object)((Object)this.type) + "): globalSets=" + this.globalSets + ", localSets=" + this.localSets + ", totalGets=" + this.totalGets + ", aliasingGets=" + this.aliasingGets + ", callGets=" + this.callGets;
        }

        String fullName() {
            return this.parent == null ? this.name : this.parent.fullName() + '.' + this.name;
        }

        private static JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node node = ref.node.getParent();
                switch (node.getType()) {
                    case 86: 
                    case 105: {
                        return node.getJSDocInfo();
                    }
                    case 118: {
                        return ref.node == node.getFirstChild() ? node.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        static enum Type {
            OBJECTLIT,
            FUNCTION,
            GET,
            SET,
            OTHER;

        }
    }

    private class BuildGlobalNamespace
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Predicate<Node> nodeFilter;

        BuildGlobalNamespace() {
            this(null);
        }

        BuildGlobalNamespace(Predicate<Node> predicate) {
            this.nodeFilter = predicate;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object object;
            String string;
            if (this.nodeFilter != null && !this.nodeFilter.apply((Object)node)) {
                return;
            }
            if (GlobalNamespace.this.externsRoot != null && node == GlobalNamespace.this.externsRoot) {
                GlobalNamespace.this.externsScope = nodeTraversal.getScope();
            }
            boolean bl = false;
            Name.Type type = Name.Type.OTHER;
            boolean bl2 = false;
            block0 : switch (node.getType()) {
                case 40: 
                case 147: 
                case 148: {
                    string = null;
                    if (node2 != null && node2.getType() == 64) {
                        string = this.getNameForObjLitKey(node);
                    }
                    if (string == null) {
                        return;
                    }
                    bl = true;
                    switch (node.getType()) {
                        case 40: {
                            type = this.getValueType(node.getFirstChild());
                            break block0;
                        }
                        case 147: {
                            type = Name.Type.GET;
                            break block0;
                        }
                        case 148: {
                            type = Name.Type.SET;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("unexpected:" + node);
                }
                case 38: {
                    if (node2 != null) {
                        switch (node2.getType()) {
                            case 118: {
                                bl = true;
                                object = node.getFirstChild();
                                type = object == null ? Name.Type.OTHER : this.getValueType((Node)object);
                                break;
                            }
                            case 86: {
                                if (node2.getFirstChild() != node) break;
                                bl = true;
                                type = this.getValueType(node.getNext());
                                break;
                            }
                            case 33: {
                                return;
                            }
                            case 105: {
                                Node node3 = node2.getParent();
                                if (node3 == null || NodeUtil.isFunctionExpression(node2)) {
                                    return;
                                }
                                bl = true;
                                type = Name.Type.FUNCTION;
                            }
                        }
                    }
                    string = node.getString();
                    break;
                }
                case 33: {
                    if (node2 != null) {
                        switch (node2.getType()) {
                            case 86: {
                                if (node2.getFirstChild() != node) break;
                                bl = true;
                                type = this.getValueType(node.getNext());
                                bl2 = true;
                                break;
                            }
                            case 33: {
                                return;
                            }
                        }
                    }
                    if ((string = node.getQualifiedName()) != null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            object = nodeTraversal.getScope();
            if (!GlobalNamespace.this.isGlobalNameReference(string, (Scope)object)) {
                return;
            }
            if (bl) {
                if (GlobalNamespace.this.isGlobalScope((Scope)object)) {
                    this.handleSetFromGlobal(nodeTraversal, node, node2, string, bl2, type);
                } else {
                    this.handleSetFromLocal(nodeTraversal, node, node2, string);
                }
            } else {
                this.handleGet(nodeTraversal, node, node2, string);
            }
        }

        String getNameForObjLitKey(Node node) {
            Object object;
            String string;
            Node node2 = node.getParent();
            Preconditions.checkState((node2.getType() == 64 ? 1 : 0) != 0);
            Node node3 = node2.getParent();
            if (node3 == null) {
                return null;
            }
            Node node4 = node3.getParent();
            switch (node3.getType()) {
                case 38: {
                    if (node4 == null || node4.getType() != 118) {
                        return null;
                    }
                    string = node3.getString();
                    break;
                }
                case 86: {
                    object = node3.getFirstChild();
                    string = ((Node)object).getQualifiedName();
                    break;
                }
                case 40: {
                    if (node4 != null && node4.getType() == 64) {
                        string = this.getNameForObjLitKey(node3);
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (string != null && TokenStream.isJSIdentifier((String)(object = node.getString()))) {
                return string + '.' + (String)object;
            }
            return null;
        }

        Name.Type getValueType(Node node) {
            switch (node.getType()) {
                case 64: {
                    return Name.Type.OBJECTLIT;
                }
                case 105: {
                    return Name.Type.FUNCTION;
                }
                case 100: {
                    return this.getValueType(node.getLastChild());
                }
                case 98: {
                    Node node2 = node.getFirstChild().getNext();
                    Name.Type type = this.getValueType(node2);
                    if (type != Name.Type.OTHER) {
                        return type;
                    }
                    Node node3 = node2.getNext();
                    return this.getValueType(node3);
                }
            }
            return Name.Type.OTHER;
        }

        void handleSetFromGlobal(NodeTraversal nodeTraversal, Node node, Node node2, String string, boolean bl, Name.Type type) {
            if (this.maybeHandlePrototypePrefix(nodeTraversal, node, node2, string)) {
                return;
            }
            Name name = this.getOrCreateName(string);
            name.type = type;
            Ref ref = new Ref(nodeTraversal, node, Ref.Type.SET_FROM_GLOBAL);
            name.addRef(ref);
            if (this.isNestedAssign(node2)) {
                Ref ref2 = new Ref(nodeTraversal, node, Ref.Type.ALIASING_GET);
                name.addRef(ref2);
                Ref.markTwins(ref, ref2);
            } else if (this.isConstructorOrEnumDeclaration(node, node2)) {
                name.setIsClassOrEnum();
            }
        }

        private boolean isConstructorOrEnumDeclaration(Node node, Node node2) {
            int n;
            JSDocInfo jSDocInfo;
            switch (node2.getType()) {
                case 86: {
                    jSDocInfo = node2.getJSDocInfo();
                    n = node.getNext().getType();
                    break;
                }
                case 118: {
                    Node node3;
                    jSDocInfo = node.getJSDocInfo();
                    if (jSDocInfo == null) {
                        jSDocInfo = node2.getJSDocInfo();
                    }
                    n = (node3 = node.getFirstChild()) != null ? node3.getType() : 122;
                    break;
                }
                default: {
                    if (NodeUtil.isFunctionDeclaration(node2)) {
                        jSDocInfo = node2.getJSDocInfo();
                        n = 105;
                        break;
                    }
                    return false;
                }
            }
            return jSDocInfo != null && (jSDocInfo.isConstructor() && n == 105 || jSDocInfo.hasEnumParameterType() && n == 64);
        }

        void handleSetFromLocal(NodeTraversal nodeTraversal, Node node, Node node2, String string) {
            if (this.maybeHandlePrototypePrefix(nodeTraversal, node, node2, string)) {
                return;
            }
            Name name = this.getOrCreateName(string);
            Ref ref = new Ref(nodeTraversal, node, Ref.Type.SET_FROM_LOCAL);
            name.addRef(ref);
            if (this.isNestedAssign(node2)) {
                Ref ref2 = new Ref(nodeTraversal, node, Ref.Type.ALIASING_GET);
                name.addRef(ref2);
                Ref.markTwins(ref, ref2);
            }
        }

        void handleGet(NodeTraversal nodeTraversal, Node node, Node node2, String string) {
            if (this.maybeHandlePrototypePrefix(nodeTraversal, node, node2, string)) {
                return;
            }
            Ref.Type type = Ref.Type.DIRECT_GET;
            if (node2 != null) {
                switch (node2.getType()) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 32: 
                    case 108: 
                    case 122: {
                        break;
                    }
                    case 37: {
                        type = node == node2.getFirstChild() ? Ref.Type.CALL_GET : Ref.Type.ALIASING_GET;
                        break;
                    }
                    case 30: {
                        type = node == node2.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                        break;
                    }
                    case 100: 
                    case 101: {
                        type = this.determineGetTypeForHookOrBooleanExpr(nodeTraversal, node2, string);
                        break;
                    }
                    case 98: {
                        if (node == node2.getFirstChild()) break;
                        type = this.determineGetTypeForHookOrBooleanExpr(nodeTraversal, node2, string);
                        break;
                    }
                    default: {
                        type = Ref.Type.ALIASING_GET;
                    }
                }
            }
            this.handleGet(nodeTraversal, node, node2, string, type);
        }

        Ref.Type determineGetTypeForHookOrBooleanExpr(NodeTraversal nodeTraversal, Node node, String string) {
            Node node2 = node;
            for (Node node3 : node.getAncestors()) {
                switch (node3.getType()) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 32: 
                    case 108: 
                    case 113: 
                    case 115: 
                    case 118: 
                    case 122: 
                    case 130: {
                        return Ref.Type.DIRECT_GET;
                    }
                    case 98: {
                        if (node3.getFirstChild() != node2) break;
                        return Ref.Type.DIRECT_GET;
                    }
                    case 86: {
                        if (string.equals(node3.getFirstChild().getQualifiedName())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case 38: {
                        if (string.equals(node3.getString())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case 37: {
                        if (node3.getFirstChild() == node2) break;
                        return Ref.Type.ALIASING_GET;
                    }
                }
                node2 = node3;
            }
            return Ref.Type.ALIASING_GET;
        }

        void handleGet(NodeTraversal nodeTraversal, Node node, Node node2, String string, Ref.Type type) {
            Name name = this.getOrCreateName(string);
            name.addRef(new Ref(nodeTraversal, node, type));
        }

        boolean maybeHandlePrototypePrefix(NodeTraversal nodeTraversal, Node node, Node node2, String string) {
            int n;
            String string2;
            int n2;
            if (string.endsWith(".prototype")) {
                n2 = 1;
                string2 = string.substring(0, string.length() - 10);
            } else {
                n = string.indexOf(".prototype.");
                if (n == -1) {
                    return false;
                }
                string2 = string.substring(0, n);
                n2 = 2;
                n = string.indexOf(46, n + 11);
                while (n >= 0) {
                    ++n2;
                    n = string.indexOf(46, n + 1);
                }
            }
            if (node2 != null && NodeUtil.isObjectLitKey(node, node2)) {
                return true;
            }
            for (n = 0; n < n2; ++n) {
                node2 = node;
                node = node.getFirstChild();
            }
            this.handleGet(nodeTraversal, node, node2, string2, Ref.Type.PROTOTYPE_GET);
            return true;
        }

        boolean isNestedAssign(Node node) {
            return node.getType() == 86 && !NodeUtil.isExpressionNode(node.getParent());
        }

        Name getOrCreateName(String string) {
            Name name = (Name)GlobalNamespace.this.nameMap.get(string);
            if (name == null) {
                int n = string.lastIndexOf(46);
                if (n >= 0) {
                    String string2 = string.substring(0, n);
                    Name name2 = this.getOrCreateName(string2);
                    name = name2.addProperty(string.substring(n + 1), GlobalNamespace.this.inExterns);
                } else {
                    name = new Name(string, null, GlobalNamespace.this.inExterns);
                    GlobalNamespace.this.globalNames.add(name);
                }
                GlobalNamespace.this.nameMap.put(string, name);
            }
            return name;
        }
    }

    private static class NodeFilter
    implements Predicate<Node> {
        private final Set<Node> newNodes;

        NodeFilter(Set<Node> set) {
            this.newNodes = set;
        }

        public boolean apply(Node node) {
            if (!node.isQualifiedName()) {
                return false;
            }
            Node node2 = node;
            while (node2.getType() == 33) {
                if (this.newNodes.contains(node2)) {
                    return true;
                }
                node2 = node2.getFirstChild();
            }
            return node2.getType() == 38 && this.newNodes.contains(node2);
        }
    }
}

