/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

class MarkNoSideEffectCalls
implements CompilerPass {
    static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    private final AbstractCompiler compiler;
    private final Set<Node> noSideEffectFunctionNames;

    MarkNoSideEffectCalls(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.noSideEffectFunctionNames = Sets.newHashSet();
    }

    @Override
    public void process(Node node, Node node2) {
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        NodeTraversal.traverse(this.compiler, node, new GatherNoSideEffectFunctions(true));
        NodeTraversal.traverse(this.compiler, node2, new GatherNoSideEffectFunctions(false));
        NodeTraversal.traverse(this.compiler, node2, new SetNoSideEffectCallProperty(simpleDefinitionFinder));
    }

    private static boolean definitionTypeContainsFunctionType(DefinitionsRemover.Definition definition) {
        Node node = definition.getRValue();
        if (node == null) {
            return true;
        }
        switch (node.getType()) {
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 86: 
            case 98: 
            case 100: 
            case 101: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNoSideEffectsAnnotation(Node node) {
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        return jSDocInfo != null && jSDocInfo.isNoSideEffects();
    }

    private class SetNoSideEffectCallProperty
    extends NodeTraversal.AbstractPostOrderCallback {
        private final SimpleDefinitionFinder defFinder;

        SetNoSideEffectCallProperty(SimpleDefinitionFinder simpleDefinitionFinder) {
            this.defFinder = simpleDefinitionFinder;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!NodeUtil.isCall(node) && !NodeUtil.isNew(node)) {
                return;
            }
            Collection<DefinitionsRemover.Definition> collection = this.defFinder.getDefinitionsReferencedAt(node.getFirstChild());
            if (collection == null) {
                return;
            }
            for (DefinitionsRemover.Definition definition : collection) {
                Node node3 = definition.getLValue();
                Preconditions.checkNotNull((Object)node3);
                if (MarkNoSideEffectCalls.this.noSideEffectFunctionNames.contains(node3) || !MarkNoSideEffectCalls.definitionTypeContainsFunctionType(definition)) continue;
                return;
            }
            node.setSideEffectFlags(15);
        }
    }

    private class GatherNoSideEffectFunctions
    extends NodeTraversal.AbstractPostOrderCallback {
        private final boolean inExterns;

        GatherNoSideEffectFunctions(boolean bl) {
            this.inExterns = bl;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!this.inExterns && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node)) {
                nodeTraversal.report(node, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
            }
            if (NodeUtil.isGetProp(node)) {
                if (NodeUtil.isExpressionNode(node2) && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node)) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.add(node);
                }
            } else if (NodeUtil.isFunction(node)) {
                boolean bl = MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node);
                ArrayList arrayList = Lists.newArrayList();
                arrayList.add(node.getFirstChild());
                Object var6_6 = null;
                if (NodeUtil.isName(node2)) {
                    Node node3 = node2.getParent();
                    if (NodeUtil.isVar(node3) && node3.hasOneChild() && MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node3)) {
                        bl = true;
                    }
                    arrayList.add(node2);
                } else if (NodeUtil.isAssign(node2)) {
                    if (MarkNoSideEffectCalls.hasNoSideEffectsAnnotation(node2)) {
                        bl = true;
                    }
                    arrayList.add(node2.getFirstChild());
                }
                if (bl) {
                    MarkNoSideEffectCalls.this.noSideEffectFunctionNames.addAll(arrayList);
                }
            }
        }
    }
}

