/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class OptimizeParameters
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private List<Node> removedNodes = Lists.newArrayList();

    OptimizeParameters(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node node, Node node2) {
        Preconditions.checkState((this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED ? 1 : 0) != 0);
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        this.process(node, node2, simpleDefinitionFinder);
    }

    @Override
    public void process(Node node, Node node2, SimpleDefinitionFinder simpleDefinitionFinder) {
        for (DefinitionSite object : simpleDefinitionFinder.getDefinitionSites()) {
            if (!this.canChangeSignature(object, simpleDefinitionFinder)) continue;
            this.tryEliminateConstantArgs(object, simpleDefinitionFinder);
            this.tryEliminateOptionalArgs(object, simpleDefinitionFinder);
        }
        for (Node node3 : this.removedNodes) {
            simpleDefinitionFinder.removeReferences(node3);
        }
    }

    private boolean canChangeSignature(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        if (definitionSite.inExterns) {
            return false;
        }
        Node node = definition.getRValue();
        if (node == null || !NodeUtil.isFunction(node) || NodeUtil.isVarArgsFunction(node)) {
            return false;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(node)) {
            return false;
        }
        if (!simpleDefinitionFinder.canModifyDefinition(definition)) {
            return false;
        }
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        if (collection.isEmpty()) {
            return false;
        }
        for (UseSite useSite : collection) {
            if (!SimpleDefinitionFinder.isCallOrNewSite(useSite)) {
                return false;
            }
            Node node2 = useSite.node;
            Collection<DefinitionsRemover.Definition> collection2 = simpleDefinitionFinder.getDefinitionsReferencedAt(node2);
            if (collection2.size() > 1) {
                return false;
            }
            Preconditions.checkState((!collection2.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)collection2.contains(definition));
        }
        return true;
    }

    private void tryEliminateOptionalArgs(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        int n = -1;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            Node node = useSite.node.getParent();
            int n2 = node.getChildCount() - 1;
            if (n2 <= n) continue;
            n = n2;
        }
        this.eliminateParamsAfter(definition.getRValue(), n);
    }

    private void tryEliminateConstantArgs(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        Node node;
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = true;
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        boolean bl2 = false;
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            node = useSite.node.getParent();
            Node node2 = node.getFirstChild();
            if (bl) {
                bl2 = this.buildParameterList(arrayList, node2, useSite.scope);
                bl = false;
            } else {
                bl2 = this.findFixedParameters(arrayList, node2);
            }
            if (bl2) continue;
            return;
        }
        bl2 = this.adjustForSideEffects(arrayList);
        if (!bl2) {
            return;
        }
        for (UseSite useSite : collection) {
            Preconditions.checkState((boolean)SimpleDefinitionFinder.isCallOrNewSite(useSite));
            node = useSite.node.getParent();
            this.optimizeCallSite(simpleDefinitionFinder, arrayList, node);
        }
        Node node3 = definition.getRValue();
        if (NodeUtil.isFunction(node3)) {
            this.optimizeFunctionDefinition(arrayList, node3);
        }
    }

    private boolean adjustForSideEffects(List<Parameter> list) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            Parameter parameter = list.get(i);
            if (parameter.shouldRemove && (bl2 && parameter.canBeSideEffected() || bl3 && parameter.hasSideEffects())) {
                parameter.shouldRemove = false;
            }
            if (parameter.shouldRemove) {
                bl = true;
                continue;
            }
            if (parameter.canBeSideEffected) {
                bl3 = true;
            }
            if (!parameter.hasSideEffects) continue;
            bl2 = true;
        }
        return bl;
    }

    private boolean findFixedParameters(List<Parameter> list, Node node) {
        boolean bl = false;
        int n = 0;
        while ((node = node.getNext()) != null) {
            Parameter parameter;
            if (n >= list.size()) {
                parameter = new Parameter(node, false);
                list.add(parameter);
            } else {
                parameter = list.get(n);
                if (parameter.shouldRemove()) {
                    Node node2 = parameter.getArg();
                    if (!node.isEquivalentTo(node2)) {
                        parameter.setShouldRemove(false);
                    } else {
                        bl = true;
                    }
                }
            }
            this.setParameterSideEffectInfo(parameter, node);
            ++n;
        }
        while (n < list.size()) {
            list.get(n).setShouldRemove(false);
            ++n;
        }
        return bl;
    }

    private boolean buildParameterList(List<Parameter> list, Node node, Scope scope) {
        boolean bl = false;
        while ((node = node.getNext()) != null) {
            boolean bl2 = this.isMovableValue(node, scope);
            Parameter parameter = new Parameter(node, bl2);
            this.setParameterSideEffectInfo(parameter, node);
            list.add(parameter);
            if (!bl2) continue;
            bl = true;
        }
        return bl;
    }

    private void setParameterSideEffectInfo(Parameter parameter, Node node) {
        if (!parameter.hasSideEffects()) {
            parameter.setHasSideEffects(NodeUtil.mayHaveSideEffects(node, this.compiler));
        }
        if (!parameter.canBeSideEffected()) {
            parameter.setCanBeSideEffected(NodeUtil.canBeSideEffected(node));
        }
    }

    private boolean isMovableValue(Node node, Scope scope) {
        Object object;
        switch (node.getType()) {
            case 42: {
                return false;
            }
            case 105: {
                return false;
            }
            case 38: {
                if (node.getString().equals("arguments")) {
                    return false;
                }
                object = scope.getVar(node.getString());
                if (object == null || !((Scope.Var)object).isLocal()) break;
                return false;
            }
        }
        for (object = node.getFirstChild(); object != null; object = ((Node)object).getNext()) {
            if (this.isMovableValue((Node)object, scope)) continue;
            return false;
        }
        return true;
    }

    private void optimizeFunctionDefinition(List<Parameter> list, Node node) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node2;
            if (!list.get(i).shouldRemove() || (node2 = this.eliminateFunctionParamAt(node, i)) == null) continue;
            this.addVariableToFunction(node, node2, list.get(i).getArg());
        }
    }

    private void optimizeCallSite(SimpleDefinitionFinder simpleDefinitionFinder, List<Parameter> list, Node node) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Parameter parameter = list.get(i);
            if (!parameter.shouldRemove()) continue;
            this.eliminateCallParamAt(simpleDefinitionFinder, parameter, node, i);
        }
    }

    private void addVariableToFunction(Node node, Node node2, Node node3) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node), (Object)"Node must be a function.");
        Node node4 = node.getLastChild();
        Preconditions.checkArgument((node4.getType() == 125 ? 1 : 0) != 0, (Object)"Node must be a block.");
        Preconditions.checkState((node3.getParent() == null ? 1 : 0) != 0);
        Node node5 = NodeUtil.newVarNode(node2.getString(), node3);
        node4.addChildToFront(node5);
        this.compiler.reportCodeChange();
    }

    private boolean eliminateParamsAfter(Node node, int n) {
        Node node2;
        boolean bl = false;
        for (node2 = node.getFirstChild().getNext().getFirstChild(); n != 0 && node2 != null; node2 = node2.getNext(), --n) {
        }
        return this.eliminateParamsAfter(node, node2);
    }

    private boolean eliminateParamsAfter(Node node, Node node2) {
        if (node2 != null) {
            this.eliminateParamsAfter(node, node2.getNext());
            node2.detachFromParent();
            Node node3 = new Node(118, node2).copyInformationFrom(node2);
            node.getLastChild().addChildrenToFront(node3);
            this.compiler.reportCodeChange();
            return true;
        }
        return false;
    }

    private Node eliminateFunctionParamAt(Node node, int n) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node), (Object)"Node must be a function.");
        Node node2 = NodeUtil.getArgumentForFunction(node, n);
        if (node2 != null) {
            node.getFirstChild().getNext().removeChild(node2);
        }
        return node2;
    }

    private Node eliminateCallParamAt(SimpleDefinitionFinder simpleDefinitionFinder, Parameter parameter, Node node, int n) {
        Preconditions.checkArgument((boolean)NodeUtil.isCallOrNew(node), (Object)"Node must be a call or new.");
        Node node2 = NodeUtil.getArgumentForCallOrNew(node, n);
        if (node2 != null) {
            node.removeChild(node2);
            if (parameter.getArg() != node2) {
                this.removedNodes.add(node2);
            }
            this.compiler.reportCodeChange();
        }
        return node2;
    }

    private static class Parameter {
        private final Node arg;
        private boolean shouldRemove;
        private boolean hasSideEffects;
        private boolean canBeSideEffected;

        public Parameter(Node node, boolean bl) {
            this.shouldRemove = bl;
            this.arg = node;
        }

        public Node getArg() {
            return this.arg;
        }

        public boolean shouldRemove() {
            return this.shouldRemove;
        }

        public void setShouldRemove(boolean bl) {
            this.shouldRemove = bl;
        }

        public void setHasSideEffects(boolean bl) {
            this.hasSideEffects = bl;
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void setCanBeSideEffected(boolean bl) {
            this.canBeSideEffected = bl;
        }

        public boolean canBeSideEffected() {
            return this.canBeSideEffected;
        }
    }
}

