/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReferenceCollectingCallback
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final Map<Scope.Var, ReferenceCollection> referenceMap = Maps.newHashMap();
    private final Deque<BasicBlock> blockStack = new ArrayDeque<BasicBlock>();
    private final Behavior behavior;
    private final AbstractCompiler compiler;
    private final Predicate<Scope.Var> varFilter;
    static Behavior DO_NOTHING_BEHAVIOR = new Behavior(){

        @Override
        public void afterExitScope(NodeTraversal nodeTraversal, Map<Scope.Var, ReferenceCollection> map) {
        }
    };

    ReferenceCollectingCallback(AbstractCompiler abstractCompiler, Behavior behavior) {
        this(abstractCompiler, behavior, (Predicate<Scope.Var>)Predicates.alwaysTrue());
    }

    ReferenceCollectingCallback(AbstractCompiler abstractCompiler, Behavior behavior, Predicate<Scope.Var> predicate) {
        this.compiler = abstractCompiler;
        this.behavior = behavior;
        this.varFilter = predicate;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    public Set<Scope.Var> getReferencedVariables() {
        return this.referenceMap.keySet();
    }

    public ReferenceCollection getReferenceCollection(Scope.Var var) {
        return this.referenceMap.get(var);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        Scope.Var var;
        if (node.getType() == 38 && (var = node.getString().equals("arguments") ? nodeTraversal.getScope().getArgumentsVar() : nodeTraversal.getScope().getVar(node.getString())) != null && this.varFilter.apply((Object)var)) {
            this.addReference(nodeTraversal, var, new Reference(node, node2, nodeTraversal, this.blockStack.peek()));
        }
        if (ReferenceCollectingCallback.isBlockBoundary(node, node2)) {
            this.blockStack.pop();
        }
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Node node = nodeTraversal.getScope().getRootNode();
        BasicBlock basicBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        this.blockStack.push(new BasicBlock(basicBlock, node));
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        this.blockStack.pop();
        this.behavior.afterExitScope(nodeTraversal, this.referenceMap);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (ReferenceCollectingCallback.isBlockBoundary(node, node2)) {
            this.blockStack.push(new BasicBlock(this.blockStack.peek(), node));
        }
        return true;
    }

    private static boolean isBlockBoundary(Node node, Node node2) {
        if (node2 != null) {
            switch (node2.getType()) {
                case 77: 
                case 113: 
                case 114: 
                case 115: 
                case 119: {
                    return true;
                }
                case 98: 
                case 100: 
                case 101: 
                case 108: {
                    return node != node2.getFirstChild();
                }
            }
        }
        return node.getType() == 111;
    }

    private void addReference(NodeTraversal nodeTraversal, Scope.Var var, Reference reference) {
        ReferenceCollection referenceCollection = this.referenceMap.get(var);
        if (referenceCollection == null) {
            referenceCollection = new ReferenceCollection();
            this.referenceMap.put(var, referenceCollection);
        }
        referenceCollection.add(reference, nodeTraversal, var);
    }

    static final class BasicBlock {
        private final BasicBlock parent;
        private final boolean isHoisted;
        private final boolean isFunction;
        private final boolean isLoop;

        BasicBlock(BasicBlock basicBlock, Node node) {
            int n;
            this.parent = basicBlock;
            this.isHoisted = NodeUtil.isHoistedFunctionDeclaration(node);
            boolean bl = this.isFunction = node.getType() == 105;
            this.isLoop = node.getParent() != null ? (n = node.getParent().getType()) == 114 || n == 113 || n == 115 : false;
        }

        BasicBlock getParent() {
            return this.parent;
        }

        boolean provablyExecutesBefore(BasicBlock basicBlock) {
            BasicBlock basicBlock2;
            for (basicBlock2 = basicBlock; basicBlock2 != null && basicBlock2 != this; basicBlock2 = basicBlock2.getParent()) {
                if (!basicBlock2.isHoisted) continue;
                return false;
            }
            return basicBlock2 == this;
        }
    }

    static final class Reference {
        private static final Set<Integer> DECLARATION_PARENTS = ImmutableSet.of((Object)118, (Object)105, (Object)120);
        private final Node nameNode;
        private final Node parent;
        private final Node grandparent;
        private final BasicBlock basicBlock;
        private final Scope scope;
        private final String sourceName;

        Reference(Node node, Node node2, NodeTraversal nodeTraversal, BasicBlock basicBlock) {
            this(node, node2, node2.getParent(), basicBlock, nodeTraversal.getScope(), nodeTraversal.getSourceName());
        }

        static Reference newBleedingFunction(NodeTraversal nodeTraversal, BasicBlock basicBlock, Node node) {
            return new Reference(node.getFirstChild(), node, node.getParent(), basicBlock, nodeTraversal.getScope(), nodeTraversal.getSourceName());
        }

        private Reference(Node node, Node node2, Node node3, BasicBlock basicBlock, Scope scope, String string) {
            this.nameNode = node;
            this.parent = node2;
            this.grandparent = node3;
            this.basicBlock = basicBlock;
            this.scope = scope;
            this.sourceName = string;
        }

        boolean isDeclaration() {
            return DECLARATION_PARENTS.contains(this.parent.getType()) || this.parent.getType() == 83 && this.grandparent.getType() == 105;
        }

        boolean isVarDeclaration() {
            return this.parent.getType() == 118;
        }

        boolean isHoistedFunction() {
            return NodeUtil.isHoistedFunctionDeclaration(this.parent);
        }

        boolean isInitializingDeclaration() {
            return this.isDeclaration() && (this.parent.getType() != 118 || this.nameNode.getFirstChild() != null);
        }

        Node getAssignedValue() {
            return this.parent.getType() == 105 ? this.parent : NodeUtil.getAssignedValue(this.getNameNode());
        }

        BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        Node getParent() {
            return this.parent;
        }

        Node getNameNode() {
            return this.nameNode;
        }

        Node getGrandparent() {
            return this.grandparent;
        }

        private static boolean isLhsOfForInExpression(Node node) {
            Node node2 = node.getParent();
            if (node2.getType() == 118) {
                return Reference.isLhsOfForInExpression(node2);
            }
            return NodeUtil.isForIn(node2) && node2.getFirstChild() == node;
        }

        boolean isSimpleAssignmentToName() {
            return this.parent.getType() == 86 && this.parent.getFirstChild() == this.nameNode;
        }

        boolean isLvalue() {
            int n = this.parent.getType();
            return n == 118 && this.nameNode.getFirstChild() != null || n == 102 || n == 103 || NodeUtil.isAssignmentOp(this.parent) && this.parent.getFirstChild() == this.nameNode || Reference.isLhsOfForInExpression(this.nameNode);
        }

        Scope getScope() {
            return this.scope;
        }

        public String getSourceName() {
            return this.sourceName;
        }
    }

    static class ReferenceCollection {
        List<Reference> references = Lists.newArrayList();

        ReferenceCollection() {
        }

        void add(Reference reference, NodeTraversal nodeTraversal, Scope.Var var) {
            this.references.add(reference);
        }

        protected boolean isWellDefined() {
            int n = this.references.size();
            if (n == 0) {
                return false;
            }
            Reference reference = this.getInitializingReference();
            if (reference == null) {
                return false;
            }
            Preconditions.checkState((boolean)this.references.get(0).isDeclaration());
            BasicBlock basicBlock = reference.getBasicBlock();
            for (int i = 1; i < n; ++i) {
                if (basicBlock.provablyExecutesBefore(this.references.get(i).getBasicBlock())) continue;
                return false;
            }
            return true;
        }

        boolean isEscaped() {
            Scope scope = null;
            for (Reference reference : this.references) {
                if (scope == null) {
                    scope = reference.scope;
                    continue;
                }
                if (scope == reference.scope) continue;
                return true;
            }
            return false;
        }

        private boolean isInitializingDeclarationAt(int n) {
            Reference reference = this.references.get(n);
            return reference.isInitializingDeclaration();
        }

        private boolean isInitializingAssignmentAt(int n) {
            Reference reference;
            if (n < this.references.size() && n > 0 && (reference = this.references.get(n - 1)).isVarDeclaration()) {
                Preconditions.checkState((!reference.isInitializingDeclaration() ? 1 : 0) != 0);
                Reference reference2 = this.references.get(n);
                if (reference2.isSimpleAssignmentToName()) {
                    return true;
                }
            }
            return false;
        }

        Reference getInitializingReference() {
            if (this.isInitializingDeclarationAt(0)) {
                return this.references.get(0);
            }
            if (this.isInitializingAssignmentAt(1)) {
                return this.references.get(1);
            }
            return null;
        }

        Reference getInitializingReferenceForConstants() {
            int n = this.references.size();
            for (int i = 0; i < n; ++i) {
                if (!this.isInitializingDeclarationAt(i) && !this.isInitializingAssignmentAt(i)) continue;
                return this.references.get(i);
            }
            return null;
        }

        boolean isAssignedOnceInLifetime() {
            Reference reference = this.getOneAndOnlyAssignment();
            if (reference == null) {
                return false;
            }
            for (BasicBlock basicBlock = reference.getBasicBlock(); basicBlock != null && !basicBlock.isFunction; basicBlock = basicBlock.getParent()) {
                if (!basicBlock.isLoop) continue;
                return false;
            }
            return true;
        }

        private Reference getOneAndOnlyAssignment() {
            Reference reference = null;
            int n = this.references.size();
            for (int i = 0; i < n; ++i) {
                Reference reference2 = this.references.get(i);
                if (!reference2.isLvalue() && !reference2.isInitializingDeclaration()) continue;
                if (reference == null) {
                    reference = reference2;
                    continue;
                }
                return null;
            }
            return reference;
        }

        boolean isNeverAssigned() {
            int n = this.references.size();
            for (int i = 0; i < n; ++i) {
                Reference reference = this.references.get(i);
                if (!reference.isLvalue() && !reference.isInitializingDeclaration()) continue;
                return false;
            }
            return true;
        }

        boolean firstReferenceIsAssigningDeclaration() {
            int n = this.references.size();
            return n > 0 && this.references.get(0).isInitializingDeclaration();
        }
    }

    static interface Behavior {
        public void afterExitScope(NodeTraversal var1, Map<Scope.Var, ReferenceCollection> var2);
    }
}

