/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class SourceInformationAnnotator
extends NodeTraversal.AbstractPostOrderCallback {
    private final String sourceFile;
    private final boolean doSanityChecks;

    public SourceInformationAnnotator(String string, boolean bl) {
        this.sourceFile = string;
        this.doSanityChecks = bl;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (this.doSanityChecks && this.sourceFile != null) {
            Preconditions.checkState((boolean)this.sourceFile.equals(node.getProp(16)));
        }
        switch (node.getType()) {
            case 33: {
                Node node3 = node.getLastChild();
                this.setOriginalName(node, node3.getString());
                break;
            }
            case 105: {
                String string = NodeUtil.getNearestFunctionName(node);
                if (string == null) break;
                this.setOriginalName(node, string);
                break;
            }
            case 38: {
                this.setOriginalName(node, node.getString());
                break;
            }
            case 64: {
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                    if (node4.isQuotedString()) continue;
                    this.setOriginalName(node4, node4.getString());
                }
                break;
            }
        }
    }

    void setOriginalName(Node node, String string) {
        if (!string.isEmpty() && node.getProp(40) == null) {
            node.putProp(40, string);
        }
    }
}

