/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class SuspiciousPropertiesCheck
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel checkReads;
    private final CheckLevel checkWrites;
    static final int MAX_REPORTS_PER_PROPERTY = 5;
    static final DiagnosticType READ_WITHOUT_SET = DiagnosticType.warning("JSC_READ_WITHOUT_SET", "property {0} is read here, but never set");
    static final DiagnosticType SET_WITHOUT_READ = DiagnosticType.warning("JSC_SET_WITHOUT_READ", "property {0} is set here, but never read");
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final Map<String, Property> properties = Maps.newHashMap();
    private Set<String> externPropertyNames = Sets.newHashSet();

    SuspiciousPropertiesCheck(AbstractCompiler abstractCompiler, CheckLevel checkLevel, CheckLevel checkLevel2) {
        this.compiler = abstractCompiler;
        this.checkReads = checkLevel;
        this.checkWrites = checkLevel2;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new ProcessExternedProperties());
        NodeTraversal.traverse(this.compiler, node2, new ProcessProperties());
        for (Property property : this.properties.values()) {
            if (property.reads != null) {
                for (Node node3 : property.reads) {
                    this.compiler.report(JSError.make((String)node3.getProp(16), node3, this.checkReads, READ_WITHOUT_SET, node3.getString()));
                }
            }
            if (property.writes == null) continue;
            for (Node node3 : property.writes) {
                this.compiler.report(JSError.make((String)node3.getProp(16), node3, this.checkWrites, SET_WITHOUT_READ, node3.getString()));
            }
        }
    }

    private Property getProperty(String string) {
        Property property = this.properties.get(string);
        if (property == null) {
            property = new Property();
            this.properties.put(string, property);
        }
        return property;
    }

    private boolean isExternallyDefined(String string) {
        return this.externPropertyNames.contains(string);
    }

    private boolean isExported(String string) {
        return this.compiler.getCodingConvention().isExported(string);
    }

    private static class Property {
        int readCount = 0;
        int writeCount = 0;
        List<Node> reads = null;
        List<Node> writes = null;

        Property() {
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    if (node2.getType() == 86 && node2.getFirstChild() == node || NodeUtil.isExpressionNode(node2)) {
                        this.addWrite(node3, nodeTraversal, false);
                        break;
                    }
                    this.addRead(node3, nodeTraversal);
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        this.addWrite(node4, nodeTraversal, true);
                    }
                    break;
                }
                case 37: {
                    Node node5;
                    Node node6 = node.getFirstChild();
                    if (node6.getType() != 38 || !node6.getString().equals("JSCompiler_renameProperty") || (node5 = node6.getNext()).getType() != 40) break;
                    for (String string : DOT_PATTERN.split(node5.getString())) {
                        Property property = SuspiciousPropertiesCheck.this.getProperty(string);
                        ++property.readCount;
                        ++property.writeCount;
                        property.reads = null;
                        property.writes = null;
                    }
                    break;
                }
            }
        }

        private void addRead(Node node, NodeTraversal nodeTraversal) {
            String string = node.getString();
            Property property = SuspiciousPropertiesCheck.this.getProperty(string);
            ++property.readCount;
            if (property.writeCount == 0 && !SuspiciousPropertiesCheck.this.isExternallyDefined(string)) {
                if (SuspiciousPropertiesCheck.this.checkReads.isOn()) {
                    if (property.reads == null) {
                        property.reads = new ArrayList<Node>(5);
                    }
                    if (property.reads.size() < 5) {
                        node.putProp(16, nodeTraversal.getSourceName());
                        property.reads.add(node);
                    }
                }
            } else {
                property.reads = null;
            }
            property.writes = null;
        }

        private void addWrite(Node node, NodeTraversal nodeTraversal, boolean bl) {
            String string = node.getString();
            Property property = SuspiciousPropertiesCheck.this.getProperty(string);
            ++property.writeCount;
            if (property.readCount == 0 && !SuspiciousPropertiesCheck.this.isExported(string)) {
                if (SuspiciousPropertiesCheck.this.checkWrites.isOn() && !bl) {
                    if (property.writes == null) {
                        property.writes = new ArrayList<Node>(5);
                    }
                    if (property.writes.size() < 5) {
                        node.putProp(16, nodeTraversal.getSourceName());
                        property.writes.add(node);
                    }
                }
            } else {
                property.writes = null;
            }
            property.reads = null;
        }
    }

    private class ProcessExternedProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternedProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 35: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    SuspiciousPropertiesCheck.this.externPropertyNames.add(node3.getString());
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        SuspiciousPropertiesCheck.this.externPropertyNames.add(node4.getString());
                    }
                    break;
                }
                case 38: {
                    Scope.Var var;
                    String string = node.getString();
                    if (string.isEmpty() || (var = nodeTraversal.getScope().getVar(string)) == null || var.isLocal()) break;
                    SuspiciousPropertiesCheck.this.externPropertyNames.add(string);
                }
            }
        }
    }
}

