/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    private static final String LEGACY_TYPEDEF = "goog.typedef";
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final List<ObjectType> delegateProxyPrototypes = Lists.newArrayList();

    TypedScopeCreator(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, abstractCompiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler abstractCompiler, CodingConvention codingConvention) {
        this.compiler = abstractCompiler;
        this.validator = abstractCompiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = abstractCompiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.typeRegistry.getErrorReporter();
    }

    @Override
    public Scope createScope(Node node, Scope scope) {
        Object object;
        Scope scope2 = null;
        GlobalScopeBuilder globalScopeBuilder = null;
        if (scope == null) {
            scope2 = this.createInitialScope(node);
            object = new GlobalScopeBuilder(scope2);
            globalScopeBuilder = object;
            NodeTraversal.traverse(this.compiler, node, globalScopeBuilder);
        } else {
            scope2 = new Scope(scope, node);
            object = new LocalScopeBuilder(scope2);
            globalScopeBuilder = object;
            ((LocalScopeBuilder)object).build();
        }
        globalScopeBuilder.resolveStubDeclarations();
        globalScopeBuilder.resolveTypes();
        for (Node node2 : ((AbstractScopeBuilder)globalScopeBuilder).nonExternFunctions) {
            FunctionType functionType;
            ObjectType objectType;
            JSType jSType = node2.getJSType();
            if (jSType == null || !(jSType instanceof FunctionType) || (objectType = (functionType = (FunctionType)jSType).getTypeOfThis()).isUnknownType()) continue;
            Node node3 = node2.getLastChild();
            GlobalScopeBuilder globalScopeBuilder2 = globalScopeBuilder;
            globalScopeBuilder2.getClass();
            NodeTraversal.traverse(this.compiler, node3, globalScopeBuilder2.new AbstractScopeBuilder.CollectProperties(objectType));
        }
        if (scope == null) {
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, scope2, this.delegateProxyPrototypes);
        }
        return scope2;
    }

    @VisibleForTesting
    Scope createInitialScope(Node node) {
        NodeTraversal.traverse(this.compiler, node, new DiscoverEnumsAndTypedefs(this.typeRegistry));
        Scope scope = new Scope(node, this.compiler);
        this.declareNativeFunctionType(scope, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.declareNativeValueType(scope, "undefined", JSTypeNative.VOID_TYPE);
        this.declareNativeValueType(scope, LEGACY_TYPEDEF, JSTypeNative.NO_TYPE);
        this.declareNativeValueType(scope, "ActiveXObject", JSTypeNative.NO_OBJECT_TYPE);
        return scope;
    }

    private void declareNativeFunctionType(Scope scope, JSTypeNative jSTypeNative) {
        FunctionType functionType = this.typeRegistry.getNativeFunctionType(jSTypeNative);
        this.declareNativeType(scope, functionType.getInstanceType().getReferenceName(), functionType);
        this.declareNativeType(scope, functionType.getPrototype().getReferenceName(), functionType.getPrototype());
    }

    private void declareNativeValueType(Scope scope, String string, JSTypeNative jSTypeNative) {
        this.declareNativeType(scope, string, this.typeRegistry.getNativeType(jSTypeNative));
    }

    private void declareNativeType(Scope scope, String string, JSType jSType) {
        scope.declare(string, null, jSType, null, false);
    }

    private static Node getPrototypePropertyOwner(Node node) {
        Node node2;
        Node node3;
        if (node.getType() == 33 && (node3 = node.getFirstChild()).getType() == 33 && node3.getLastChild().getString().equals("prototype") && (node2 = node3.getFirstChild()).isQualifiedName()) {
            return node2;
        }
        return null;
    }

    private JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.typeRegistry.getNativeType(jSTypeNative);
    }

    static JSDocInfo getBestJSDocInfo(Node node) {
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        if (jSDocInfo == null) {
            Node node2 = node.getParent();
            int n = node2.getType();
            if (n == 38) {
                jSDocInfo = node2.getJSDocInfo();
                if (jSDocInfo == null && node2.getParent().hasOneChild()) {
                    jSDocInfo = node2.getParent().getJSDocInfo();
                }
            } else if (n == 86) {
                jSDocInfo = node2.getJSDocInfo();
            } else if (NodeUtil.isObjectLitKey(node2, node2.getParent())) {
                jSDocInfo = node2.getJSDocInfo();
            }
        }
        return jSDocInfo;
    }

    private static Node getBestLValue(Node node) {
        Node node2 = node.getParent();
        int n = node2.getType();
        boolean bl = NodeUtil.isFunctionDeclaration(node);
        if (bl) {
            return node.getFirstChild();
        }
        if (n == 38) {
            return node2;
        }
        if (n == 86) {
            return node2.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(node2, node2.getParent())) {
            return node2;
        }
        return null;
    }

    private static String getBestLValueName(@Nullable Node node) {
        if (node == null || node.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(node, node.getParent())) {
            String string;
            Node node2 = TypedScopeCreator.getBestLValue(node.getParent());
            if (node2 != null && (string = TypedScopeCreator.getBestLValueName(node2)) != null) {
                return string + "." + NodeUtil.getObjectLitKeyName(node);
            }
            return null;
        }
        return node.getQualifiedName();
    }

    private final class LocalScopeBuilder
    extends AbstractScopeBuilder {
        private LocalScopeBuilder(Scope scope) {
            super(scope);
        }

        void build() {
            NodeTraversal.traverse(TypedScopeCreator.this.compiler, this.scope.getRootNode(), this);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node == this.scope.getRootNode()) {
                return;
            }
            if (node.getType() == 83 && node2 == this.scope.getRootNode()) {
                this.handleFunctionInputs(node2);
                return;
            }
            super.visit(nodeTraversal, node, node2);
        }

        private void handleFunctionInputs(Node node) {
            Scope.Var var;
            Node node2 = node.getFirstChild();
            String string = node2.getString();
            if (!string.isEmpty() && ((var = this.scope.getVar(string)) == null || var.getNameNode() != null && var.getInitialValue() != node)) {
                this.defineSlot(node2, node, node.getJSType(), false);
            }
            this.declareArguments(node);
        }

        private void declareArguments(Node node) {
            Node node2;
            Node node3 = node.getFirstChild().getNext();
            Node node4 = node3.getNext();
            FunctionType functionType = (FunctionType)node.getJSType();
            if (functionType != null && (node2 = functionType.getParametersNode()) != null) {
                Node node5 = node2.getFirstChild();
                for (Node node6 : node3.children()) {
                    if (node5 != null) {
                        this.defineSlot(node6, node, node5.getJSType(), true);
                        node5 = node5.getNext();
                        continue;
                    }
                    this.defineSlot(node6, node, null, true);
                }
            }
        }
    }

    private final class GlobalScopeBuilder
    extends AbstractScopeBuilder {
        private GlobalScopeBuilder(Scope scope) {
            super(scope);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            super.visit(nodeTraversal, node, node2);
            switch (node.getType()) {
                case 86: {
                    this.checkForOldStyleTypedef(nodeTraversal, node);
                    break;
                }
                case 118: {
                    if (!node.hasOneChild()) break;
                    this.checkForOldStyleTypedef(nodeTraversal, node);
                    this.checkForTypedef(nodeTraversal, node.getFirstChild(), node.getJSDocInfo());
                }
            }
        }

        @Override
        void maybeDeclareQualifiedName(NodeTraversal nodeTraversal, JSDocInfo jSDocInfo, Node node, Node node2, Node node3) {
            this.checkForTypedef(nodeTraversal, node, jSDocInfo);
            super.maybeDeclareQualifiedName(nodeTraversal, jSDocInfo, node, node2, node3);
        }

        private void checkForTypedef(NodeTraversal nodeTraversal, Node node, JSDocInfo jSDocInfo) {
            if (jSDocInfo == null || !jSDocInfo.hasTypedefType()) {
                return;
            }
            String string = node.getQualifiedName();
            if (string == null) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(string, TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            JSType jSType = jSDocInfo.getTypedefType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            if (jSType == null) {
                TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, MALFORMED_TYPEDEF, string));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(string, jSType);
            if (node.getType() == 33) {
                this.defineSlot(node, node.getParent(), TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE), false);
            }
        }

        private void checkForOldStyleTypedef(NodeTraversal nodeTraversal, Node node) {
            String string = TypedScopeCreator.this.codingConvention.identifyTypeDefAssign(node);
            if (string != null) {
                TypedScopeCreator.this.typeRegistry.declareType(string, TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                JSType jSType = null;
                if (jSDocInfo != null && jSDocInfo.getType() != null) {
                    jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                }
                if (jSType == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, MALFORMED_TYPEDEF, string));
                }
                TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(string, jSType);
            }
        }
    }

    private static final class StubDeclaration {
        private final Node node;
        private final boolean isExtern;
        private final String ownerName;

        private StubDeclaration(Node node, boolean bl, String string) {
            this.node = node;
            this.isExtern = bl;
            this.ownerName = string;
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback {
        final Scope scope;
        private final List<DeferredSetType> deferredSetTypes = Lists.newArrayList();
        private final List<Node> nonExternFunctions = Lists.newArrayList();
        private final List<StubDeclaration> stubDeclarations = Lists.newArrayList();
        private String sourceName = null;

        private AbstractScopeBuilder(Scope scope) {
            this.scope = scope;
        }

        void setDeferredType(Node node, JSType jSType) {
            this.deferredSetTypes.add(new DeferredSetType(node, jSType));
        }

        void resolveTypes() {
            for (DeferredSetType deferredSetType : this.deferredSetTypes) {
                deferredSetType.resolve(this.scope);
            }
            Iterator<Object> iterator = this.scope.getVars();
            while (iterator.hasNext()) {
                ((Scope.Var)iterator.next()).resolveType(TypedScopeCreator.this.typeParsingErrorReporter);
            }
            TypedScopeCreator.this.typeRegistry.resolveTypesInScope(this.scope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            boolean bl;
            if (node.getType() == 105 || node.getType() == 132) {
                this.sourceName = (String)node.getProp(16);
            }
            boolean bl2 = bl = node2 == null || node2.getType() != 105 || node == node2.getFirstChild() || node2 == this.scope.getRootNode();
            if (bl && NodeUtil.isStatementParent(node)) {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    if (!NodeUtil.isHoistedFunctionDeclaration(node3)) continue;
                    this.defineFunctionLiteral(node3, node);
                }
            }
            return bl;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            this.attachLiteralTypes(nodeTraversal, node);
            switch (node.getType()) {
                case 37: {
                    this.checkForClassDefiningCalls(nodeTraversal, node, node2);
                    break;
                }
                case 105: {
                    if (nodeTraversal.getInput() == null || !nodeTraversal.getInput().isExtern()) {
                        this.nonExternFunctions.add(node);
                    }
                    if (NodeUtil.isHoistedFunctionDeclaration(node)) break;
                    this.defineFunctionLiteral(node, node2);
                    break;
                }
                case 86: {
                    Node node3 = node.getFirstChild();
                    if (node3.getType() != 33 || !node3.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(nodeTraversal, node.getJSDocInfo(), node3, node, node3.getNext());
                    break;
                }
                case 120: {
                    this.defineCatch(node, node2);
                    break;
                }
                case 118: {
                    this.defineVar(node, node2);
                    break;
                }
                case 33: {
                    if (node2.getType() != 130 || !node.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(nodeTraversal, node.getJSDocInfo(), node, node2, null);
                }
            }
        }

        private void attachLiteralTypes(NodeTraversal nodeTraversal, Node node) {
            switch (node.getType()) {
                case 41: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case 122: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case 40: {
                    if (NodeUtil.isObjectLitKey(node, node.getParent())) break;
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case 39: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case 43: 
                case 44: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case 47: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case 69: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                    break;
                }
                case 64: {
                    this.defineObjectLiteral(nodeTraversal, node);
                }
            }
        }

        private void defineObjectLiteral(NodeTraversal nodeTraversal, Node node) {
            Object object;
            Object object2;
            JSType jSType = null;
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            if (jSDocInfo != null && jSDocInfo.getLendsName() != null) {
                object2 = jSDocInfo.getLendsName();
                object = this.scope.getVar((String)object2);
                if (object == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, UNKNOWN_LENDS, new String[]{object2}));
                } else {
                    jSType = ((Scope.Var)object).getType();
                    if (jSType == null) {
                        jSType = TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                    }
                    if (!jSType.isSubtype(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, LENDS_ON_NON_OBJECT, new String[]{object2, jSType.toString()}));
                        jSType = null;
                    } else {
                        node.setJSType(jSType);
                    }
                }
            }
            jSDocInfo = TypedScopeCreator.getBestJSDocInfo(node);
            object2 = TypedScopeCreator.getBestLValue(node);
            object = TypedScopeCreator.getBestLValueName((Node)object2);
            boolean bl = false;
            if (jSDocInfo != null && jSDocInfo.hasEnumParameterType()) {
                jSType = this.createEnumTypeFromNodes(node, (String)object, jSDocInfo, (Node)object2);
                bl = true;
            }
            if (jSType == null) {
                jSType = TypedScopeCreator.this.typeRegistry.createAnonymousObjectType();
            }
            this.setDeferredType(node, jSType);
            if (!bl) {
                this.processObjectLitProperties(nodeTraversal, node, ObjectType.cast(node.getJSType()));
            }
        }

        void processObjectLitProperties(NodeTraversal nodeTraversal, Node node, ObjectType objectType) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Node node3 = node2.getFirstChild();
                String string = NodeUtil.getObjectLitKeyName(node2);
                JSDocInfo jSDocInfo = node2.getJSDocInfo();
                JSType jSType = this.getDeclaredType(nodeTraversal.getSourceName(), jSDocInfo, node2, node3);
                JSType jSType2 = NodeUtil.getObjectLitKeyTypeFromValueType(node2, jSType);
                if (jSType2 == null) continue;
                String string2 = TypedScopeCreator.getBestLValueName(node2);
                if (string2 != null) {
                    this.defineSlot(node2, node, string2, jSType2, false);
                } else {
                    this.setDeferredType(node2, jSType2);
                }
                if (objectType == null) continue;
                boolean bl = nodeTraversal.getInput() != null && nodeTraversal.getInput().isExtern();
                objectType.defineDeclaredProperty(string, jSType2, bl, node2);
            }
        }

        private JSType getDeclaredTypeInAnnotation(String string, Node node, JSDocInfo jSDocInfo) {
            Node node2;
            JSType jSType = null;
            Node node3 = node.getType() == 33 ? node.getFirstChild() : (node2 = NodeUtil.isObjectLitKey(node, node.getParent()) ? node.getParent() : null);
            if (jSDocInfo != null) {
                if (jSDocInfo.hasType()) {
                    jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                } else if (FunctionTypeBuilder.isFunctionTypeDeclaration(jSDocInfo)) {
                    String string2 = node.getQualifiedName();
                    jSType = this.createFunctionTypeFromNodes(null, string2, jSDocInfo, node);
                }
            }
            return jSType;
        }

        void assertDefinitionNode(Node node, int n) {
            Preconditions.checkState((this.sourceName != null ? 1 : 0) != 0);
            Preconditions.checkState((node.getType() == n ? 1 : 0) != 0);
        }

        void defineCatch(Node node, Node node2) {
            this.assertDefinitionNode(node, 120);
            Node node3 = node.getFirstChild();
            this.defineSlot(node3, node, null);
        }

        void defineVar(Node node, Node node2) {
            this.assertDefinitionNode(node, 118);
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            if (node.hasMoreThanOneChild()) {
                if (jSDocInfo != null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node node3 : node.children()) {
                    this.defineName(node3, node, node2, node3.getJSDocInfo());
                }
            } else {
                Node node4 = node.getFirstChild();
                this.defineName(node4, node, node2, jSDocInfo != null ? jSDocInfo : node4.getJSDocInfo());
            }
        }

        void defineFunctionLiteral(Node node, Node node2) {
            this.assertDefinitionNode(node, 105);
            Node node3 = TypedScopeCreator.getBestLValue(node);
            JSDocInfo jSDocInfo = TypedScopeCreator.getBestJSDocInfo(node);
            String string = TypedScopeCreator.getBestLValueName(node3);
            FunctionType functionType = this.createFunctionTypeFromNodes(node, string, jSDocInfo, node3);
            this.setDeferredType(node, functionType);
            if (NodeUtil.isFunctionDeclaration(node)) {
                this.defineSlot(node.getFirstChild(), node, functionType);
            }
        }

        private void defineName(Node node, Node node2, Node node3, JSDocInfo jSDocInfo) {
            Node node4 = node.getFirstChild();
            JSType jSType = this.getDeclaredType(this.sourceName, jSDocInfo, node, node4);
            if (jSType == null) {
                CompilerInput compilerInput = TypedScopeCreator.this.compiler.getInput(this.sourceName);
                Preconditions.checkNotNull((Object)compilerInput, (Object)this.sourceName);
                jSType = compilerInput.isExtern() ? TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : null;
            }
            this.defineSlot(node, node2, jSType);
        }

        private boolean shouldUseFunctionLiteralType(FunctionType functionType, JSDocInfo jSDocInfo, Node node) {
            if (jSDocInfo != null) {
                return true;
            }
            if (node != null && NodeUtil.isObjectLitKey(node, node.getParent())) {
                return false;
            }
            return this.scope.isGlobal() || !functionType.isReturnTypeInferred();
        }

        private FunctionType createFunctionTypeFromNodes(@Nullable Node node, @Nullable String string, @Nullable JSDocInfo jSDocInfo, @Nullable Node node2) {
            FunctionType functionType;
            Object object;
            FunctionType functionType2 = null;
            if (node != null && node.isQualifiedName() && this.scope.isGlobal() && (object = this.scope.getVar(node.getQualifiedName())) != null && ((Scope.Var)object).getType() instanceof FunctionType && ((functionType = (FunctionType)((Scope.Var)object).getType()).isConstructor() || functionType.isInterface()) && !functionType.isNativeObjectType()) {
                functionType2 = functionType;
                if (string != null && this.scope.isGlobal()) {
                    TypedScopeCreator.this.typeRegistry.declareType(string, functionType2.getInstanceType());
                }
            }
            if (functionType2 == null) {
                JSType jSType;
                Node node3;
                object = node == null ? node2 : node;
                boolean bl = node != null && node.getType() == 105;
                Node node4 = bl ? node : null;
                Node node5 = bl ? node.getFirstChild().getNext() : null;
                Node node6 = node3 = bl ? node5.getNext() : null;
                if (jSDocInfo != null && jSDocInfo.hasType()) {
                    jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if ((jSType = jSType.restrictByNotNullOrUndefined()).isFunctionType()) {
                        functionType2 = (FunctionType)jSType;
                        functionType2.setJSDocInfo(jSDocInfo);
                    }
                }
                if (functionType2 == null) {
                    Object object2;
                    ObjectType objectType;
                    Object object3;
                    jSType = null;
                    if (node2 != null && node2.getType() == 33 && node2.isQualifiedName() && (object3 = this.scope.getVar(node2.getFirstChild().getQualifiedName())) != null && (objectType = ObjectType.cast(((Scope.Var)object3).getType())) != null) {
                        object2 = node2.getLastChild().getString();
                        jSType = this.findOverriddenFunction(objectType, (String)object2);
                    }
                    object3 = new FunctionTypeBuilder(string, TypedScopeCreator.this.compiler, (Node)object, this.sourceName, this.scope).setSourceNode(node4).inferFromOverriddenFunction((FunctionType)jSType, node5).inferTemplateTypeName(jSDocInfo).inferReturnType(jSDocInfo).inferInheritance(jSDocInfo);
                    boolean bl2 = false;
                    if (node2 != null && node2.getType() == 33) {
                        object2 = node2.getFirstChild();
                        if (((Node)object2).getType() == 33 && ((Node)object2).getLastChild().getString().equals("prototype")) {
                            ((FunctionTypeBuilder)object3).inferThisType(jSDocInfo, ((Node)object2).getFirstChild());
                            bl2 = true;
                        } else if (((Node)object2).getType() == 42) {
                            ((FunctionTypeBuilder)object3).inferThisType(jSDocInfo, ((Node)object2).getJSType());
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        ((FunctionTypeBuilder)object3).inferThisType(jSDocInfo, (Node)null);
                    }
                    functionType2 = ((FunctionTypeBuilder)object3).inferParameterTypes(node5, jSDocInfo).inferReturnStatementsAsLastResort(node3).buildAndRegister();
                }
            }
            return functionType2;
        }

        private FunctionType findOverriddenFunction(ObjectType objectType, String string) {
            JSType jSType = objectType.getPropertyType(string);
            if (jSType instanceof FunctionType) {
                return (FunctionType)jSType;
            }
            for (ObjectType objectType2 : objectType.getCtorImplementedInterfaces()) {
                jSType = objectType2.getPropertyType(string);
                if (!(jSType instanceof FunctionType)) continue;
                return (FunctionType)jSType;
            }
            return null;
        }

        private EnumType createEnumTypeFromNodes(Node node, String string, JSDocInfo jSDocInfo, Node node2) {
            Object object;
            Preconditions.checkNotNull((Object)jSDocInfo);
            Preconditions.checkState((boolean)jSDocInfo.hasEnumParameterType());
            EnumType enumType = null;
            if (node != null && node.isQualifiedName() && (object = this.scope.getVar(node.getQualifiedName())) != null && ((Scope.Var)object).getType() instanceof EnumType) {
                enumType = (EnumType)((Scope.Var)object).getType();
            }
            if (enumType == null) {
                object = jSDocInfo.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                enumType = TypedScopeCreator.this.typeRegistry.createEnumType(string, (JSType)object);
                if (node != null && node.getType() == 64) {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        String string2 = NodeUtil.getStringValue(node3);
                        if (string2 == null) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node3, TypeCheck.ENUM_NOT_CONSTANT, string2));
                            continue;
                        }
                        if (enumType.hasOwnProperty(string2)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node3, TypeCheck.ENUM_DUP, string2));
                            continue;
                        }
                        if (!TypedScopeCreator.this.codingConvention.isValidEnumKey(string2)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node3, TypeCheck.ENUM_NOT_CONSTANT, string2));
                            continue;
                        }
                        enumType.defineElement(string2, node3);
                    }
                }
            }
            if (string != null && this.scope.isGlobal()) {
                TypedScopeCreator.this.typeRegistry.declareType(string, enumType.getElementsType());
            }
            return enumType;
        }

        private void defineSlot(Node node, Node node2, JSType jSType) {
            this.defineSlot(node, node2, jSType, jSType == null);
        }

        void defineSlot(Node node, Node node2, JSType jSType, boolean bl) {
            Preconditions.checkArgument((bl || jSType != null ? 1 : 0) != 0);
            if (node.getType() == 38) {
                Preconditions.checkArgument((node2.getType() == 105 || node2.getType() == 118 || node2.getType() == 83 || node2.getType() == 120 ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((node.getType() == 33 && (node2.getType() == 86 || node2.getType() == 130) ? 1 : 0) != 0);
            }
            this.defineSlot(node, node2, node.getQualifiedName(), jSType, bl);
        }

        void defineSlot(Node node, Node node2, String string, JSType jSType, boolean bl) {
            Object object;
            Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0);
            boolean bl2 = node.getType() == 38 && this.scope.isGlobal();
            boolean bl3 = bl2 && (node2.getType() == 118 || node2.getType() == 105);
            Scope scope = this.scope;
            if (node.getType() == 33 && !this.scope.isGlobal() && this.isQnameRootedInGlobalScope(node) && !((Scope)(object = this.scope.getGlobalScope())).isDeclared(string, false)) {
                scope = this.scope.getGlobalScope();
            }
            if (scope.isDeclared(string, false)) {
                object = scope.getVar(string);
                TypedScopeCreator.this.validator.expectUndeclaredVariable(this.sourceName, node, node2, (Scope.Var)object, string, jSType);
            } else {
                Serializable serializable;
                if (!bl) {
                    this.setDeferredType(node, jSType);
                }
                object = TypedScopeCreator.this.compiler.getInput(this.sourceName);
                boolean bl4 = ((CompilerInput)object).isExtern();
                Scope.Var var = scope.declare(string, node, jSType, (CompilerInput)object, bl);
                if (bl3) {
                    serializable = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                    if (bl) {
                        ((ObjectType)serializable).defineInferredProperty(string, jSType == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : jSType, bl4, node);
                    } else {
                        ((ObjectType)serializable).defineDeclaredProperty(string, jSType, bl4, node);
                    }
                }
                if (jSType instanceof EnumType) {
                    boolean bl5;
                    serializable = var.getInitialValue();
                    boolean bl6 = bl5 = serializable != null && (((Node)serializable).getType() == 64 || ((Node)serializable).isQualifiedName());
                    if (!bl5) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, ENUM_INITIALIZER, new String[0]));
                    }
                }
                if (jSType instanceof FunctionType && !jSType.isEmptyType() && (((FunctionType)(serializable = (FunctionType)jSType)).isConstructor() || ((FunctionType)serializable).isInterface()) && !((JSType)serializable).equals(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE))) {
                    FunctionType functionType = ((FunctionType)serializable).getSuperClassConstructor();
                    scope.declare(string + ".prototype", node, ((FunctionType)serializable).getPrototype(), (CompilerInput)object, functionType == null || functionType.getInstanceType().equals(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
                    if (var.getInitialValue() == null && !bl4 && string.equals(((FunctionType)serializable).getInstanceType().getReferenceName())) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, ((FunctionType)serializable).isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, string));
                    }
                }
            }
            if (bl2 && "Window".equals(string) && jSType instanceof FunctionType && jSType.isConstructor()) {
                object = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS).getConstructor();
                ((FunctionType)object).getInstanceType().clearCachedValues();
                ((FunctionType)object).getPrototype().clearCachedValues();
                ((FunctionType)object).setPrototypeBasedOn(((FunctionType)jSType).getInstanceType());
            }
        }

        private boolean isQnameRootedInGlobalScope(Node node) {
            Scope.Var var;
            Node node2 = NodeUtil.getRootOfQualifiedName(node);
            if (node2.getType() == 38 && (var = this.scope.getVar(node2.getString())) != null) {
                return var.isGlobal();
            }
            return false;
        }

        private JSType getDeclaredType(String string, JSDocInfo jSDocInfo, Node node, @Nullable Node node2) {
            if (jSDocInfo != null && jSDocInfo.hasType()) {
                return this.getDeclaredTypeInAnnotation(string, node, jSDocInfo);
            }
            if (node2 != null && node2.getType() == 105 && this.shouldUseFunctionLiteralType((FunctionType)node2.getJSType(), jSDocInfo, node)) {
                return node2.getJSType();
            }
            if (jSDocInfo != null) {
                if (jSDocInfo.hasEnumParameterType()) {
                    if (node2 != null && node2.getType() == 64) {
                        return node2.getJSType();
                    }
                    return this.createEnumTypeFromNodes(node2, node.getQualifiedName(), jSDocInfo, node);
                }
                if (jSDocInfo.isConstructor() || jSDocInfo.isInterface()) {
                    return this.createFunctionTypeFromNodes(node2, node.getQualifiedName(), jSDocInfo, node);
                }
                if (jSDocInfo.isConstant()) {
                    Object var5_5 = null;
                    if (node2 != null) {
                        if (node2.getJSType() != null && !node2.getJSType().isUnknownType()) {
                            return node2.getJSType();
                        }
                        if (node2.getType() == 100) {
                            boolean bl;
                            Node node3 = node2.getFirstChild();
                            Node node4 = node3.getNext();
                            boolean bl2 = bl = node3.getType() == 38 && node.getType() == 38 && node3.getString().equals(node.getString());
                            if (bl && node4.getJSType() != null && !node4.getJSType().isUnknownType()) {
                                return node4.getJSType();
                            }
                        }
                    }
                }
            }
            return this.getDeclaredTypeInAnnotation(string, node, jSDocInfo);
        }

        private void checkForClassDefiningCalls(NodeTraversal nodeTraversal, Node node, Node node2) {
            ObjectType objectType;
            Object object;
            Object object2;
            Object object3;
            CodingConvention.SubclassRelationship subclassRelationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(node);
            if (subclassRelationship != null) {
                object3 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(subclassRelationship.superclassName));
                object2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(subclassRelationship.subclassName));
                if (object3 != null && object2 != null) {
                    object = ((ObjectType)object3).getConstructor();
                    objectType = ((ObjectType)object2).getConstructor();
                    if (subclassRelationship.type == CodingConvention.SubclassType.INHERITS) {
                        TypedScopeCreator.this.validator.expectSuperType(nodeTraversal, node, (ObjectType)object3, (ObjectType)object2);
                    }
                    if (object != null && objectType != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship((FunctionType)object, (FunctionType)objectType, subclassRelationship.type);
                    }
                }
            }
            if ((object3 = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(node)) != null && (object2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType((String)object3))) != null && (object = ((ObjectType)object2).getConstructor()) != null) {
                objectType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)object2, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter((FunctionType)object, (FunctionType)objectType, (ObjectType)object2);
            }
            if ((object2 = TypedScopeCreator.this.codingConvention.getDelegateRelationship(node)) != null) {
                this.applyDelegateRelationship((CodingConvention.DelegateRelationship)object2);
            }
            if ((object = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(nodeTraversal, node)) != null) {
                objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(((CodingConvention.ObjectLiteralCast)object).typeName));
                if (objectType != null && objectType.getConstructor() != null) {
                    this.setDeferredType(((CodingConvention.ObjectLiteralCast)object).objectNode, objectType);
                } else {
                    TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, CONSTRUCTOR_EXPECTED, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegator));
            ObjectType objectType2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegateBase));
            ObjectType objectType3 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (objectType != null && objectType2 != null && objectType3 != null) {
                FunctionType functionType = objectType.getConstructor();
                FunctionType functionType2 = objectType2.getConstructor();
                FunctionType functionType3 = objectType3.getConstructor();
                if (functionType != null && functionType2 != null && functionType3 != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType functionType4 = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(objectType2), functionParamBuilder.build());
                    FunctionType functionType5 = TypedScopeCreator.this.typeRegistry.createConstructorType(objectType2.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null);
                    functionType5.setPrototypeBasedOn(objectType2);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(objectType3, objectType2, objectType, functionType5, functionType4);
                    TypedScopeCreator.this.delegateProxyPrototypes.add(functionType5.getPrototype());
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal nodeTraversal, JSDocInfo jSDocInfo, Node node, Node node2, Node node3) {
            ObjectType objectType;
            Object object;
            Node node4 = node.getFirstChild();
            String string = node4.getQualifiedName();
            String string2 = node.getQualifiedName();
            String string3 = node.getLastChild().getString();
            Preconditions.checkArgument((string2 != null && string != null ? 1 : 0) != 0);
            if ("prototype".equals(string3) && (object = this.scope.getVar(string2)) != null) {
                if (!((Scope.Var)object).isTypeInferred()) {
                    return;
                }
                if (((Scope.Var)object).getScope() == this.scope) {
                    this.scope.undeclare((Scope.Var)object);
                }
            }
            if ((object = this.getDeclaredType(nodeTraversal.getSourceName(), jSDocInfo, node, node3)) == null && node3 != null) {
                object = node3.getJSType();
            }
            if (object == null) {
                if (node2.getType() == 130) {
                    this.stubDeclarations.add(new StubDeclaration(node, nodeTraversal.getInput() != null && nodeTraversal.getInput().isExtern(), string));
                }
                return;
            }
            boolean bl = true;
            if (jSDocInfo != null) {
                boolean bl2 = bl = !jSDocInfo.hasType() && !jSDocInfo.hasEnumParameterType() && (!jSDocInfo.isConstant() || object == null || ((JSType)object).isUnknownType()) && !FunctionTypeBuilder.isFunctionTypeDeclaration(jSDocInfo);
            }
            if (bl) {
                boolean bl3 = bl = node3 == null || node3.getType() != 105 || this.scope.isDeclared(string2, false);
            }
            if (!bl) {
                ObjectType objectType2 = this.getObjectSlot(string);
                if (objectType2 != null) {
                    boolean bl4;
                    boolean bl5 = bl4 = nodeTraversal.getInput() != null && nodeTraversal.getInput().isExtern();
                    if (!(objectType2.hasOwnProperty(string3) && !objectType2.isPropertyTypeInferred(string3) || (!bl4 || objectType2.isNativeObjectType()) && objectType2.isInstanceType())) {
                        objectType2.defineDeclaredProperty(string3, (JSType)object, bl4, node);
                    }
                }
                this.defineSlot(node, node2, (JSType)object, bl);
            } else if (node3 != null && node3.getType() == 44 && (objectType = this.getObjectSlot(string)) instanceof FunctionType) {
                JSType jSType;
                ObjectType objectType3 = ((FunctionType)objectType).getTypeOfThis();
                String string4 = TypedScopeCreator.this.codingConvention.getDelegateSuperclassName();
                JSType jSType2 = jSType = string4 == null ? null : TypedScopeCreator.this.typeRegistry.getType(string4);
                if (jSType != null && objectType3.isSubtype(jSType)) {
                    this.defineSlot(node, node2, TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE), true);
                }
            }
        }

        private ObjectType getObjectSlot(String string) {
            Scope.Var var = this.scope.getVar(string);
            if (var != null) {
                JSType jSType = var.getType();
                return ObjectType.cast(jSType == null ? null : jSType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        void resolveStubDeclarations() {
            for (StubDeclaration stubDeclaration : this.stubDeclarations) {
                Node node = stubDeclaration.node;
                Node node2 = node.getParent();
                String string = node.getQualifiedName();
                String string2 = node.getLastChild().getString();
                String string3 = stubDeclaration.ownerName;
                boolean bl = stubDeclaration.isExtern;
                if (this.scope.isDeclared(string, false)) continue;
                ObjectType objectType = this.getObjectSlot(string3);
                ObjectType objectType2 = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
                this.defineSlot(node, node2, objectType2, true);
                if (objectType != null && (bl || objectType.isFunctionPrototypeType())) {
                    objectType.defineInferredProperty(string2, objectType2, bl, node);
                    continue;
                }
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(string2, objectType == null ? objectType2 : objectType);
            }
        }

        private final class CollectProperties
        extends NodeTraversal.AbstractShallowStatementCallback {
            private final ObjectType thisType;

            CollectProperties(ObjectType objectType) {
                this.thisType = objectType;
            }

            @Override
            public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                if (node.getType() == 130) {
                    Node node3 = node.getFirstChild();
                    switch (node3.getType()) {
                        case 86: {
                            this.maybeCollectMember(nodeTraversal, node3.getFirstChild(), node3, node3.getLastChild());
                            break;
                        }
                        case 33: {
                            this.maybeCollectMember(nodeTraversal, node3, node3, null);
                        }
                    }
                }
            }

            private void maybeCollectMember(NodeTraversal nodeTraversal, Node node, Node node2, @Nullable Node node3) {
                JSDocInfo jSDocInfo = node2.getJSDocInfo();
                if (jSDocInfo == null || node.getType() != 33 || node.getFirstChild().getType() != 42) {
                    return;
                }
                node.getFirstChild().setJSType(this.thisType);
                JSType jSType = AbstractScopeBuilder.this.getDeclaredType(nodeTraversal.getSourceName(), jSDocInfo, node, node3);
                Node node4 = node.getLastChild();
                if (jSType != null && (node4.getType() == 38 || node4.getType() == 40)) {
                    this.thisType.defineDeclaredProperty(node4.getString(), jSType, false, node);
                }
            }
        }
    }

    private static class DiscoverEnumsAndTypedefs
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        DiscoverEnumsAndTypedefs(JSTypeRegistry jSTypeRegistry) {
            this.registry = jSTypeRegistry;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object var4_4 = null;
            switch (node.getType()) {
                case 118: {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        this.identifyNameNode(node3, node3.getFirstChild(), NodeUtil.getInfoForNameNode(node3));
                    }
                    break;
                }
                case 130: {
                    Node node4 = node.getFirstChild();
                    if (node4.getType() == 86) {
                        this.identifyNameNode(node4.getFirstChild(), node4.getLastChild(), node4.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(node4, null, node4.getJSDocInfo());
                }
            }
        }

        private void identifyNameNode(Node node, Node node2, JSDocInfo jSDocInfo) {
            if (node.isQualifiedName()) {
                if (jSDocInfo != null) {
                    if (jSDocInfo.hasEnumParameterType()) {
                        this.registry.identifyNonNullableName(node.getQualifiedName());
                    } else if (jSDocInfo.hasTypedefType()) {
                        this.registry.identifyNonNullableName(node.getQualifiedName());
                    }
                }
                if (node2 != null && TypedScopeCreator.LEGACY_TYPEDEF.equals(node2.getQualifiedName())) {
                    this.registry.identifyNonNullableName(node.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType jSType) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)jSType);
            this.node = node;
            this.type = jSType;
            node.setJSType(jSType);
        }

        void resolve(Scope scope) {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter, scope));
        }
    }
}

