/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class UnfoldCompoundAssignments
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;

    public UnfoldCompoundAssignments(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 102: 
            case 103: {
                this.unfoldIncrDecr(node, node.getType() == 102);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.unfoldCompoundAssignment(node);
            }
        }
    }

    private void unfoldIncrDecr(Node node, boolean bl) {
        Preconditions.checkArgument((this.isPrefix(node) || this.valueIsDiscarded(node) ? 1 : 0) != 0, (Object)"Unfolding postfix ++/-- requires that the result be ignored.");
        Node node2 = node.getFirstChild().cloneTree();
        Preconditions.checkArgument((!NodeUtil.mayHaveSideEffects(node2) ? 1 : 0) != 0, (Object)"Cannot unfold compound assignment if LHS can have side effects");
        if (bl) {
            node2 = new Node(28, node2);
        }
        node.setType(86);
        Node node3 = new Node(bl ? 21 : 22, node2, Node.newNumber(1.0));
        node3.copyInformationFromForTree(node);
        node.addChildToBack(node3);
        this.compiler.reportCodeChange();
    }

    private boolean valueIsDiscarded(Node node) {
        Node node2 = node.getParent();
        switch (node2.getType()) {
            case 130: {
                return true;
            }
            case 85: {
                return node2.getFirstChild() == node;
            }
            case 115: {
                Preconditions.checkArgument((!NodeUtil.isForIn(node2) ? 1 : 0) != 0, (Object)"Error: the child of a FOR-IN cannot be an INC or DEC");
                return node2.getChildAtIndex(2) == node;
            }
        }
        return false;
    }

    private boolean isPrefix(Node node) {
        Preconditions.checkArgument((node.getType() == 102 || node.getType() == 103 ? 1 : 0) != 0, (Object)"isPrefix can only be called on INC and DEC nodes");
        return node.getIntProp(32) == 0;
    }

    private void unfoldCompoundAssignment(Node node) {
        Node node2 = node.getFirstChild();
        Preconditions.checkArgument((!NodeUtil.mayHaveSideEffects(node2) ? 1 : 0) != 0, (Object)"Cannot unfold compound assignment if LHS can have side effects");
        Node node3 = node.cloneTree();
        node3.setType(NodeUtil.getOpFromAssignmentOp(node));
        node.replaceChildAfter(node2, node3);
        node.setType(86);
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized(), (Object)"UnfoldCompoundAssignments requires a normalized AST");
        NodeTraversal.traverse(this.compiler, node2, this);
    }
}

