/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotatable;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public abstract class Graph<N, E>
implements AdjacencyGraph<N, E> {
    private Deque<GraphAnnotationState> nodeAnnotationStack;
    private Deque<GraphAnnotationState> edgeAnnotationStack;

    public abstract void connect(N var1, E var2, N var3);

    public abstract void disconnect(N var1, N var2);

    public final void connectIfNotFound(N n, E e, N n2) {
        if (!this.isConnected(n, e, n2)) {
            this.connect(n, e, n2);
        }
    }

    public abstract GraphNode<N, E> createNode(N var1);

    @Override
    public abstract Collection<GraphNode<N, E>> getNodes();

    public abstract List<GraphEdge<N, E>> getEdges();

    public abstract int getNodeDegree(N var1);

    @Override
    public int getWeight(N n) {
        return this.getNodeDegree(n);
    }

    public abstract List<GraphNode<N, E>> getNeighborNodes(N var1);

    public abstract Iterator<GraphNode<N, E>> getNeighborNodesIterator(N var1);

    public abstract List<GraphEdge<N, E>> getEdges(N var1, N var2);

    public abstract GraphEdge<N, E> getFirstEdge(N var1, N var2);

    public final boolean hasNode(N n) {
        return this.getNode(n) != null;
    }

    public abstract boolean isConnected(N var1, N var2);

    public abstract boolean isConnected(N var1, E var2, N var3);

    <T extends GraphNode<N, E>> T getNodeOrFail(N n) {
        GraphNode graphNode = this.getNode(n);
        if (graphNode == null) {
            throw new IllegalArgumentException(n + " does not exist in graph");
        }
        return (T)graphNode;
    }

    @Override
    public final void clearNodeAnnotations() {
        for (GraphNode<N, E> graphNode : this.getNodes()) {
            graphNode.setAnnotation(null);
        }
    }

    public final void clearEdgeAnnotations() {
        for (GraphEdge<N, E> graphEdge : this.getEdges()) {
            graphEdge.setAnnotation(null);
        }
    }

    public final void pushNodeAnnotations() {
        if (this.nodeAnnotationStack == null) {
            this.nodeAnnotationStack = Lists.newLinkedList();
        }
        Graph.pushAnnotations(this.nodeAnnotationStack, this.getNodes());
    }

    public final void popNodeAnnotations() {
        Preconditions.checkNotNull(this.nodeAnnotationStack, (Object)"Popping node annotations without pushing.");
        Graph.popAnnotations(this.nodeAnnotationStack);
    }

    public final void pushEdgeAnnotations() {
        if (this.edgeAnnotationStack == null) {
            this.edgeAnnotationStack = Lists.newLinkedList();
        }
        Graph.pushAnnotations(this.edgeAnnotationStack, this.getEdges());
    }

    public final void popEdgeAnnotations() {
        Preconditions.checkNotNull(this.edgeAnnotationStack, (Object)"Popping edge annotations without pushing.");
        Graph.popAnnotations(this.edgeAnnotationStack);
    }

    private static void pushAnnotations(Deque<GraphAnnotationState> deque, Collection<? extends Annotatable> collection) {
        deque.push(new GraphAnnotationState(collection.size()));
        for (Annotatable annotatable : collection) {
            deque.peek().add(new AnnotationState(annotatable, (Annotation)annotatable.getAnnotation()));
            annotatable.setAnnotation(null);
        }
    }

    private static void popAnnotations(Deque<GraphAnnotationState> deque) {
        for (AnnotationState annotationState : deque.pop()) {
            annotationState.first.setAnnotation(annotationState.second);
        }
    }

    class SimpleSubGraph<N, E>
    implements SubGraph<N, E> {
        private Graph<N, E> graph;
        private List<GraphNode<N, E>> nodes = Lists.newArrayList();

        SimpleSubGraph(Graph<N, E> graph2) {
            this.graph = graph2;
        }

        @Override
        public boolean isIndependentOf(N n) {
            GraphNode graphNode = this.graph.getNode(n);
            for (GraphNode<N, E> graphNode2 : this.nodes) {
                if (!this.graph.getNeighborNodes(graphNode2.getValue()).contains(graphNode)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addNode(N n) {
            this.nodes.add(this.graph.getNodeOrFail(n));
        }
    }

    public static interface GraphEdge<N, E>
    extends Annotatable {
        public E getValue();

        public GraphNode<N, E> getNodeA();

        public GraphNode<N, E> getNodeB();
    }

    private static class GraphAnnotationState
    extends ArrayList<AnnotationState> {
        private static final long serialVersionUID = 1L;

        public GraphAnnotationState(int n) {
            super(n);
        }
    }

    private static final class AnnotationState {
        private final Annotatable first;
        private final Annotation second;

        public AnnotationState(Annotatable annotatable, Annotation annotation) {
            this.first = annotatable;
            this.second = annotation;
        }
    }
}

