/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.parsing.Annotation;
import java.util.Map;
import java.util.Set;

public class Config {
    final boolean parseJsDocDocumentation;
    final boolean isIdeMode;
    final Map<String, Annotation> annotationNames;
    final Set<String> suppressionNames;
    final LanguageMode languageMode;
    final boolean acceptConstKeyword;

    Config(Set<String> set, Set<String> set2, boolean bl, LanguageMode languageMode, boolean bl2) {
        this.annotationNames = Config.buildAnnotationNames(set);
        this.parseJsDocDocumentation = bl;
        this.suppressionNames = set2;
        this.isIdeMode = bl;
        this.languageMode = languageMode;
        this.acceptConstKeyword = bl2;
    }

    private static Map<String, Annotation> buildAnnotationNames(Set<String> set) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(Annotation.recognizedAnnotations);
        for (String string : set) {
            if (Annotation.recognizedAnnotations.containsKey(string)) continue;
            builder.put((Object)string, (Object)Annotation.NOT_IMPLEMENTED);
        }
        return builder.build();
    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT;

    }
}

